/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.datereminder;

import java.util.ArrayList;
import java.util.Collection;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.publication.datereminder.PublicationNoteReference;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.datereminder.persistence.PersistentResourceDateReminder;
import org.silverpeas.core.notification.user.FallbackToCoreTemplatePathBehavior;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.URLUtil;

public class PublicationDateReminderUserNotification
extends AbstractTemplateUserNotificationBuilder<PersistentResourceDateReminder>
implements FallbackToCoreTemplatePathBehavior {
    private final PublicationDetail pubDetail;

    PublicationDateReminderUserNotification(PersistentResourceDateReminder resourceDateReminder) {
        super(resourceDateReminder);
        PublicationNoteReference pubNoteReference = (PublicationNoteReference)resourceDateReminder.getResource(PublicationNoteReference.class);
        this.pubDetail = pubNoteReference != null ? pubNoteReference.getEntity() : null;
    }

    @Override
    protected String getBundleSubjectKey() {
        return "dateReminder.notifSubjectDateReminder";
    }

    @Override
    protected Collection<String> getUserIdsToNotify() {
        ArrayList<String> userIds = new ArrayList<String>();
        String creatorId = this.pubDetail.getCreatorId();
        userIds.add(creatorId);
        String updaterId = this.pubDetail.getUpdaterId();
        if (!creatorId.equals(updaterId)) {
            userIds.add(updaterId);
        }
        return userIds;
    }

    @Override
    protected void performTemplateData(String language, PersistentResourceDateReminder resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getBundle(language).getString(this.getBundleSubjectKey()), "");
        template.setAttribute("resourceTitle", (Object)Encode.forHtml((String)this.pubDetail.getName(language)));
        template.setAttribute("resourceDesc", (Object)this.pubDetail.getDescription(language));
        template.setAttribute("resourceNote", (Object)Encode.forHtml((String)resource.getDateReminder().getMessage()));
        String updatedId = this.pubDetail.getUpdaterId();
        template.setAttribute("senderName", (Object)UserDetail.getById(updatedId).getDisplayedName());
    }

    @Override
    protected void performNotificationResource(String language, PersistentResourceDateReminder resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(this.pubDetail.getTitle());
        notificationResourceData.setResourceDescription(this.pubDetail.getDescription());
    }

    @Override
    protected String getResourceURL(PersistentResourceDateReminder resource) {
        return URLUtil.getSearchResultURL(this.pubDetail);
    }

    @Override
    protected String getTemplatePath() {
        return "dateReminder";
    }

    @Override
    protected String getTemplateFileName() {
        return "dateReminder";
    }

    @Override
    protected NotifAction getAction() {
        return null;
    }

    @Override
    protected String getComponentInstanceId() {
        return this.pubDetail.getPK().getInstanceId();
    }

    @Override
    protected String getSender() {
        return "";
    }

    @Override
    protected boolean isSendImmediately() {
        return true;
    }

    @Override
    protected String getLocalizationBundlePath() {
        return "org.silverpeas.dateReminder.multilang.dateReminder";
    }

    @Override
    protected String getContributionAccessLinkLabelBundleKey() {
        return "dateReminder.notifPublicationLinkLabel";
    }
}

