/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.wysiwyg.service;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.content.wysiwyg.WysiwygException;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygManager;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.CoreContributionType;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.util.Pair;

public class WysiwygController {
    public static final String WYSIWYG_CONTEXT = WysiwygManager.WYSIWYG_CONTEXT;
    public static final String WYSIWYG_WEBSITES = "webSites";

    private WysiwygController() {
    }

    private static LocalizedContribution contributionFrom(String componentId, String objectId, String language) {
        return WysiwygController.contributionFrom(componentId, objectId, language, true);
    }

    private static LocalizedContribution contributionFrom(String componentId, String objectId, String language, boolean indexable) {
        return new WysiwygLocalizedContribution(componentId, objectId, language, indexable);
    }

    protected static WysiwygManager getManager() {
        return (WysiwygManager)ServiceProvider.getService(WysiwygManager.class, (Annotation[])new Annotation[0]);
    }

    public static List<SimpleDocument> getImages(String id, String componentId) {
        return WysiwygController.getManager().getImages(id, componentId);
    }

    public static String getWebsiteRepository() {
        return WysiwygController.getManager().getWebsiteRepository();
    }

    public static String[][] getWebsiteImages(String path, String componentId) throws WysiwygException {
        return WysiwygController.getManager().getWebsiteImages(path, componentId);
    }

    public static String[][] getWebsitePages(String path, String componentId) throws WysiwygException {
        return WysiwygController.getManager().getWebsitePages(path, componentId);
    }

    public static String getWysiwygFileName(String objectId, String currentLanguage) {
        return WysiwygController.getManager().getWysiwygFileName(objectId, currentLanguage);
    }

    public static String getImagesFileName(String objectId) {
        return WysiwygController.getManager().getImagesFileName(objectId);
    }

    public static void deleteFileAndAttachment(String componentId, String id) {
        WysiwygController.getManager().deleteFileAndAttachment(componentId, id);
    }

    public static void deleteFile(String componentId, String objectId, String language) {
        WysiwygController.getManager().deleteFile(componentId, objectId, language);
    }

    public static void createFileAndAttachment(String textHtml, ResourceReference resource, String context, String userId, String contentLanguage) {
        WysiwygContent content = new WysiwygContent(WysiwygController.contributionFrom(resource.getInstanceId(), resource.getId(), contentLanguage), textHtml).authoredBy(User.getById((String)userId));
        WysiwygController.getManager().createFileAndAttachment(content, context);
    }

    public static void createFileAndAttachment(String textHtml, ResourceReference resource, String userId, String contentLanguage) {
        WysiwygContent content = new WysiwygContent(WysiwygController.contributionFrom(resource.getInstanceId(), resource.getId(), contentLanguage), textHtml).authoredBy(User.getById((String)userId));
        WysiwygController.getManager().createFileAndAttachment(content);
    }

    public static void createUnindexedFileAndAttachment(String textHtml, ResourceReference resource, String userId, String contentLanguage) {
        WysiwygContent content = new WysiwygContent(WysiwygController.contributionFrom(resource.getInstanceId(), resource.getId(), contentLanguage), textHtml).authoredBy(User.getById((String)userId));
        WysiwygController.getManager().createUnindexedFileAndAttachment(content);
    }

    public static void addToIndex(FullIndexEntry indexEntry, ResourceReference pk, String language) {
        WysiwygController.getManager().addToIndex(indexEntry, pk, language);
    }

    public static void updateFileAndAttachment(String textHtml, String componentId, String objectId, String userId, String language) {
        WysiwygContent content = new WysiwygContent(WysiwygController.contributionFrom(componentId, objectId, language), textHtml).authoredBy(User.getById((String)userId));
        WysiwygController.getManager().updateFileAndAttachment(content);
    }

    public static void updateFileAndAttachment(String textHtml, String componentId, String objectId, String userId, String language, boolean indexIt) {
        WysiwygContent content = new WysiwygContent(WysiwygController.contributionFrom(componentId, objectId, language, indexIt), textHtml).authoredBy(User.getById((String)userId));
        WysiwygController.getManager().updateFileAndAttachment(content);
    }

    public static void save(String textHtml, String componentId, String objectId, String userId, String language, boolean indexIt) {
        WysiwygContent content = new WysiwygContent(WysiwygController.contributionFrom(componentId, objectId, language, indexIt), textHtml).authoredBy(User.getById((String)userId));
        WysiwygController.getManager().save(content);
    }

    public static void deleteWysiwygAttachments(String componentId, String objectId) {
        WysiwygController.getManager().deleteWysiwygAttachments(componentId, objectId);
    }

    public static void deleteWysiwygAttachmentsOnly(String componentId, String objectId) throws WysiwygException {
        WysiwygController.getManager().deleteWysiwygAttachmentsOnly(componentId, objectId);
    }

    public static WysiwygContent get(LocalizedContribution contribution) {
        return WysiwygController.getManager().getByContribution(contribution);
    }

    public static WysiwygContent get(String componentId, String objectId, String language) {
        return WysiwygController.get(WysiwygController.contributionFrom(componentId, objectId, language));
    }

    public static String load(String componentId, String objectId, String language) {
        return WysiwygController.get(componentId, objectId, language).getRenderer().renderEdition();
    }

    public static String loadForReadOnly(String componentId, String objectId, String language) {
        return WysiwygController.get(componentId, objectId, language).getRenderer().renderView();
    }

    public static List<String> getEmbeddedAttachmentIds(String content) {
        return WysiwygController.getManager().getEmbeddedAttachmentIds(content);
    }

    public static String loadFileWebsite(String path, String fileName) throws WysiwygException {
        return WysiwygController.getManager().loadFileWebsite(path, fileName);
    }

    public static boolean haveGotWysiwygToDisplay(String componentId, String objectId, String language) {
        return WysiwygController.getManager().haveGotWysiwygToDisplay(WysiwygController.contributionFrom(componentId, objectId, language));
    }

    public static boolean haveGotWysiwyg(String componentId, String objectId, String language) {
        return WysiwygController.getManager().haveGotWysiwyg(WysiwygController.contributionFrom(componentId, objectId, language));
    }

    public static void updateWebsite(String cheminFichier, String nomFichier, String contenuFichier) throws WysiwygException {
        WysiwygController.getManager().updateWebsite(cheminFichier, nomFichier, contenuFichier);
    }

    public static Map<String, String> copy(String oldComponentId, String oldObjectId, String componentId, String objectId, String userId) {
        return WysiwygController.getManager().copy(oldComponentId, oldObjectId, componentId, objectId, userId);
    }

    public static Pair<String, Map<String, String>> copyDocumentsBetweenTwoResourcesWithSourceContent(ResourceReference sourceRef, ResourceReference targetRef, String sourceContent) {
        return WysiwygController.getManager().copyDocumentsBetweenTwoResourcesWithSourceContent(sourceRef, targetRef, sourceContent);
    }

    public static void move(String fromComponentId, String fromObjectId, String componentId, String objectId) {
        WysiwygController.getManager().move(fromComponentId, fromObjectId, componentId, objectId);
    }

    public static void wysiwygPlaceHaveChanged(String oldComponentId, String oldObjectId, String newComponentId, String newObjectId) {
        WysiwygController.getManager().wysiwygPlaceHaveChanged(oldComponentId, oldObjectId, newComponentId, newObjectId);
    }

    public static String getWysiwygPath(String componentId, String objectId, String language) {
        return WysiwygController.getManager().getWysiwygPath(componentId, objectId, language);
    }

    public static String getWysiwygPath(String componentId, String objectId) {
        return WysiwygController.getManager().getWysiwygPath(componentId, objectId);
    }

    public static List<ComponentInstLight> getGalleries() {
        return WysiwygController.getManager().getGalleries();
    }

    public static void indexEmbeddedLinkedFiles(FullIndexEntry indexEntry, List<String> embeddedAttachmentIds) {
        WysiwygController.getManager().indexEmbeddedLinkedFiles(indexEntry, embeddedAttachmentIds);
    }

    private static class WysiwygLocalizedContribution
    implements LocalizedContribution {
        private final String componentId;
        private final String objectId;
        private final String language;
        private final boolean indexable;

        public WysiwygLocalizedContribution(String componentId, String objectId, String language, boolean indexable) {
            this.componentId = componentId;
            this.objectId = objectId;
            this.language = language;
            this.indexable = indexable;
        }

        public ContributionIdentifier getIdentifier() {
            return ContributionIdentifier.from((String)this.componentId, (String)this.objectId, (CoreContributionType)CoreContributionType.WYSIWYG);
        }

        public User getCreator() {
            return null;
        }

        public Date getCreationDate() {
            return null;
        }

        public User getLastUpdater() {
            return null;
        }

        public Date getLastUpdateDate() {
            return null;
        }

        public boolean canBeAccessedBy(User user) {
            return true;
        }

        public String getLanguage() {
            return this.language;
        }

        public boolean isIndexable() {
            return this.indexable;
        }
    }
}

