/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ecs.html.Input;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.SequenceField;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.util.StringUtil;

public class SequenceFieldDisplayer
extends AbstractFieldDisplayer<SequenceField> {
    @Override
    public void display(PrintWriter out, SequenceField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        SequenceField sequenceField = null;
        if ("sequence".equals(field.getTypeName())) {
            sequenceField = field;
        }
        String language = pagesContext.getLanguage();
        String fieldName = template.getFieldName();
        String value = "";
        if (field.isNull()) {
            if (sequenceField != null) {
                Map<String, String> parameters = template.getParameters(language);
                int minLength = 1;
                if (parameters.containsKey("minLength")) {
                    minLength = Integer.parseInt(parameters.get("minLength"));
                }
                int startValue = 1;
                if (parameters.containsKey("startValue")) {
                    startValue = Integer.parseInt(parameters.get("startValue"));
                }
                boolean reuseAvailableValues = StringUtil.getBooleanValue((String)parameters.get("reuseAvailableValues"));
                boolean global = StringUtil.getBooleanValue((String)parameters.get("global"));
                value = sequenceField.getNextValue(fieldName, template.getTemplateName(), pagesContext.getComponentId(), minLength, startValue, reuseAvailableValues, global);
            }
        } else {
            value = field.getValue(language);
        }
        Input input2 = new Input();
        input2.setID(fieldName);
        input2.setName(fieldName);
        input2.setValue(WebEncodeHelper.javaStringToHtmlString((String)value));
        input2.setType("text");
        input2.setSize(value.length() + 2);
        input2.setReadOnly(true);
        out.println(input2);
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }

    @Override
    public boolean isDisplayedMandatory() {
        return false;
    }

    @Override
    public List<String> update(String value, SequenceField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!"sequence".equals(field.getTypeName())) {
            throw new FormException("Incorrect field type '{0}', expected; {0}", "sequence");
        }
        if (!field.acceptValue(value, pagesContext.getLanguage())) {
            throw new FormException("Incorrect field value type. Expected {0}", "sequence");
        }
        field.setValue(value, pagesContext.getLanguage());
        return new ArrayList<String>();
    }
}

