/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.owasp.encoder.Encode;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.PublicationsPickerField;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class PublicationsPickerFieldDisplayer
extends AbstractFieldDisplayer<PublicationsPickerField> {
    public String[] getManagedTypes() {
        return new String[]{"publicationsPicker"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pageContext) {
        if (!"publicationsPicker".equals(template.getTypeName())) {
            SilverLogger.getLogger((Object)this).warn("The expected type of the publicationsPicker field is invalid: " + template.getTypeName(), new Object[0]);
        }
        PublicationsPickerFieldDisplayer.produceMandatoryCheck(out, template, pageContext);
        Util.getJavascriptChecker(template.getFieldName(), pageContext, out);
    }

    @Override
    public void display(PrintWriter out, PublicationsPickerField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String language = pageContext.getLanguage();
        String selectImg = Util.getIcon("explorer");
        String selectLabel = Util.getString("field.explorer.browse", language);
        String deleteImg = Util.getIcon("delete");
        String deleteLabel = Util.getString("GML.delete", language);
        String displayedValue = "";
        String rawRefs = "";
        StringBuilder html2 = new StringBuilder();
        String fieldName = template.getFieldName();
        if (field.getTypeName().equals("publicationsPicker")) {
            rawRefs = field.getRawResourceReferences();
        }
        html2.append("<input type=\"hidden\" id=\"").append(fieldName).append("\"");
        html2.append(" name=\"").append(fieldName).append("\"");
        html2.append(" value=\"").append(Encode.forHtml((String)rawRefs)).append("\"");
        html2.append("/>");
        if (!template.isHidden()) {
            html2.append("<textarea disabled=\"disabled\"");
            html2.append(" id=\"").append(fieldName).append("_publications\"");
            html2.append(" name=\"").append(fieldName).append("$$publications\"");
            if (field.getNbPublications() > 0) {
                html2.append(" rows=\"").append(field.getNbPublications() + 1).append("\"");
            }
            html2.append(" cols=\"").append("120").append("\">");
            html2.append(Encode.forHtml((String)field.getValueAsText(language)));
            html2.append("</textarea>");
        }
        if (!(template.isHidden() || template.isDisabled() || template.isReadOnly())) {
            Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
            String scope = parameters.get("scope");
            html2.append("&nbsp;<a href=\"#\" onclick=\"javascript:SP_openWindow('").append(URLUtil.getApplicationURL()).append("/explorer/jsp/explorer.jsp?elementHidden=").append(fieldName).append("&elementVisible=").append(fieldName).append("_publications&scope=").append(scope);
            html2.append("&publicationsPicker=true");
            html2.append("','explorer',800,600,'scrollbars=yes');return false;\" >");
            html2.append("<img src=\"").append(selectImg).append("\" width=\"15\" height=\"15\" border=\"0\" alt=\"").append(selectLabel).append("\" align=\"top\" title=\"").append(selectLabel).append("\"/></a>");
            html2.append("&nbsp;<a href=\"#\" onclick=\"javascript:document.").append(pageContext.getFormName()).append(".").append(fieldName).append(".value='';document.").append(pageContext.getFormName()).append(".").append(fieldName).append("$$publications.value='';return false;\">");
            html2.append("<img src=\"").append(deleteImg).append("\" width=\"15\" height=\"15\" border=\"0\" alt=\"").append(deleteLabel).append("\" align=\"top\" title=\"").append(deleteLabel).append("\"/></a>");
            if (template.isMandatory() && pageContext.useMandatory()) {
                html2.append(Util.getMandatorySnippet());
            }
        }
        out.println(html2);
    }

    @Override
    public List<String> update(String newIds, PublicationsPickerField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        if ("publicationsPicker".equals(field.getTypeName())) {
            if (!StringUtil.isDefined((String)newIds)) {
                field.setNull();
            } else {
                field.setRawResourceReferences(newIds);
            }
        } else {
            throw new FormException("Incorrect field value type. Expected {0}", "explorer");
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pageContext) {
        return 2;
    }

    @Override
    public List<String> update(List<FileItem> items, PublicationsPickerField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String itemName = template.getFieldName();
        String value = FileUploadUtil.getParameter(items, itemName);
        return this.applyUpdate(field, value, template, pageContext);
    }
}

