/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.FileField;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractFileFieldDisplayer
extends AbstractFieldDisplayer<FileField> {
    protected static final String OPERATION_KEY = "Operation";

    private SimpleDocument createSimpleDocument(String objectId, String componentId, FileItem item, String fileName, String userId) throws IOException {
        SimpleDocumentPK documentPk = new SimpleDocumentPK(null, componentId);
        SimpleAttachment attachment = SimpleAttachment.builder().setFilename(fileName).setSize(item.getSize()).setContentType(FileUtil.getMimeType(fileName)).setCreationData(userId, new Date()).build();
        SimpleDocument document = new SimpleDocument(documentPk, objectId, 0, false, null, attachment);
        document.setDocumentType(DocumentType.form);
        try (InputStream in = item.getInputStream();){
            SimpleDocument simpleDocument = AttachmentServiceProvider.getAttachmentService().createAttachment(document, in, false);
            return simpleDocument;
        }
    }

    protected void deleteAttachment(String attachmentId, PagesContext pageContext) {
        SimpleDocumentPK pk = new SimpleDocumentPK(attachmentId, pageContext.getComponentId());
        SimpleDocument doc = AttachmentServiceProvider.getAttachmentService().searchDocumentById(pk, pageContext.getContentLanguage());
        if (doc != null) {
            AttachmentServiceProvider.getAttachmentService().deleteAttachment(doc);
        }
    }

    public String[] getManagedTypes() {
        return new String[]{"file"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pageContext) {
        String language = pageContext.getLanguage();
        String fieldName = template.getFieldName();
        String label = WebEncodeHelper.javaStringToJsString((String)template.getLabel(language));
        if (template.isMandatory() && pageContext.useMandatory()) {
            out.append("  if (!ignoreMandatory && isWhitespace(stripInitialWhitespace(field.value))) {\n").append("   var ").append(fieldName).append("Value = document.getElementById('").append(fieldName).append("_id").append("').value;\n").append("   var ").append(fieldName).append("Operation = document.").append(pageContext.getFormName()).append(".").append(fieldName).append(OPERATION_KEY).append(".value;\n").append("   if (").append(fieldName).append("Value=='' || ").append(fieldName).append("Operation=='").append(Operation.DELETION.name()).append("') {\n").append("     errorMsg+=\"  - '").append(label).append("' ").append(Util.getString("GML.MustBeFilled", language)).append("\\n\";\n").append("     errorNb++;\n").append("   }\n").append(" }\n");
        }
        if (!template.isReadOnly()) {
            Util.includeFileNameLengthChecker(template, pageContext, out);
            Util.getJavascriptChecker(template.getFieldName(), pageContext, out);
        }
    }

    @Override
    public List<String> update(List<FileItem> items, FileField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String attachmentId = this.processInput(items, field, pageContext);
        return new ArrayList<String>(this.update(attachmentId, field, template, pageContext));
    }

    protected String processInput(List<FileItem> items, FileField field, PagesContext pageContext) {
        try {
            String fileLinkOnApplication;
            String currentAttachmentId = field.getAttachmentId();
            String inputName = Util.getFieldOccurrenceName(field.getName(), field.getOccurrence());
            String attachmentId = this.processUploadedFile(items, inputName, pageContext);
            Operation operation = Operation.valueOf(FileUploadUtil.getParameter(items, inputName + OPERATION_KEY));
            if (!StringUtil.isDefined((String)attachmentId) && StringUtil.startsWith((CharSequence)(fileLinkOnApplication = FileUploadUtil.getParameter(items, inputName + "$$id")), (CharSequence)"/")) {
                String string = attachmentId = this.isDeletion(operation, fileLinkOnApplication) ? null : fileLinkOnApplication;
            }
            if (!pageContext.isCreation()) {
                boolean isDeletionOfCurrent = this.isDeletion(operation, currentAttachmentId);
                boolean isUpdate = StringUtil.isDefined((String)currentAttachmentId) && StringUtil.isDefined((String)attachmentId) && !currentAttachmentId.equals(attachmentId);
                boolean isAddOrUpdate = StringUtil.isDefined((String)attachmentId);
                if ((isDeletionOfCurrent || isUpdate) && !StringUtil.startsWith((CharSequence)currentAttachmentId, (CharSequence)"/")) {
                    this.deleteAttachment(currentAttachmentId, pageContext);
                } else if (!isAddOrUpdate) {
                    return currentAttachmentId;
                }
            }
            return attachmentId;
        }
        catch (IOException ex) {
            SilverLogger.getLogger((Object)this).error((Throwable)ex);
            return null;
        }
    }

    @Override
    public List<String> update(String attachmentId, FileField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        ArrayList<String> updated = new ArrayList<String>();
        if ("file".equals(field.getTypeName())) {
            if (!StringUtil.isDefined((String)attachmentId)) {
                field.setNull();
            } else {
                field.setAttachmentId(attachmentId);
                updated.add(attachmentId);
            }
        } else {
            throw new FormException("Incorrect field value type. Expected {0}", "file");
        }
        return updated;
    }

    protected boolean isDeletion(Operation operation, String attachmentId) {
        return StringUtil.isDefined((String)attachmentId) && operation == Operation.DELETION;
    }

    protected boolean isUpdate(Operation operation, String attachmentId) {
        return StringUtil.isDefined((String)attachmentId) && operation == Operation.UPDATE;
    }

    protected String processUploadedFile(List<FileItem> items, String parameterName, PagesContext pagesContext) throws IOException {
        String attachmentId = null;
        FileItem item = FileUploadUtil.getFile(items, parameterName);
        if (item != null && !item.isFormField()) {
            String componentId = pagesContext.getComponentId();
            String userId = pagesContext.getUserId();
            String objectId = pagesContext.getObjectId();
            if (StringUtil.isDefined((String)item.getName())) {
                String fileName = FileUtil.getFilename(item.getName());
                long size = item.getSize();
                if (size > 0L) {
                    SimpleDocument document = this.createSimpleDocument(objectId, componentId, item, fileName, userId);
                    attachmentId = document.getId();
                }
            }
        }
        return attachmentId;
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    protected static enum Operation {
        ADD,
        UPDATE,
        DELETION;

    }
}

