/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.ddwe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.ComponentResourceIdentifier;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.content.ddwe.model.DragAndDropWebEditorStore;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.wbe.SimpleWbeFile;
import org.silverpeas.kernel.util.StringUtil;

public class DragAndDropWbeFile
extends SimpleWbeFile {
    private final DragAndDropWebEditorStore store;

    public DragAndDropWbeFile(DragAndDropWebEditorStore store) {
        super(store.getFile());
        this.store = store;
    }

    public Optional<ContributionIdentifier> linkedToContribution() {
        return Optional.of(this.getStore()).map(DragAndDropWebEditorStore::getContributionId);
    }

    @Override
    public Optional<ResourceReference> linkedToResource() {
        return this.linkedToContribution().map(ComponentResourceIdentifier::toReference);
    }

    public String id() {
        return StringUtil.asBase64((byte[])("ddwe-" + super.id()).getBytes(Charsets.UTF_8)).replace("=", "-");
    }

    @Override
    public String silverpeasId() {
        return this.getStore().getIdentifier().asString();
    }

    public String componentInstanceId() {
        return this.getStore().getContributionId().getComponentInstanceId();
    }

    @Override
    public User owner() {
        return this.getStore().getFile().getContainer().getTmpContent().map(DragAndDropWebEditorStore.Content::getMetadata).map(DragAndDropWebEditorStore.Content.Metadata::getLastUpdatedBy).map(User::getById).orElse(null);
    }

    @Override
    public String name() {
        return this.getStore().getName();
    }

    @Override
    public String mimeType() {
        return this.getStore().getFile().getMimeType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFrom(InputStream input) throws IOException {
        Object object = MUTEX;
        synchronized (object) {
            String exContentValue = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            DragAndDropWebEditorStore.Content spContent = this.getStore().getFile().getContainer().getOrCreateTmpContent();
            spContent.setValue(exContentValue);
            this.getStore().save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadInto(OutputStream output) throws IOException {
        Object object = MUTEX;
        synchronized (object) {
            Optional<String> tmpContent = this.getTemporaryContent();
            if (tmpContent.isPresent()) {
                try (StringReader in = new StringReader(tmpContent.get());){
                    IOUtils.copy((Reader)in, (OutputStream)output, (Charset)StandardCharsets.UTF_8);
                }
            }
        }
    }

    public Optional<String> getTemporaryContent() {
        return this.getStore().getFile().getContainer().getTmpContent().map(DragAndDropWebEditorStore.Content::getValue);
    }

    public Optional<String> getFinalContent() {
        return this.getStore().getFile().getContainer().getContent().map(DragAndDropWebEditorStore.Content::getValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTemporaryContent() {
        Object object = MUTEX;
        synchronized (object) {
            DragAndDropWebEditorStore.Container container = this.getStore().getFile().getContainer();
            container.getContent().map(DragAndDropWebEditorStore.Content::getValue).ifPresentOrElse(v -> container.getOrCreateTmpContent().setValue((String)v), () -> container.getTmpContent().ifPresent(t -> t.setValue("")));
        }
    }

    public boolean canBeModifiedBy(User user) {
        return true;
    }

    private DragAndDropWebEditorStore getStore() {
        return this.store;
    }
}

