/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.contribution.attachment.WebdavServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.webdav.impl.WebdavContentDescriptor;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.wbe.WbeFile;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.util.StringUtil;

public class WebdavWbeFile
extends WbeFile {
    public static final String DOC_CACHE_KEY_PREFIX = WebdavWbeFile.class.getSimpleName() + "DOC";
    public static final String DESC_CACHE_KEY_PREFIX = WebdavWbeFile.class.getSimpleName() + "DESC";
    private final String docId;
    private final String docLanguage;

    public WebdavWbeFile(SimpleDocument document) {
        this(document.getId(), document.getLanguage());
    }

    protected WebdavWbeFile(String docId, String docLanguage) {
        this.docId = docId;
        this.docLanguage = docLanguage;
    }

    public Optional<ResourceReference> linkedToResource() {
        SimpleDocument document = this.getDocument();
        return Optional.of(new ResourceReference(document.getId(), document.getInstanceId()));
    }

    public String silverpeasId() {
        return this.docId;
    }

    public String id() {
        return this.getContentDescriptor().getId();
    }

    public User owner() {
        return User.getById((String)this.getDocument().getEditedBy());
    }

    public String name() {
        SimpleDocument document = this.getDocument();
        return Optional.ofNullable(document.getTitle()).filter(StringUtil::isDefined).map(t -> t + "." + this.ext()).orElse(document.getFilename());
    }

    public String ext() {
        return FilenameUtils.getExtension((String)this.getDocument().getFilename());
    }

    public String mimeType() {
        return FileUtil.getMimeType(this.getDocument().getAttachmentPath());
    }

    public long size() {
        return this.getContentDescriptor().getSize();
    }

    public OffsetDateTime lastModificationDate() {
        return this.getContentDescriptor().getLastModificationDate();
    }

    public void updateFrom(InputStream input2) throws IOException {
        WebdavServiceProvider.getWebdavService().updateContentFrom(this.getDocument(), input2);
        this.clearCaches();
    }

    public void loadInto(OutputStream output) throws IOException {
        WebdavServiceProvider.getWebdavService().loadContentInto(this.getDocument(), output);
    }

    public boolean canBeAccessedBy(User user) {
        SimpleDocument doc = this.getDocument();
        return doc.isEdited() && (doc.isEditedBy(user) || doc.editableSimultaneously().orElse(false) != false) && doc.canBeAccessedBy(user);
    }

    public boolean canBeModifiedBy(User user) {
        SimpleDocument doc = this.getDocument();
        return doc.isEdited() && (doc.isEditedBy(user) || doc.editableSimultaneously().orElse(false) != false) && doc.canBeModifiedBy(user);
    }

    @NonNull
    private SimpleDocument getDocument() {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        String key = DOC_CACHE_KEY_PREFIX + this.docId;
        SimpleDocument document = (SimpleDocument)cache.computeIfAbsent((Object)key, SimpleDocument.class, () -> Optional.ofNullable(AttachmentService.get().searchDocumentById(new SimpleDocumentPK(this.docId), this.docLanguage)).orElseThrow(() -> new SilverpeasRuntimeException(MessageFormat.format("document {0}[{1}] does not exist anymore", this.docId, this.docLanguage))));
        return Objects.requireNonNull(document);
    }

    @NonNull
    private WebdavContentDescriptor getContentDescriptor() {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        String key = DESC_CACHE_KEY_PREFIX + this.docId;
        WebdavContentDescriptor descriptor = (WebdavContentDescriptor)cache.computeIfAbsent((Object)key, WebdavContentDescriptor.class, () -> this.getWebdavContentDescriptor().orElseThrow(() -> new SilverpeasRuntimeException(MessageFormat.format("no WEBDAV description for document {0}[{1}]", this.docId, this.docLanguage))));
        return Objects.requireNonNull(descriptor);
    }

    private Optional<WebdavContentDescriptor> getWebdavContentDescriptor() {
        if (this.getDocument().isOpenOfficeCompatible() && this.getDocument().isEdited()) {
            return WebdavServiceProvider.getWebdavService().getDescriptor(this.getDocument().getVersionMaster());
        }
        return Optional.empty();
    }

    private void clearCaches() {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        Stream.of(DOC_CACHE_KEY_PREFIX, DESC_CACHE_KEY_PREFIX).map(p -> p + this.docId).forEach(arg_0 -> ((SimpleCache)cache).remove(arg_0));
    }
}

