/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.process.huge;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.util.annotation.AnnotationUtil;
import org.silverpeas.core.util.annotation.SourceObject;
import org.silverpeas.core.util.annotation.SourcePK;
import org.silverpeas.core.util.annotation.TargetPK;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractAttachmentHugeProcessAnnotationInterceptor {
    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        Map<Class<? extends Annotation>, List<Object>> annotatedParametersValues = AnnotationUtil.extractMethodAnnotatedParameterValues(invocationContext);
        return this.perform(invocationContext, annotatedParametersValues);
    }

    protected Object perform(InvocationContext context, Map<Class<? extends Annotation>, List<Object>> annotatedParametersValues) throws Exception {
        Set<String> instanceIds = null;
        try {
            List sourcePKs = AnnotationUtil.getAnnotatedValues(annotatedParametersValues, SourcePK.class);
            List targetPKs = AnnotationUtil.getAnnotatedValues(annotatedParametersValues, TargetPK.class);
            List sourceObjects = AnnotationUtil.getAnnotatedValues(annotatedParametersValues, SourceObject.class);
            if (!(sourcePKs.isEmpty() && sourceObjects.isEmpty() && targetPKs.isEmpty())) {
                instanceIds = Stream.concat(Stream.concat(sourcePKs.stream().map(WAPrimaryKey::getInstanceId), targetPKs.stream().map(WAPrimaryKey::getInstanceId)), sourceObjects.stream().map(o -> {
                    if (o instanceof SimpleDocument) {
                        return ((SimpleDocument)o).getInstanceId();
                    }
                    return o.toString();
                })).collect(Collectors.toSet());
                this.startForInstances(instanceIds);
            } else {
                SilverLogger.getLogger((Object)this).warn("Intercepted method ''{0}'', but SourcePK, SourceObject or TargetPK annotations  are missing on parameter specifications...", new Object[]{context.getMethod().getName()});
            }
            Object object = this.proceed(context);
            return object;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Error in intercepted method: " + context.getMethod().getName(), (Throwable)e);
            throw e;
        }
        finally {
            if (instanceIds != null) {
                this.endForInstances(instanceIds);
            }
        }
    }

    protected abstract void startForInstances(Set<String> var1);

    protected abstract void endForInstances(Set<String> var1);

    protected Object proceed(InvocationContext context) throws Exception {
        return context.proceed();
    }
}

