/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.model;

import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentVersion;

public class HistorisedDocument
extends SimpleDocument {
    private static final long serialVersionUID = -5850838926035340609L;
    private List<SimpleDocumentVersion> history;
    private List<SimpleDocumentVersion> functionalHistory;

    public HistorisedDocument(SimpleDocumentPK pk, String foreignId, int order, SimpleAttachment file) {
        super(pk, foreignId, order, true, file);
    }

    public HistorisedDocument(SimpleDocumentPK pk, String foreignId, int order, String owner, SimpleAttachment file) {
        super(pk, foreignId, order, true, owner, file);
    }

    public HistorisedDocument() {
        super(new SimpleDocumentPK(null), null, 0, true, SimpleAttachment.builder().build());
    }

    public HistorisedDocument(SimpleDocument doc) {
        super(doc);
        this.setVersionMaster(this);
    }

    @Override
    public HistorisedDocument getVersionMaster() {
        return (HistorisedDocument)super.getVersionMaster();
    }

    @Override
    public boolean isVersioned() {
        return true;
    }

    public List<SimpleDocumentVersion> getHistory() {
        return this.history;
    }

    public SimpleDocumentVersion getVersionIdentifiedBy(String id) {
        for (SimpleDocumentVersion version : this.history) {
            if (!version.getId().equals(id)) continue;
            return version;
        }
        return null;
    }

    public List<SimpleDocumentVersion> getFunctionalHistory() {
        if (this.functionalHistory == null && this.history != null) {
            this.functionalHistory = new ArrayList<SimpleDocumentVersion>(this.history.size());
            String lastVersion = this.getVersion();
            for (SimpleDocumentVersion currentDocumentVersion : this.history) {
                String currentVersion = currentDocumentVersion.getVersion();
                if (!currentVersion.equals(lastVersion) && currentDocumentVersion.getVersionIndex() < this.getVersionIndex()) {
                    this.functionalHistory.add(currentDocumentVersion);
                }
                lastVersion = currentVersion;
            }
        }
        return this.functionalHistory;
    }

    public void setHistory(List<SimpleDocumentVersion> history) {
        this.history = history;
    }

    public List<SimpleDocument> getPublicVersions() {
        ArrayList<SimpleDocument> publicVersions = new ArrayList<SimpleDocument>(this.getFunctionalHistory().size());
        for (SimpleDocument simpleDocument : this.getFunctionalHistory()) {
            if (!simpleDocument.isPublic()) continue;
            publicVersions.add(simpleDocument);
        }
        return publicVersions;
    }

    @Override
    public SimpleDocument getLastPublicVersion() {
        if (this.isPublic()) {
            return this;
        }
        for (SimpleDocument simpleDocument : this.getFunctionalHistory()) {
            if (!simpleDocument.isPublic()) continue;
            return simpleDocument;
        }
        return null;
    }

    public SimpleDocumentVersion getPreviousVersion() {
        if (!this.getHistory().isEmpty()) {
            return this.getHistory().get(0);
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

