/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.contribution.ContributionOperationContextPropertyHandler;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Service
public class ContributionModificationContextHandler
implements ContributionOperationContextPropertyHandler {
    private static final String HTTP_PARAM = "CONTRIBUTION_MODIFICATION_CONTEXT";
    private static final String CACHE_KEY = ContributionModificationContextHandler.class.getName() + "#CACHE_KEY";

    public static ContributionModificationContextHandler get() {
        return (ContributionModificationContextHandler)ServiceProvider.getService(ContributionModificationContextHandler.class, (Annotation[])new Annotation[0]);
    }

    protected ContributionModificationContextHandler() {
    }

    @Override
    public void parseForProperty(HttpServletRequest request) {
        String parameter = request.getParameter(HTTP_PARAM);
        String header = request.getHeader(HTTP_PARAM);
        Context context = this.getMergedContext(parameter, header);
        CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)CACHE_KEY, (Object)context);
    }

    public void setMinorModification() {
        this.getOrCreateContext().isMinor = true;
    }

    public Optional<Boolean> isMinorModification() {
        return this.getContext().map(Context::isMinor);
    }

    private Context getMergedContext(String parameter, String header) {
        Context fromParameters = this.decodeContext(parameter);
        Context fromHeaders = this.decodeContext(header);
        Context mergedContext = new Context();
        if (fromParameters.isMinor != null) {
            mergedContext.isMinor = fromParameters.isMinor;
        }
        if (mergedContext.isMinor == null || !mergedContext.isMinor.booleanValue() && fromHeaders.isMinor != null) {
            mergedContext.isMinor = fromHeaders.isMinor;
        }
        return mergedContext;
    }

    private Context decodeContext(String value) {
        String decodedValue = StringUtil.isDefined((String)value) ? (value.startsWith("{") ? value : new String(StringUtil.fromBase64((String)value))) : "{}";
        return (Context)JSONCodec.decode((String)decodedValue, Context.class);
    }

    private Optional<Context> getContext() {
        return Optional.ofNullable((Context)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)CACHE_KEY, Context.class));
    }

    @NonNull
    private Context getOrCreateContext() {
        Context context = (Context)CacheAccessorProvider.getThreadCacheAccessor().getCache().computeIfAbsent((Object)CACHE_KEY, Context.class, () -> new Context());
        return Objects.requireNonNull(context);
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Context
    implements Serializable {
        private static final long serialVersionUID = -7623666268435749654L;
        @XmlElement
        private Boolean isMinor = null;

        private Context() {
        }

        Boolean isMinor() {
            return this.isMinor;
        }
    }
}

