/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chart;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.chart.AbstractChartItem;
import org.silverpeas.core.chart.Chart;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractChart<CHART_ITEM_TYPE extends AbstractChartItem>
implements Chart<CHART_ITEM_TYPE> {
    private String title = "";
    private List<CHART_ITEM_TYPE> items = new ArrayList<CHART_ITEM_TYPE>();
    private Map<String, String> extra = null;

    @Override
    public String getTitle() {
        return this.title;
    }

    public <T extends AbstractChart<CHART_ITEM_TYPE>> T addExtra(String key, String value) {
        if (this.extra == null) {
            this.extra = new LinkedHashMap<String, String>();
        }
        this.extra.put(key, value);
        return (T)this;
    }

    public Object getExtra(String key) {
        return this.extra == null ? null : this.extra.get(key);
    }

    public final <T extends AbstractChart<CHART_ITEM_TYPE>> T withTitle(String title) {
        this.title = StringUtil.defaultStringIfNotDefined((String)title);
        return (T)this;
    }

    @Override
    public final String asJson() {
        return JSONCodec.encodeObject(jsonChart -> {
            jsonChart.put("chartType", this.getType().name());
            jsonChart.put("title", this.getTitle());
            this.computeExtraDataAsJson((JSONCodec.JSONObject)jsonChart);
            jsonChart.putJSONArray("items", dataAsJson -> {
                for (AbstractChartItem data : this.getItems()) {
                    dataAsJson.addJSONObject(data.getJsonProducer());
                }
                return dataAsJson;
            });
            if (this.extra != null) {
                jsonChart.putJSONObject("extra", jsonExtra -> {
                    for (Map.Entry<String, String> entry : this.extra.entrySet()) {
                        jsonExtra.put(entry.getKey(), entry.getValue());
                    }
                    return jsonExtra;
                });
            }
            return jsonChart;
        });
    }

    protected void computeExtraDataAsJson(JSONCodec.JSONObject jsonChart) {
    }

    @Override
    public final List<CHART_ITEM_TYPE> getItems() {
        return this.items;
    }

    protected <T extends AbstractChart<CHART_ITEM_TYPE>> T add(CHART_ITEM_TYPE item) {
        this.items.add(item);
        return (T)this;
    }
}

