/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.cache.service;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.silverpeas.core.cache.VolatileResourceCleaner;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.CoreContributionType;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.thread.ManagedThreadPool;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class VolatileResourceCacheService {
    private final List<ContributionIdentifier> componentVolatileIds = new ArrayList<ContributionIdentifier>();
    private Integer currentIntId = Integer.MAX_VALUE;
    private Long currentLongId = Long.MAX_VALUE;

    public static void clearFrom(SessionInfo sessionInfo) {
        VolatileResourceCacheService cache = (VolatileResourceCacheService)sessionInfo.getCache().get((Object)VolatileResourceCacheService.class.getName(), VolatileResourceCacheService.class);
        if (cache != null) {
            cache.clear();
        }
    }

    int newVolatileIntegerIdentifier() {
        String volatileId = this.newVolatileIntegerIdentifierAsString();
        return Integer.parseInt(volatileId);
    }

    synchronized String newVolatileIntegerIdentifierAsString() {
        this.currentIntId = this.currentIntId - 1;
        return "-" + this.currentIntId;
    }

    long newVolatileLongIdentifier() {
        String volatileId = this.newVolatileLongIdentifierAsString();
        return Long.parseLong(volatileId);
    }

    synchronized String newVolatileLongIdentifierAsString() {
        this.currentLongId = this.currentLongId - 1L;
        return "-" + this.currentLongId;
    }

    String newVolatileStringIdentifier() {
        return "volatile-" + UUID.randomUUID().toString();
    }

    void register(String volatileId, String componentInstanceId) {
        this.componentVolatileIds.add(this.withId(volatileId, componentInstanceId));
    }

    public boolean contains(Contribution contribution) {
        ContributionIdentifier contributionId = contribution.getIdentifier();
        String volatileId = contributionId.getLocalId();
        String componentInstanceId = contributionId.getComponentInstanceId();
        return this.contains(volatileId, componentInstanceId);
    }

    public boolean couldBeVolatileId(String id) {
        return id != null && id.startsWith("volatile-");
    }

    public boolean contains(String volatileId, String componentInstanceId) {
        return StringUtil.isDefined((String)volatileId) && StringUtil.isDefined((String)componentInstanceId) && this.componentVolatileIds.contains(this.withId(volatileId, componentInstanceId));
    }

    public void clear() {
        VolatileResourceCacheService current = this;
        try {
            Runnable[] runnableArray = new Runnable[1];
            runnableArray[0] = current::deleteAllResources;
            ManagedThreadPool.getPool().invoke(runnableArray);
        }
        catch (RuntimeException e) {
            SilverLogger.getLogger((Object)this).error("The clear of volatile cache did not end successfully...", (Throwable)e);
        }
    }

    private void deleteAllResources() {
        ServiceProvider.getAllServices(VolatileResourceCleaner.class, (Annotation[])new Annotation[0]).forEach(s -> {
            try {
                this.componentVolatileIds.forEach(i -> s.cleanVolatileResources(i.getLocalId(), i.getComponentInstanceId()));
            }
            catch (RuntimeException e) {
                SilverLogger.getLogger((Object)this).error("The clear of volatile cache did not end successfully...", (Throwable)e);
            }
        });
    }

    private ContributionIdentifier withId(String localId, String componentInstanceId) {
        return ContributionIdentifier.from((String)componentInstanceId, (String)localId, (CoreContributionType)CoreContributionType.VOLATILE);
    }
}

