/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.silverpeas.core.admin.domain.DomainDriver;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.util.StringUtil;

public class UserFull
extends UserDetail {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> infos = new HashMap<String, String>();
    private transient DomainDriver domainDriver = null;
    private String password = "";
    private boolean isPasswordValid = false;
    private boolean isPasswordAvailable = false;

    public static UserFull getById(String userId) {
        return UserFull.getOrganisationController().getUserFull(userId);
    }

    public static List<UserFull> getByIds(Collection<String> userIds) {
        return UserFull.getOrganisationController().getUserFulls(userIds);
    }

    public UserFull() {
    }

    public UserFull(DomainDriver domainDriver) {
        this.domainDriver = domainDriver;
    }

    public UserFull(DomainDriver domainDriver, UserDetail toClone) {
        super(toClone);
        this.domainDriver = domainDriver;
    }

    public boolean isPasswordAvailable() {
        return this.isPasswordAvailable;
    }

    public void setPasswordAvailable(boolean pa) {
        this.isPasswordAvailable = pa;
    }

    public boolean isPasswordValid() {
        return this.isPasswordValid;
    }

    public void setPasswordValid(boolean pv) {
        this.isPasswordValid = pv;
    }

    public String getPassword() {
        return this.password == null ? "" : this.password;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public String[] getPropertiesNames() {
        if (this.domainDriver != null) {
            return this.domainDriver.getPropertiesNames();
        }
        return ArrayUtil.emptyStringArray();
    }

    public Map<String, String> getSpecificDetails() {
        return this.infos;
    }

    public String getValue(String propertyName, String defaultValue) {
        String valret = this.infos.get(propertyName);
        if (valret == null) {
            valret = defaultValue;
        }
        return valret;
    }

    public String getValue(String propertyName) {
        return this.getValue(propertyName, "");
    }

    public boolean getValue(String propertyName, boolean defaultValue) {
        boolean valret = defaultValue;
        String sValret = this.infos.get(propertyName);
        if (sValret != null) {
            valret = Boolean.parseBoolean(sValret);
        }
        return valret;
    }

    public Map<String, String> getSpecificLabels(String language) {
        if (this.domainDriver != null) {
            return this.domainDriver.getPropertiesLabels(language);
        }
        return Map.of();
    }

    public String getSpecificLabel(String language, String propertyName) {
        String valret = null;
        if (this.domainDriver != null) {
            Map<String, String> theLabels = this.domainDriver.getPropertiesLabels(language);
            valret = theLabels.get(propertyName);
        }
        if (valret == null) {
            valret = "";
        }
        return valret;
    }

    public String getPropertyType(String propertyName) {
        DomainProperty domainProperty;
        String valret = null;
        if (this.domainDriver != null && (domainProperty = this.domainDriver.getProperty(propertyName)) != null) {
            valret = domainProperty.getType();
        }
        if (valret == null) {
            valret = "";
        }
        return valret;
    }

    public boolean isPropertyUpdatableByUser(String property) {
        DomainProperty domainProperty;
        if (this.domainDriver != null && (domainProperty = this.domainDriver.getProperty(property)) != null) {
            return domainProperty.isUpdateAllowedToUser();
        }
        return false;
    }

    public boolean isPropertyUpdatableByAdmin(String property) {
        DomainProperty domainProperty;
        if (this.domainDriver != null && (domainProperty = this.domainDriver.getProperty(property)) != null) {
            return domainProperty.isUpdateAllowedToAdmin();
        }
        return false;
    }

    public boolean isAtLeastOnePropertyUpdatableByAdmin() {
        if (this.domainDriver != null) {
            String[] properties;
            for (String property : properties = this.domainDriver.getPropertiesNames()) {
                if (!this.isPropertyUpdatableByAdmin(property)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAtLeastOnePropertyUpdatableByUser() {
        if (this.domainDriver != null) {
            String[] properties;
            for (String property : properties = this.domainDriver.getPropertiesNames()) {
                if (!this.isPropertyUpdatableByUser(property)) continue;
                return true;
            }
        }
        return false;
    }

    public DomainProperty getProperty(String property) {
        if (this.domainDriver != null) {
            return this.domainDriver.getProperty(property);
        }
        return null;
    }

    public void setValue(String propertyName, String value) {
        this.infos.put(propertyName, value);
    }

    public void setValue(String propertyName, boolean bValue) {
        this.infos.put(propertyName, String.valueOf(bValue));
    }

    public Map<String, String> getDefinedDomainValues() {
        HashMap<String, String> values = new HashMap<String, String>();
        Set<String> keys = this.getSpecificDetails().keySet();
        for (String key : keys) {
            String value = this.getValue(key);
            if (!StringUtil.isDefined((String)value)) continue;
            values.put(key, WebEncodeHelper.javaStringToHtmlString((String)value));
        }
        return values;
    }

    public Map<String, String> getDefinedExtraFormValues(String language) {
        return PublicationTemplateManager.getInstance().getDirectoryFormValues(this.getId(), this.getDomainId(), language);
    }

    public Map<String, String> getAllDefinedValues(String language) {
        Map<String, String> allValues = this.getDefinedDomainValues();
        allValues.putAll(this.getDefinedExtraFormValues(language));
        return allValues;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof UserFull) {
            UserFull cmpUser = (UserFull)other;
            if (super.equals(cmpUser)) {
                String[] keys = this.infos.keySet().toArray(new String[0]);
                boolean isTheSame = true;
                for (int i = 0; i < keys.length && isTheSame; ++i) {
                    isTheSame = this.getValue(keys[i]).equals(cmpUser.getValue(keys[i]));
                }
                return isTheSame;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 53 * super.hashCode();
    }
}

