/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.dao;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.user.constant.GroupState;
import org.silverpeas.core.admin.user.model.GroupsSearchCriteria;
import org.silverpeas.core.admin.user.model.SearchCriteria;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;

public class SqlGroupSelectorByCriteriaBuilder {
    private final String fields;

    SqlGroupSelectorByCriteriaBuilder(String fields) {
        this.fields = fields;
    }

    public JdbcSqlQuery build(GroupsSearchCriteria criteria) {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)this.fields);
        this.applyJoinsAndDefaultCriteria(query, criteria);
        this.applyCriteriaOnGroupName(query, criteria);
        this.applyCriteriaOnGroupIds(query, criteria);
        this.applyCriteriaOnDomain(query, criteria);
        this.applyCriteriaOnUserIds(query, criteria);
        this.applyCriteriaOnRoles(query, criteria);
        this.applyCriteriaOnSuperGroup(query, criteria);
        query.orderBy(new String[]{"g.name"});
        if (criteria.isCriterionOnPaginationSet()) {
            PaginationPage page = criteria.getCriterionOnPagination();
            query.withPagination(page.asCriterion());
        }
        return query;
    }

    private void applyJoinsAndDefaultCriteria(JdbcSqlQuery query, GroupsSearchCriteria criteria) {
        query.from(new String[]{"st_group g"});
        if (criteria.isCriterionOnProfileIdsSet()) {
            query.join("st_userrole_group_rel urgr").on("urgr.groupId = g.id", new Object[0]);
        }
        query.where("g.state", new Object[0]).notIn(new Object[]{GroupState.REMOVED});
    }

    private void applyCriteriaOnSuperGroup(JdbcSqlQuery query, GroupsSearchCriteria criteria) {
        if (criteria.isCriterionOnSuperGroupIdSet() && criteria.mustBeRoot()) {
            query.and("(g.superGroupId = ? or g.superGroupId is null)", new Object[]{Integer.parseInt(criteria.getCriterionOnSuperGroupId())});
        } else if (criteria.isCriterionOnSuperGroupIdSet()) {
            query.and("g.superGroupId = ?", new Object[]{Integer.parseInt(criteria.getCriterionOnSuperGroupId())});
        } else if (criteria.mustBeRoot()) {
            query.and("g.superGroupId is null", new Object[0]);
        }
    }

    private void applyCriteriaOnRoles(JdbcSqlQuery query, GroupsSearchCriteria criteria) {
        if (criteria.isCriterionOnProfileIdsSet()) {
            List profileIds = Stream.of(criteria.getCriterionOnProfileIds()).map(Integer::parseInt).collect(Collectors.toList());
            query.and("urgr.userRoleId", new Object[0]).in(profileIds);
        }
    }

    private void applyCriteriaOnUserIds(JdbcSqlQuery query, GroupsSearchCriteria criteria) {
        if (criteria.isCriterionOnUserIdsSet()) {
            List ids = Stream.of(criteria.getCriterionOnUserIds()).map(Integer::parseInt).collect(Collectors.toList());
            query.and("g.id IN (SELECT groupId FROM st_group_user_rel WHERE userId", new Object[0]).in(ids);
            query.addSqlPart(")", new Object[0]);
        }
    }

    private void applyCriteriaOnGroupName(JdbcSqlQuery query, GroupsSearchCriteria criteria) {
        if (criteria.isCriterionOnNameSet()) {
            String normalizedName = criteria.getCriterionOnName().replace('*', '%');
            query.and("lower(g.name) like lower(?)", new Object[]{normalizedName});
        }
    }

    private void applyCriteriaOnGroupIds(JdbcSqlQuery query, GroupsSearchCriteria criteria) {
        if (criteria.isCriterionOnGroupIdsSet() && criteria.getCriterionOnGroupIds() != SearchCriteria.Constants.ANY) {
            List groupIds = Stream.of(criteria.getCriterionOnGroupIds()).map(Integer::parseInt).collect(Collectors.toList());
            query.and("g.id", new Object[0]).in(groupIds);
        }
    }

    private void applyCriteriaOnDomain(JdbcSqlQuery query, GroupsSearchCriteria criteria) {
        if (criteria.isCriterionOnDomainIdSet()) {
            List domainIds = Stream.of(criteria.getCriterionOnDomainIds()).map(Integer::parseInt).collect(Collectors.toList());
            query.and("g.domainId", new Object[0]).in(domainIds);
        }
    }
}

