/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.ProfiledObjectType;
import org.silverpeas.core.admin.persistence.ComponentInstanceRow;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.persistence.UserRoleRow;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.AdminNotFoundException;
import org.silverpeas.core.admin.user.GroupManager;
import org.silverpeas.core.admin.user.UserManager;
import org.silverpeas.core.admin.user.dao.RoleDAO;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.notification.ProfileInstEventNotifier;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.annotation.Nullable;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Transactional(value=Transactional.TxType.MANDATORY)
public class ProfileInstManager {
    public static final String PROFILES_OF_USER = "profiles of user";
    public static final String PROFILE = "profile";
    @Inject
    private OrganizationSchema organizationSchema;
    @Inject
    private RoleDAO roleDAO;
    @Inject
    private ProfileInstEventNotifier notifier;

    protected ProfileInstManager() {
    }

    public String createProfileInst(ProfileInst profileInst, int fatherCompLocalId) throws AdminException {
        try {
            UserRoleRow newRole = UserRoleRow.makeFrom(profileInst);
            newRole.unsetId();
            newRole.setInstanceId(fatherCompLocalId);
            ComponentInstanceRow instance = this.organizationSchema.instance().getComponentInstance(fatherCompLocalId);
            if (instance == null) {
                throw new AdminException(SilverpeasExceptionMessages.unknown((String)"component instance", (Object)String.valueOf(fatherCompLocalId)), new String[0]);
            }
            this.organizationSchema.userRole().createUserRole(newRole);
            String sProfileNodeId = ProfileInstManager.idAsString(newRole.getId());
            for (String groupId : profileInst.getAllGroups()) {
                this.organizationSchema.userRole().addGroupInUserRole(this.idAsInt(groupId), this.idAsInt(sProfileNodeId));
            }
            for (String userId : profileInst.getAllUsers()) {
                this.organizationSchema.userRole().addUserInUserRole(this.idAsInt(userId), this.idAsInt(sProfileNodeId));
            }
            this.notifier.notifyEventOn(ResourceEvent.Type.CREATION, new ProfileInst[]{profileInst});
            return sProfileNodeId;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)PROFILE, (Object)profileInst.getName()), e);
        }
    }

    @Nullable
    public ProfileInst getProfileInst(String sProfileId, boolean includeRemovedUsersAndGroups) throws AdminException {
        ProfileInst profileInst = null;
        try {
            UserRoleRow userRole = this.organizationSchema.userRole().getUserRole(this.idAsInt(sProfileId));
            if (userRole != null) {
                profileInst = this.userRoleRow2ProfileInst(userRole);
                this.setUsersAndGroups(profileInst, includeRemovedUsersAndGroups);
            } else {
                SilverLogger.getLogger((Object)this).error("User profile {0} not found", new Object[]{sProfileId});
            }
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)PROFILE, (Object)sProfileId), e);
        }
        return profileInst;
    }

    private ProfileInst userRoleRow2ProfileInst(UserRoleRow userRole) {
        ProfileInst profileInst = new ProfileInst();
        profileInst.setId(Integer.toString(userRole.getId()));
        profileInst.setName(userRole.getRoleName());
        profileInst.setLabel(userRole.getName());
        profileInst.setDescription(userRole.getDescription());
        profileInst.setComponentFatherId(userRole.getInstanceId());
        if (userRole.getInheritance() == 1) {
            profileInst.setInherited(true);
        }
        if (userRole.getObjectId() > 0) {
            String oid = String.valueOf(userRole.getObjectId());
            ProfiledObjectType objectType = ProfiledObjectType.fromCode(userRole.getObjectType());
            profileInst.setObjectId(new ProfiledObjectId(objectType, oid));
        }
        return profileInst;
    }

    private void setUsersAndGroups(ProfileInst profileInst, boolean includeRemovedUsersAndGroups) throws AdminException {
        List<String> groupIds = GroupManager.get().getDirectGroupIdsInRole(profileInst.getId(), includeRemovedUsersAndGroups);
        profileInst.setGroups(groupIds);
        List<String> userIds = UserManager.get().getDirectUserIdsInRole(profileInst.getId(), includeRemovedUsersAndGroups);
        profileInst.setUsers(userIds);
    }

    public ProfileInst getInheritedProfileInst(int instanceLocalId, String roleName) throws AdminException {
        try {
            UserRoleRow userRole = this.organizationSchema.userRole().getUserRole(instanceLocalId, roleName, 1);
            ProfileInst profileInst = null;
            if (userRole != null) {
                profileInst = this.userRoleRow2ProfileInst(userRole);
                this.setUsersAndGroups(profileInst, false);
            }
            return profileInst;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"inherited profile", (Object)roleName), e);
        }
    }

    public void deleteProfileInst(ProfileInst profileInst) throws AdminException {
        try {
            this.organizationSchema.userRole().removeUserRole(this.idAsInt(profileInst.getId()));
            this.notifier.notifyEventOn(ResourceEvent.Type.DELETION, new ProfileInst[]{profileInst});
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)PROFILE, (Object)profileInst.getId()), e);
        }
    }

    public String updateProfileInst(ProfileInst profileInstNew) throws AdminException {
        ProfileInst profileInst = this.getProfileInst(profileInstNew.getId(), false);
        if (profileInst == null) {
            throw new AdminNotFoundException("Profile instance " + profileInstNew.getId() + " not found", new String[0]);
        }
        try {
            List<String> alOldProfileGroup = profileInst.getAllGroups();
            List<String> alNewProfileGroup = profileInstNew.getAllGroups();
            this.updateProfileGroups(profileInst, alOldProfileGroup, alNewProfileGroup);
            List<String> alOldProfileUser = profileInst.getAllUsers();
            List<String> alNewProfileUser = profileInstNew.getAllUsers();
            this.updateProfileUsers(profileInst, alOldProfileUser, alNewProfileUser);
            UserRoleRow changedUserRole = UserRoleRow.makeFrom(profileInstNew);
            this.organizationSchema.userRole().updateUserRole(changedUserRole);
            this.notifier.notifyEventOn(ResourceEvent.Type.UPDATE, new ProfileInst[]{profileInst, profileInstNew});
            return ProfileInstManager.idAsString(changedUserRole.getId());
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)PROFILE, (Object)profileInst.getId()), e);
        }
    }

    private void updateProfileUsers(ProfileInst profileInst, List<String> alOldProfileUser, List<String> alNewProfileUser) throws SQLException {
        for (String userId : alNewProfileUser) {
            if (alOldProfileUser.contains(userId)) continue;
            this.organizationSchema.userRole().addUserInUserRole(this.idAsInt(userId), this.idAsInt(profileInst.getId()));
        }
        for (String userId : alOldProfileUser) {
            if (alNewProfileUser.contains(userId)) continue;
            this.organizationSchema.userRole().removeUserFromUserRole(this.idAsInt(userId), this.idAsInt(profileInst.getId()));
        }
    }

    private void updateProfileGroups(ProfileInst profileInst, List<String> alOldProfileGroup, List<String> alNewProfileGroup) throws SQLException {
        for (String groupId : alNewProfileGroup) {
            if (alOldProfileGroup.contains(groupId)) continue;
            this.organizationSchema.userRole().addGroupInUserRole(this.idAsInt(groupId), this.idAsInt(profileInst.getId()));
        }
        for (String groupId : alOldProfileGroup) {
            if (alNewProfileGroup.contains(groupId)) continue;
            this.organizationSchema.userRole().removeGroupFromUserRole(this.idAsInt(groupId), this.idAsInt(profileInst.getId()));
        }
    }

    public String[] getProfileIdsOfUser(String sUserId, List<String> groupIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            List<UserRoleRow> roles = this.roleDAO.getRoles(con, groupIds, Integer.parseInt(sUserId));
            ArrayList<String> roleIds = new ArrayList<String>();
            for (UserRoleRow role : roles) {
                roleIds.add(Integer.toString(role.getId()));
            }
            String[] stringArray = roleIds.toArray(new String[0]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)PROFILES_OF_USER, (Object)sUserId), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    public String[] getAllComponentObjectProfileIdsOfUser(String sUserId, List<String> groupIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            List<UserRoleRow> roles = this.roleDAO.getAllComponentObjectRoles(con, groupIds, Integer.parseInt(sUserId));
            ArrayList<String> roleIds = new ArrayList<String>();
            for (UserRoleRow role : roles) {
                roleIds.add(Integer.toString(role.getId()));
            }
            String[] stringArray = roleIds.toArray(new String[0]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)PROFILES_OF_USER, (Object)sUserId), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    public String[] getProfileNamesOfUser(String userId, List<String> groupIds, int componentLocalId) throws AdminException {
        String[] stringArray;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                stringArray = (String[])this.roleDAO.getRoles(con, groupIds, Integer.parseInt(userId), Collections.singleton(componentLocalId)).stream().map(UserRoleRow::getRoleName).distinct().toArray(String[]::new);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)PROFILES_OF_USER, (Object)userId), e);
                }
            }
            con.close();
        }
        return stringArray;
    }

    public Map<Integer, Set<String>> getProfileNamesOfUser(String userId, List<String> groupIds, Collection<Integer> componentLocalIds) throws AdminException {
        Map<Integer, Set<String>> map;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                map = this.roleDAO.getRoles(con, groupIds, Integer.parseInt(userId), componentLocalIds).stream().collect(Collectors.groupingBy(UserRoleRow::getInstanceId, Collectors.mapping(UserRoleRow::getRoleName, Collectors.toSet())));
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)PROFILES_OF_USER, (Object)userId), e);
                }
            }
            con.close();
        }
        return map;
    }

    public String[] getProfileIdsOfGroup(String sGroupId) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            ArrayList<String> groupIds = new ArrayList<String>();
            groupIds.add(sGroupId);
            List<UserRoleRow> roles = this.roleDAO.getRoles(con, groupIds, -1);
            ArrayList<String> roleIds = new ArrayList<String>();
            for (UserRoleRow role : roles) {
                roleIds.add(Integer.toString(role.getId()));
            }
            String[] stringArray = roleIds.toArray(new String[0]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"profiles of group", (Object)sGroupId), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    public String[] getAllComponentObjectProfileIdsOfGroup(String groupId) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            List<UserRoleRow> roles = this.roleDAO.getAllComponentObjectRoles(con, Collections.singletonList(groupId), -1);
            ArrayList<String> roleIds = new ArrayList<String>();
            for (UserRoleRow role : roles) {
                roleIds.add(Integer.toString(role.getId()));
            }
            String[] stringArray = roleIds.toArray(new String[0]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"profiles of group", (Object)groupId), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private int idAsInt(String id) {
        return StringUtil.asInt((String)id, (int)-1);
    }

    private static String idAsString(int id) {
        return Integer.toString(id);
    }
}

