/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space.quota;

import javax.inject.Singleton;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.quota.AbstractSpaceQuotaService;
import org.silverpeas.core.admin.space.quota.ComponentSpaceQuotaKey;
import org.silverpeas.core.admin.space.quota.ComponentSpaceQuotaService;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Service
@Singleton
public class DefaultComponentSpaceQuotaService
extends AbstractSpaceQuotaService<ComponentSpaceQuotaKey>
implements ComponentSpaceQuotaService {
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.jobStartPagePeas.settings.jobStartPagePeasSettings");

    @Override
    protected ComponentSpaceQuotaKey createKeyFrom(SpaceInst space) {
        return ComponentSpaceQuotaKey.from(space);
    }

    @Override
    public long getCurrentCount(ComponentSpaceQuotaKey key) throws QuotaException {
        long currentCount = 0L;
        if (key.getSpace() != null) {
            currentCount = OrganizationControllerProvider.getOrganisationController().getAllComponentIdsRecur(key.getResourceId()).length;
        }
        return currentCount;
    }

    @Override
    protected boolean isActivated() {
        return settings.getBoolean("quota.space.components.activated", false);
    }
}

