/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.SpaceInstManager;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

public class SpaceInstLazyDataLoader
implements Serializable {
    private static final long serialVersionUID = -1770031353832624141L;
    private final transient Object mutex = new Object();
    private final SpaceInst space;
    private final List<String> componentIds = new ArrayList<String>();
    private final List<String> subSpaceIds = new ArrayList<String>();
    private final List<SpaceProfileInst> spaceProfiles = new ArrayList<SpaceProfileInst>();
    private boolean loaded = false;

    SpaceInstLazyDataLoader(SpaceInst space) {
        this.space = space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copy(SpaceInstLazyDataLoader other) {
        ArrayList<SpaceProfileInst> spaceProfilesToCopy;
        ArrayList<String> subSpaceIdsToCopy;
        ArrayList<String> componentIdsToCopy;
        Object object = other.mutex;
        synchronized (object) {
            other.load();
            componentIdsToCopy = new ArrayList<String>(other.componentIds);
            subSpaceIdsToCopy = new ArrayList<String>(other.subSpaceIds);
            spaceProfilesToCopy = new ArrayList<SpaceProfileInst>(other.spaceProfiles);
        }
        object = this.mutex;
        synchronized (object) {
            this.reset();
            this.manualWrite(d -> {
                d.getComponentIds().addAll(componentIdsToCopy);
                d.getSubSpaceIds().addAll(subSpaceIdsToCopy);
                d.getProfiles().addAll(spaceProfilesToCopy);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.mutex;
        synchronized (object) {
            this.loaded = false;
            this.spaceProfiles.clear();
            this.subSpaceIds.clear();
            this.componentIds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T safeRead(Function<SafeDataAccessor, T> process) {
        Object object = this.mutex;
        synchronized (object) {
            this.load();
            return process.apply(new SafeDataAccessor(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void manualWrite(Consumer<SafeDataModifier> process) {
        Object object = this.mutex;
        synchronized (object) {
            this.loaded = true;
            process.accept(new SafeDataModifier(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void safeWrite(Consumer<SafeDataModifier> process) {
        Object object = this.mutex;
        synchronized (object) {
            this.load();
            process.accept(new SafeDataModifier(this));
        }
    }

    protected void load() {
        if (!this.loaded) {
            this.loaded = true;
            Transaction.getTransaction().perform(() -> {
                SpaceInstManager spaceInstManager = (SpaceInstManager)ServiceProvider.getService(SpaceInstManager.class, (Annotation[])new Annotation[0]);
                spaceInstManager.loadSpaceInstData(this.space);
                return null;
            });
        }
    }

    static class SafeDataModifier {
        private final SpaceInstLazyDataLoader loader;

        private SafeDataModifier(SpaceInstLazyDataLoader loader) {
            this.loader = loader;
        }

        List<SpaceProfileInst> getProfiles() {
            return this.loader.spaceProfiles;
        }

        List<String> getSubSpaceIds() {
            return this.loader.subSpaceIds;
        }

        List<String> getComponentIds() {
            return this.loader.componentIds;
        }
    }

    static class SafeDataAccessor {
        private final SpaceInstLazyDataLoader loader;

        private SafeDataAccessor(SpaceInstLazyDataLoader loader) {
            this.loader = loader;
        }

        List<SpaceInst> getCopyOfSubSpaces() {
            return this.getCopyOfResource(this.loader.subSpaceIds, Administration::getSpaceInstById, i -> String.format("Space with id %s does not exist anymore, removing it from loaded subspace list", i));
        }

        List<ComponentInst> getCopyOfComponents() {
            return this.getCopyOfResource(this.loader.componentIds, Administration::getComponentInst, i -> String.format("Component with id %s does not exist anymore, removing it from loaded component list", i));
        }

        List<SpaceProfileInst> getCopyOfProfiles() {
            return List.copyOf(this.loader.spaceProfiles);
        }

        Stream<SpaceProfileInst> streamProfiles() {
            return this.loader.spaceProfiles.stream();
        }

        private <T> List<T> getCopyOfResource(List<String> ids, ResourceGetter<String, T> get, UnaryOperator<String> removeWarningMessage) {
            Administration service = Administration.get();
            Iterator<String> it = ids.iterator();
            Stream<Object> resources = Stream.of(new Object[0]);
            while (it.hasNext()) {
                String id = it.next();
                try {
                    resources = Stream.concat(resources, Stream.of(get.perform(service, id)));
                }
                catch (AdminException e) {
                    it.remove();
                    SilverLogger.getLogger((Object)this).warn("{0} (error: {1})", new Object[]{removeWarningMessage.apply(id), e.getMessage()});
                }
            }
            return resources.collect(Collectors.toUnmodifiableList());
        }

        @FunctionalInterface
        private static interface ResourceGetter<I, R> {
            public R perform(Administration var1, I var2) throws AdminException;
        }
    }
}

