/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Singleton;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.space.model.Space;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Bean
@Singleton
public class TreeCache {
    private final ConcurrentMap<Integer, Space> map = new ConcurrentHashMap<Integer, Space>();

    protected TreeCache() {
    }

    public synchronized void clearCache() {
        this.map.clear();
    }

    public Optional<SpaceInstLight> getSpaceInstLight(int spaceId) {
        Space space = this.getSpace(spaceId);
        if (space != null) {
            return Optional.ofNullable(space.getSpaceInstLight());
        }
        return Optional.empty();
    }

    public Space addSpace(Integer spaceId, Space space) {
        Objects.requireNonNull(spaceId);
        Objects.requireNonNull(space);
        return this.map.putIfAbsent(spaceId, space);
    }

    public synchronized void removeSpace(int spaceId) {
        Space space = (Space)this.map.get(spaceId);
        if (space != null) {
            ArrayList<SpaceInstLight> subspaces = new ArrayList<SpaceInstLight>(space.getSubspaces());
            for (SpaceInstLight subspace : subspaces) {
                this.removeSpace(subspace.getLocalId());
            }
            SpaceInstLight spaceInstLight = space.getSpaceInstLight();
            if (!spaceInstLight.isRoot()) {
                Space parent = this.getSpace(Integer.parseInt(spaceInstLight.getFatherId()));
                List<SpaceInstLight> children = parent.getSubspaces();
                children.remove(spaceInstLight);
            }
            this.map.remove(spaceId);
        }
    }

    public void setSubspaces(int spaceId, List<SpaceInstLight> subspaces) {
        Space space = this.getSpace(spaceId);
        if (space != null) {
            space.getSubspaces().clear();
            space.getSubspaces().addAll(subspaces);
        }
    }

    public List<ComponentInstLight> getComponents(int spaceId) {
        Space space = this.getSpace(spaceId);
        if (space != null) {
            return space.getComponents();
        }
        return new ArrayList<ComponentInstLight>();
    }

    public List<String> getComponentIds(int spaceId) {
        Space space = this.getSpace(spaceId);
        if (space != null) {
            return space.getComponentIds();
        }
        return new ArrayList<String>();
    }

    public List<SpaceInstLight> getSubSpaces(int spaceId) {
        Space space = this.getSpace(spaceId);
        if (space != null) {
            return space.getSubspaces();
        }
        return new ArrayList<SpaceInstLight>();
    }

    public void addComponent(ComponentInstLight component, int spaceId) {
        Space space = this.getSpace(spaceId);
        if (space != null) {
            space.addComponent(component);
        }
    }

    public void removeComponent(int spaceId, String componentId) {
        ComponentInstLight component;
        Space space = this.getSpace(spaceId);
        if (space != null && (component = space.getComponent(componentId)) != null) {
            space.removeComponent(component);
        }
    }

    public void setComponents(int spaceId, List<ComponentInstLight> components) {
        Space space = this.getSpace(spaceId);
        if (space != null) {
            space.clearComponents();
            space.setComponents(components);
        }
    }

    public List<ComponentInstLight> getComponentsInSpaceAndSubspaces(int spaceId) {
        ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
        components.addAll(this.getComponents(spaceId));
        for (SpaceInstLight subspace : this.getSubSpaces(spaceId)) {
            components.addAll(this.getComponentsInSpaceAndSubspaces(subspace.getLocalId()));
        }
        return components;
    }

    public List<SpaceInstLight> getSpacePath(int spaceId) {
        ArrayList<SpaceInstLight> path = new ArrayList<SpaceInstLight>();
        Optional<SpaceInstLight> space = this.getSpaceInstLight(spaceId);
        if (space.isPresent()) {
            path.add(0, space.get());
            while (space.isPresent() && !space.get().isRoot()) {
                space = this.getSpaceInstLight(Integer.parseInt(space.get().getFatherId()));
                space.ifPresent(spaceInstLight -> path.add(0, (SpaceInstLight)spaceInstLight));
            }
        }
        return path;
    }

    public synchronized Optional<ComponentInstLight> getComponent(String componentId) {
        for (Space space : this.map.values()) {
            ComponentInstLight component = space.getComponent(componentId);
            if (component == null) continue;
            return Optional.of(component);
        }
        return Optional.empty();
    }

    public synchronized Optional<SpaceInstLight> getSpaceContainingComponent(String componentId) {
        for (Space space : this.map.values()) {
            if (!space.containsComponent(componentId)) continue;
            return Optional.ofNullable(space.getSpaceInstLight());
        }
        return Optional.empty();
    }

    public List<SpaceInstLight> getComponentPath(String componentId) {
        ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
        Optional<ComponentInstLight> component = this.getComponent(componentId);
        component.filter(ComponentInstLight::hasDomainFather).ifPresent(c -> spaces.addAll(this.getSpacePath(this.getSpaceId((ComponentInstLight)c))));
        return spaces;
    }

    public synchronized void updateSpace(SpaceInstLight spaceLight) {
        Space space;
        if (spaceLight != null && StringUtil.isDefined((String)spaceLight.getId()) && (space = this.getSpace(spaceLight.getLocalId())) != null) {
            space.setSpaceInstLight(spaceLight);
            if (!spaceLight.isRoot()) {
                Space parent = this.getSpace(Integer.parseInt(spaceLight.getFatherId()));
                parent.updateSubspace(spaceLight);
            }
        }
    }

    private synchronized Space getSpace(int spaceId) {
        return (Space)this.map.get(spaceId);
    }

    public int getSpaceLevel(int spaceId) {
        return this.getSpacePath(spaceId).size() - 1;
    }

    public void addSubSpace(int spaceId, SpaceInstLight subSpace) {
        Space space = this.getSpace(spaceId);
        if (space != null) {
            Iterator<SpaceInstLight> spaceSubSpaceIterator = space.getSubspaces().iterator();
            while (spaceSubSpaceIterator.hasNext()) {
                SpaceInstLight currentSpaceSubSpace = spaceSubSpaceIterator.next();
                if (!currentSpaceSubSpace.getId().equals(subSpace.getId())) continue;
                spaceSubSpaceIterator.remove();
                break;
            }
            space.getSubspaces().add(subSpace);
        }
    }

    public void updateComponent(ComponentInstLight component) {
        Space space = this.getSpace(this.getSpaceId(component));
        space.updateComponent(component);
    }

    private int getSpaceId(ComponentInstLight component) {
        return Integer.parseInt(component.getSpaceId().replaceFirst("^WA", ""));
    }

    public boolean isSpacePresent(int spaceId) {
        return this.getSpace(spaceId) != null;
    }
}

