/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain;

import org.silverpeas.core.admin.domain.DomainService;
import org.silverpeas.core.admin.domain.exception.DomainCreationException;
import org.silverpeas.core.admin.domain.exception.DomainDeletionException;
import org.silverpeas.core.admin.domain.exception.NameAlreadyExistsInDatabaseException;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractDomainService
implements DomainService {
    protected void checkDomainName(String domainName) throws AdminException, NameAlreadyExistsInDatabaseException {
        Domain[] tabDomain;
        for (Domain domain : tabDomain = AdministrationServiceProvider.getAdminService().getAllDomains()) {
            if (!domain.getName().equalsIgnoreCase(domainName)) continue;
            throw new NameAlreadyExistsInDatabaseException(domainName);
        }
    }

    protected String getNextDomainId() throws DomainCreationException {
        try {
            return AdministrationServiceProvider.getAdminService().getNextDomainId();
        }
        catch (AdminException e) {
            throw new DomainCreationException((Throwable)((Object)e));
        }
    }

    protected String registerDomain(Domain domainToCreate) throws DomainCreationException {
        if (StringUtil.isNotDefined((String)domainToCreate.getId())) {
            domainToCreate.setId("-1");
        }
        try {
            return AdministrationServiceProvider.getAdminService().addDomain(domainToCreate);
        }
        catch (AdminException e) {
            throw new DomainCreationException((Throwable)((Object)e));
        }
    }

    protected String unRegisterDomain(Domain domainToRemove) throws DomainDeletionException {
        try {
            return AdministrationServiceProvider.getAdminService().removeDomain(domainToRemove.getId());
        }
        catch (AdminException e) {
            throw new DomainDeletionException((Throwable)((Object)e));
        }
    }
}

