/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.silverpeas.core.admin.domain.DomainDriver;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractDomainDriver
implements DomainDriver {
    private int domainId = -1;
    private final List<DomainProperty> domainProperties = new ArrayList<DomainProperty>();
    private String[] keys = null;
    private String propertiesL10n = "";
    private final Map<String, HashMap<String, String>> propertiesLabels = new HashMap<String, HashMap<String, String>>();
    private final Map<String, HashMap<String, String>> propertiesDescriptions = new HashMap<String, HashMap<String, String>>();
    private String[] mapParameters = null;
    private boolean synchroInProcess = false;
    private boolean x509Enabled = false;

    @Override
    public void init(int domainId, String initParam, String authenticationServer) throws AdminException {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)initParam);
        int nbProps = 0;
        this.domainId = domainId;
        this.domainProperties.clear();
        this.propertiesL10n = settings.getString("property.ResourceFile");
        String s = settings.getString("property.Number", "");
        if (StringUtil.isDefined((String)s)) {
            nbProps = Integer.parseInt(s);
        }
        this.keys = new String[nbProps];
        this.mapParameters = new String[nbProps];
        for (int i = 1; i <= nbProps; ++i) {
            s = settings.getString("property_" + i + ".Name", "");
            if (s.trim().isEmpty()) continue;
            DomainProperty prop = new DomainProperty(settings, i);
            this.domainProperties.add(prop);
            this.keys[i - 1] = prop.getName();
            this.mapParameters[i - 1] = prop.getMapParameter();
        }
        this.x509Enabled = settings.getBoolean("security.x509.enabled", false);
        this.initFromProperties(settings);
    }

    @Override
    public String[] getPropertiesNames() {
        return this.keys;
    }

    @Override
    public DomainProperty getProperty(String propName) {
        for (DomainProperty domainProp : this.domainProperties) {
            if (!domainProp.getName().equals(propName)) continue;
            return domainProp;
        }
        return null;
    }

    @Override
    public String[] getMapParameters() {
        return this.mapParameters;
    }

    @Override
    public List<DomainProperty> getPropertiesToImport(String language) {
        ArrayList<DomainProperty> props = new ArrayList<DomainProperty>();
        Map<String, String> theLabels = this.getPropertiesLabels(language);
        Map<String, String> theDescriptions = this.getPropertiesDescriptions(language);
        this.addPropertiesToImport(props, theDescriptions);
        for (DomainProperty domainProp : this.domainProperties) {
            if (!domainProp.isUsedToImport()) continue;
            String propLabel = theLabels.get(domainProp.getName());
            String propDescription = theDescriptions.get(domainProp.getName());
            domainProp.setLabel(propLabel);
            domainProp.setDescription(propDescription);
            props.add(domainProp);
        }
        return props;
    }

    @Override
    public void addPropertiesToImport(List<DomainProperty> props) {
    }

    @Override
    public void addPropertiesToImport(List<DomainProperty> props, Map<String, String> theDescriptions) {
    }

    @Override
    public Map<String, String> getPropertiesLabels(String language) {
        HashMap<String, String> labels = this.propertiesLabels.get(language);
        if (labels == null) {
            HashMap<String, String> newLabels = new HashMap<String, String>();
            LocalizationBundle msg = ResourceLocator.getLocalizationBundle((String)this.propertiesL10n, (String)language);
            for (String key : this.keys) {
                try {
                    newLabels.put(key, msg.getString(key));
                }
                catch (MissingResourceException mre) {
                    SilverLogger.getLogger((Object)this).warn(mre.getMessage(), new Object[0]);
                }
            }
            this.propertiesLabels.put(language, newLabels);
            labels = newLabels;
        }
        return labels;
    }

    @Override
    public Map<String, String> getPropertiesDescriptions(String language) {
        HashMap<String, String> desc = this.propertiesDescriptions.get(language);
        if (desc == null) {
            HashMap<String, String> newDescriptions = new HashMap<String, String>();
            LocalizationBundle msg = ResourceLocator.getLocalizationBundle((String)this.propertiesL10n, (String)language);
            for (String key : this.keys) {
                try {
                    newDescriptions.put(key, msg.getString(key + ".description"));
                }
                catch (MissingResourceException mre) {
                    SilverLogger.getLogger((Object)this).warn(mre.getMessage(), new Object[0]);
                }
            }
            this.propertiesDescriptions.put(language, newDescriptions);
            desc = newDescriptions;
        }
        return desc;
    }

    @Override
    public void initFromProperties(SettingBundle rs) throws AdminException {
    }

    @Override
    public long getDriverActions() {
        if (this.x509Enabled) {
            return 33279L;
        }
        return 511L;
    }

    @Override
    public boolean isSynchroOnLoginEnabled() {
        return false;
    }

    @Override
    public boolean isSynchroThreaded() {
        return false;
    }

    @Override
    public boolean isSynchroOnLoginRecursToGroups() {
        return true;
    }

    @Override
    public boolean isGroupsInheritProfiles() {
        return false;
    }

    @Override
    public boolean mustImportUsers() {
        return true;
    }

    @Override
    public boolean isX509CertificateEnabled() {
        return false;
    }

    @Override
    public void beginSynchronization() {
        this.setSynchroInProcess(true);
    }

    @Override
    public boolean isSynchroInProcess() {
        return this.synchroInProcess;
    }

    @Override
    public String endSynchronization(boolean cancelSynchro) {
        this.setSynchroInProcess(false);
        return "";
    }

    protected static int idAsInt(String id) {
        return StringUtil.asInt((String)id, (int)-1);
    }

    protected static String idAsString(int id) {
        return String.valueOf(id);
    }

    protected int getDomainId() {
        return this.domainId;
    }

    protected void setSynchroInProcess(boolean synchroInProcess) {
        this.synchroInProcess = synchroInProcess;
    }

    protected boolean isX509Enabled() {
        return this.x509Enabled;
    }
}

