/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin;

import java.io.Serializable;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.persistence.datasource.repository.PaginationCriterion;
import org.silverpeas.core.util.PaginationList;
import org.silverpeas.core.util.SilverpeasList;

public class PaginationPage
implements Serializable {
    private static final long serialVersionUID = -4691780072884201651L;
    private static final int DEFAULT_NB_ITEMS_PER_PAGE = 10;
    public static final PaginationPage DEFAULT = new PaginationPage(1, 10);
    private int page;
    private final int count;
    private boolean originalSizeRequired = true;

    public PaginationPage(int pageNumber, int pageSize) {
        this.page = pageNumber;
        this.count = pageSize;
    }

    public PaginationPage originalSizeIsNotRequired() {
        this.originalSizeRequired = false;
        return this;
    }

    public int getPageNumber() {
        return this.page;
    }

    public int getPageSize() {
        return this.count;
    }

    public PaginationCriterion asCriterion() {
        return new PaginationCriterion(this.getPageNumber(), this.getPageSize()).setOriginalSizeRequired(this.originalSizeRequired);
    }

    public <T> SilverpeasList<T> getPaginatedListFrom(List<T> list) {
        Pair<Integer, Integer> indexes = this.getStartLastIndexesFor(list);
        if (list instanceof SilverpeasList && ((SilverpeasList)list).isSlice()) {
            return (SilverpeasList)list;
        }
        List<T> lightList = list.subList((Integer)indexes.getLeft(), (Integer)indexes.getRight());
        return PaginationList.from(lightList, (long)list.size());
    }

    private <T> Pair<Integer, Integer> getStartLastIndexesFor(List<T> list) {
        SilverpeasList silverpeasList = SilverpeasList.wrap(list);
        int maxSize = (int)silverpeasList.originalListSize();
        int firstIndex = (this.getPageNumber() - 1) * this.getPageSize();
        if (firstIndex >= maxSize) {
            firstIndex = 0;
            this.page = 1;
        }
        boolean isLastPage = firstIndex + this.getPageSize() >= maxSize;
        int lastIndex = isLastPage ? maxSize : firstIndex + this.getPageSize();
        return Pair.of((Object)firstIndex, (Object)lastIndex);
    }

    public String toString() {
        return new StringJoiner(", ", PaginationPage.class.getSimpleName() + "[", "]").add("page=" + this.page).add("count=" + this.count).add("originalSizeRequired=" + this.originalSizeRequired).toString();
    }
}

