/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.Query;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.query.QueryOptions;
import org.apache.jackrabbit.oak.query.UnionQueryImpl;
import org.apache.jackrabbit.oak.query.ValueConverter;
import org.apache.jackrabbit.oak.query.ast.AstElementFactory;
import org.apache.jackrabbit.oak.query.ast.BindVariableValueImpl;
import org.apache.jackrabbit.oak.query.ast.ColumnImpl;
import org.apache.jackrabbit.oak.query.ast.ComparisonImpl;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.JoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.JoinType;
import org.apache.jackrabbit.oak.query.ast.LiteralImpl;
import org.apache.jackrabbit.oak.query.ast.NodeTypeInfo;
import org.apache.jackrabbit.oak.query.ast.NodeTypeInfoProvider;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyInexistenceImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyValueImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.stats.QueryStatsData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQL2Parser {
    private static final Logger LOG = LoggerFactory.getLogger(SQL2Parser.class);
    private static final int CHAR_END = -1;
    private static final int CHAR_IGNORE = 0;
    private static final int CHAR_VALUE = 2;
    private static final int CHAR_QUOTED = 3;
    private static final int CHAR_NAME = 4;
    private static final int CHAR_SPECIAL_1 = 5;
    private static final int CHAR_SPECIAL_2 = 6;
    private static final int CHAR_STRING = 7;
    private static final int CHAR_DECIMAL = 8;
    private static final int CHAR_BRACKETED = 9;
    private static final int KEYWORD = 1;
    private static final int IDENTIFIER = 2;
    private static final int PARAMETER = 3;
    private static final int END = 4;
    private static final int VALUE = 5;
    private static final int MINUS = 12;
    private static final int PLUS = 13;
    private static final int OPEN = 14;
    private static final int CLOSE = 15;
    private final NodeTypeInfoProvider nodeTypes;
    private String statement;
    private char[] statementChars;
    private int[] characterTypes;
    private int parseIndex;
    private int currentTokenType;
    private String currentToken;
    private boolean currentTokenQuoted;
    private PropertyValue currentValue;
    private ArrayList<String> expected;
    private HashMap<String, BindVariableValueImpl> bindVariables;
    private final Map<String, SelectorImpl> selectors = new HashMap<String, SelectorImpl>();
    private boolean allowTextLiterals = true;
    private boolean allowNumberLiterals = true;
    private boolean includeSelectorNameInWildcardColumns = true;
    private final AstElementFactory factory = new AstElementFactory();
    private boolean supportSQL1;
    private NamePathMapper namePathMapper;
    private final QueryEngineSettings settings;
    private boolean literalUsageLogged;
    private final QueryStatsData.QueryExecutionStats stats;

    public SQL2Parser(NamePathMapper namePathMapper, NodeTypeInfoProvider nodeTypes, QueryEngineSettings settings, QueryStatsData.QueryExecutionStats stats) {
        this.namePathMapper = namePathMapper;
        this.nodeTypes = Objects.requireNonNull(nodeTypes);
        this.settings = Objects.requireNonNull(settings);
        this.stats = Objects.requireNonNull(stats);
    }

    public Query parse(String query, boolean initialise) throws ParseException {
        this.initialize(query);
        this.selectors.clear();
        this.expected = new ArrayList();
        this.bindVariables = new HashMap();
        this.read();
        boolean explain = false;
        boolean measure = false;
        if (this.readIf("EXPLAIN")) {
            explain = true;
        }
        if (this.readIf("MEASURE")) {
            measure = true;
        }
        Query q = this.parseSelect();
        while (this.readIf("UNION")) {
            boolean unionAll = this.readIf("ALL");
            QueryImpl q2 = this.parseSelect();
            q = new UnionQueryImpl(unionAll, q, q2, this.settings);
        }
        OrderingImpl[] orderings = null;
        if (this.readIf("ORDER")) {
            this.read("BY");
            orderings = this.parseOrder();
        }
        QueryOptions defaultOptions = this.settings.getAutomaticQueryOptions().getDefaultValues(query);
        QueryOptions options = new QueryOptions(defaultOptions);
        if (options.limit.isPresent()) {
            q.setLimit(options.limit.get());
        }
        if (options.offset.isPresent()) {
            q.setLimit(options.offset.get());
        }
        if (this.readIf("OPTION")) {
            this.read("(");
            while (true) {
                if (this.readIf("TRAVERSAL")) {
                    String n = this.readName().toUpperCase(Locale.ENGLISH);
                    options.traversal = QueryOptions.Traversal.valueOf(n);
                } else if (this.readIf("INDEX")) {
                    if (this.readIf("NAME")) {
                        options.indexName = this.readName();
                    } else if (this.readIf("TAG")) {
                        options.indexTag = this.readLabel();
                    }
                } else if (this.readIf("OFFSET")) {
                    q.setOffset(this.readNumber());
                } else if (this.readIf("LIMIT")) {
                    q.setLimit(this.readNumber());
                } else if (this.readIf("PREFETCHES")) {
                    options.prefetchCount = Optional.of((int)this.readNumber());
                } else {
                    if (!this.readIf("PREFETCH")) break;
                    this.read("(");
                    ArrayList<String> list = new ArrayList<String>();
                    do {
                        String x = (String)this.readString().getValue(Type.STRING);
                        list.add(x);
                    } while (this.readIf(","));
                    this.read(")");
                    options.prefetch = list;
                }
                this.readIf(",");
            }
            this.read(")");
        }
        if (!this.currentToken.isEmpty()) {
            throw this.getSyntaxError("<end>");
        }
        q.setOrderings(orderings);
        q.setExplain(explain);
        q.setMeasure(measure);
        q.setInternal(SQL2Parser.isInternal(query));
        q.setQueryOptions(options);
        if (initialise) {
            try {
                q.init();
            }
            catch (Exception e) {
                ParseException e2 = new ParseException(this.statement + ": " + e.getMessage(), 0);
                e2.initCause(e);
                throw e2;
            }
        }
        return q;
    }

    public Query parse(String query) throws ParseException {
        return this.parse(query, true);
    }

    private QueryImpl parseSelect() throws ParseException {
        this.read("SELECT");
        boolean distinct = this.readIf("DISTINCT");
        ArrayList<ColumnOrWildcard> list = this.parseColumns();
        if (this.supportSQL1) {
            SQL2Parser.addColumnIfNecessary(list, "jcr:path", "jcr:path");
            SQL2Parser.addColumnIfNecessary(list, "jcr:score", "jcr:score");
        }
        this.read("FROM");
        SourceImpl source = this.parseSource();
        ColumnImpl[] columnArray = this.resolveColumns(list);
        ConstraintImpl constraint = null;
        if (this.readIf("WHERE")) {
            constraint = this.parseConstraint();
        }
        QueryImpl q = new QueryImpl(this.statement, source, constraint, columnArray, this.namePathMapper, this.settings, this.stats);
        q.setDistinct(distinct);
        return q;
    }

    private static void addColumnIfNecessary(ArrayList<ColumnOrWildcard> list, String columnName, String propertyName) {
        for (ColumnOrWildcard c : list) {
            String col = c.columnName;
            if (!columnName.equals(col)) continue;
            return;
        }
        ColumnOrWildcard column = new ColumnOrWildcard();
        column.columnName = columnName;
        column.propertyName = propertyName;
        list.add(column);
    }

    public void setSupportSQL1(boolean sql1) {
        this.supportSQL1 = sql1;
    }

    private SelectorImpl parseSelector() throws ParseException {
        NodeTypeInfo nodeTypeInfo;
        String nodeTypeName = this.readName();
        if (this.namePathMapper != null) {
            try {
                nodeTypeName = this.namePathMapper.getOakName(nodeTypeName);
            }
            catch (RepositoryException e) {
                ParseException e2 = this.getSyntaxError("could not convert node type name " + nodeTypeName);
                e2.initCause(e);
                throw e2;
            }
        }
        if (!(nodeTypeInfo = this.nodeTypes.getNodeTypeInfo(nodeTypeName)).exists()) {
            throw this.getSyntaxError("unknown node type");
        }
        String selectorName = nodeTypeName;
        if (this.readIf("AS")) {
            selectorName = this.readName();
        }
        return this.factory.selector(nodeTypeInfo, selectorName);
    }

    private long readNumber() throws ParseException {
        String label = this.readName();
        try {
            return Long.parseLong(label);
        }
        catch (NumberFormatException nfe) {
            throw this.getSyntaxError("0-9");
        }
    }

    private String readLabel() throws ParseException {
        String label = this.readName();
        if (!label.matches("[a-zA-Z0-9_]*") || label.isEmpty() || label.length() > 128) {
            throw this.getSyntaxError("a-z, A-Z, 0-9, _");
        }
        return label;
    }

    private String readName() throws ParseException {
        if (this.currentTokenType == 4) {
            throw this.getSyntaxError("a token");
        }
        String s = this.currentTokenType == 5 ? (String)this.currentValue.getValue(Type.STRING) : this.currentToken;
        this.read();
        return s;
    }

    private SourceImpl parseSource() throws ParseException {
        SelectorImpl selector = this.parseSelector();
        this.selectors.put(selector.getSelectorName(), selector);
        SourceImpl source = selector;
        while (true) {
            JoinType joinType;
            if (this.readIf("RIGHT")) {
                this.read("OUTER");
                joinType = JoinType.RIGHT_OUTER;
            } else if (this.readIf("LEFT")) {
                this.read("OUTER");
                joinType = JoinType.LEFT_OUTER;
            } else {
                if (!this.readIf("INNER")) break;
                joinType = JoinType.INNER;
            }
            this.read("JOIN");
            selector = this.parseSelector();
            this.selectors.put(selector.getSelectorName(), selector);
            this.read("ON");
            JoinConditionImpl on = this.parseJoinCondition();
            source = this.factory.join(source, selector, joinType, on);
        }
        return source;
    }

    private JoinConditionImpl parseJoinCondition() throws ParseException {
        boolean identifier = this.currentTokenType == 2;
        String name = this.readName();
        if (identifier && this.readIf("(")) {
            JoinConditionImpl c;
            if ("ISSAMENODE".equalsIgnoreCase(name)) {
                String selector1 = this.readName();
                this.read(",");
                String selector2 = this.readName();
                c = this.readIf(",") ? this.factory.sameNodeJoinCondition(selector1, selector2, this.readPath()) : this.factory.sameNodeJoinCondition(selector1, selector2, ".");
            } else if ("ISCHILDNODE".equalsIgnoreCase(name)) {
                String childSelector = this.readName();
                this.read(",");
                c = this.factory.childNodeJoinCondition(childSelector, this.readName());
            } else if ("ISDESCENDANTNODE".equalsIgnoreCase(name)) {
                String descendantSelector = this.readName();
                this.read(",");
                c = this.factory.descendantNodeJoinCondition(descendantSelector, this.readName());
            } else {
                throw this.getSyntaxError("ISSAMENODE, ISCHILDNODE, or ISDESCENDANTNODE");
            }
            this.read(")");
            return c;
        }
        String selector1 = name;
        this.read(".");
        String property1 = this.readName();
        this.read("=");
        String selector2 = this.readName();
        this.read(".");
        return this.factory.equiJoinCondition(selector1, property1, selector2, this.readName());
    }

    private ConstraintImpl parseConstraint() throws ParseException {
        ConstraintImpl a = this.parseAnd();
        while (this.readIf("OR")) {
            a = this.factory.or(a, this.parseAnd());
        }
        return a;
    }

    private ConstraintImpl parseAnd() throws ParseException {
        ConstraintImpl a = this.parseCondition();
        while (this.readIf("AND")) {
            a = this.factory.and(a, this.parseCondition());
        }
        return a;
    }

    private ConstraintImpl parseCondition() throws ParseException {
        ConstraintImpl a;
        if (this.readIf("NOT")) {
            a = this.factory.not(this.parseCondition());
        } else if (this.readIf("(")) {
            a = this.parseConstraint();
            this.read(")");
        } else if (this.currentTokenType == 2) {
            String identifier = this.readName();
            if (this.readIf("(")) {
                a = this.parseConditionFunctionIf(identifier);
                if (a == null) {
                    DynamicOperandImpl op = this.parseExpressionFunction(identifier);
                    a = this.parseCondition(op);
                }
            } else {
                a = this.readIf(".") ? this.parseCondition(this.factory.propertyValue(identifier, this.readName())) : this.parseCondition(this.factory.propertyValue(this.getOnlySelectorName(), identifier));
            }
        } else if ("[".equals(this.currentToken)) {
            String name = this.readName();
            a = this.readIf(".") ? this.parseCondition(this.factory.propertyValue(name, this.readName())) : this.parseCondition(this.factory.propertyValue(this.getOnlySelectorName(), name));
        } else {
            if (this.supportSQL1) {
                StaticOperandImpl left = this.parseStaticOperand();
                if (this.readIf("IN")) {
                    DynamicOperandImpl right = this.parseDynamicOperand();
                    ComparisonImpl c = this.factory.comparison(right, Operator.EQUAL, left);
                    return c;
                }
                throw this.getSyntaxError();
            }
            throw this.getSyntaxError();
        }
        return a;
    }

    private ConstraintImpl parseCondition(DynamicOperandImpl left) throws ParseException {
        ConstraintImpl c;
        if (this.readIf("=")) {
            c = this.factory.comparison(left, Operator.EQUAL, this.parseStaticOperand());
        } else if (this.readIf("<>")) {
            c = this.factory.comparison(left, Operator.NOT_EQUAL, this.parseStaticOperand());
        } else if (this.readIf("<")) {
            c = this.factory.comparison(left, Operator.LESS_THAN, this.parseStaticOperand());
        } else if (this.readIf(">")) {
            c = this.factory.comparison(left, Operator.GREATER_THAN, this.parseStaticOperand());
        } else if (this.readIf("<=")) {
            c = this.factory.comparison(left, Operator.LESS_OR_EQUAL, this.parseStaticOperand());
        } else if (this.readIf(">=")) {
            c = this.factory.comparison(left, Operator.GREATER_OR_EQUAL, this.parseStaticOperand());
        } else if (this.readIf("LIKE")) {
            c = this.factory.comparison(left, Operator.LIKE, this.parseStaticOperand());
            if (this.supportSQL1 && this.readIf("ESCAPE")) {
                StaticOperandImpl esc = this.parseStaticOperand();
                if (!(esc instanceof LiteralImpl)) {
                    throw this.getSyntaxError("only ESCAPE '' is supported");
                }
                PropertyValue v = ((LiteralImpl)esc).getLiteralValue();
                if (!((String)v.getValue(Type.STRING)).equals("\\")) {
                    throw this.getSyntaxError("only ESCAPE '' is supported");
                }
            }
        } else if (this.readIf("IN")) {
            this.read("(");
            ArrayList<StaticOperandImpl> list = new ArrayList<StaticOperandImpl>();
            do {
                StaticOperandImpl x = this.parseStaticOperand();
                list.add(x);
            } while (this.readIf(","));
            this.read(")");
            c = this.factory.in(left, list);
        } else if (this.readIf("IS")) {
            boolean not = this.readIf("NOT");
            this.read("NULL");
            if (!(left instanceof PropertyValueImpl)) {
                throw this.getSyntaxError("propertyName (NOT NULL is only supported for properties)");
            }
            PropertyValueImpl p = (PropertyValueImpl)left;
            c = not ? this.getPropertyExistence(p) : this.getPropertyInexistence(p);
        } else if (this.readIf("NOT")) {
            if (this.readIf("IS")) {
                this.read("NULL");
                if (!(left instanceof PropertyValueImpl)) {
                    throw new ParseException("Only property values can be tested for NOT IS NULL; got: " + left.getClass().getName(), this.parseIndex);
                }
                PropertyValueImpl pv = (PropertyValueImpl)left;
                c = this.getPropertyExistence(pv);
            } else {
                this.read("LIKE");
                c = this.factory.comparison(left, Operator.LIKE, this.parseStaticOperand());
                c = this.factory.not(c);
            }
        } else {
            throw this.getSyntaxError();
        }
        return c;
    }

    private PropertyExistenceImpl getPropertyExistence(PropertyValueImpl p) throws ParseException {
        return this.factory.propertyExistence(p.getSelectorName(), p.getPropertyName());
    }

    private PropertyInexistenceImpl getPropertyInexistence(PropertyValueImpl p) throws ParseException {
        return this.factory.propertyInexistence(p.getSelectorName(), p.getPropertyName());
    }

    private ConstraintImpl parseConditionFunctionIf(String functionName) throws ParseException {
        ConstraintImpl c;
        if ("CONTAINS".equalsIgnoreCase(functionName)) {
            if (this.readIf("*")) {
                this.read(",");
                c = this.factory.fullTextSearch(this.getOnlySelectorName(), null, this.parseStaticOperand());
            } else if (this.readIf(".")) {
                if (!this.supportSQL1) {
                    throw this.getSyntaxError("selector name, property name, or *");
                }
                this.read(",");
                c = this.factory.fullTextSearch(this.getOnlySelectorName(), null, this.parseStaticOperand());
            } else {
                String name = this.readName();
                if (this.readIf(".")) {
                    if (this.readIf("*")) {
                        this.read(",");
                        c = this.factory.fullTextSearch(name, null, this.parseStaticOperand());
                    } else {
                        String selector = name;
                        name = this.readName();
                        this.read(",");
                        c = this.factory.fullTextSearch(selector, name, this.parseStaticOperand());
                    }
                } else {
                    this.read(",");
                    c = this.factory.fullTextSearch(this.getOnlySelectorName(), name, this.parseStaticOperand());
                }
            }
        } else if ("ISSAMENODE".equalsIgnoreCase(functionName)) {
            String name = this.readName();
            c = this.readIf(",") ? this.factory.sameNode(name, this.readAbsolutePath()) : this.factory.sameNode(this.getOnlySelectorName(), name);
        } else if ("ISCHILDNODE".equalsIgnoreCase(functionName)) {
            String name = this.readName();
            c = this.readIf(",") ? this.factory.childNode(name, this.readAbsolutePath()) : this.factory.childNode(this.getOnlySelectorName(), name);
        } else if ("ISDESCENDANTNODE".equalsIgnoreCase(functionName)) {
            String name = this.readName();
            c = this.readIf(",") ? this.factory.descendantNode(name, this.readAbsolutePath()) : this.factory.descendantNode(this.getOnlySelectorName(), name);
        } else if ("SIMILAR".equalsIgnoreCase(functionName)) {
            if (this.readIf(".") || this.readIf("*")) {
                this.read(",");
                c = this.factory.similar(this.getOnlySelectorName(), null, this.parseStaticOperand());
            } else {
                String name = this.readName();
                if (this.readIf(".")) {
                    if (this.readIf("*")) {
                        this.read(",");
                        c = this.factory.fullTextSearch(name, null, this.parseStaticOperand());
                    } else {
                        String selector = name;
                        name = this.readName();
                        this.read(",");
                        c = this.factory.fullTextSearch(selector, name, this.parseStaticOperand());
                    }
                } else {
                    this.read(",");
                    c = this.factory.fullTextSearch(this.getOnlySelectorName(), name, this.parseStaticOperand());
                }
            }
        } else if ("NATIVE".equalsIgnoreCase(functionName)) {
            String selectorName;
            LOG.warn("Native queries are deprecated. Query:{}", (Object)this.statement);
            if (this.currentTokenType == 2) {
                selectorName = this.readName();
                this.read(",");
            } else {
                selectorName = this.getOnlySelectorName();
            }
            String language = (String)this.readString().getValue(Type.STRING);
            this.read(",");
            c = this.factory.nativeFunction(selectorName, language, this.parseStaticOperand());
        } else if ("SPELLCHECK".equalsIgnoreCase(functionName)) {
            String selectorName;
            if (this.currentTokenType == 2) {
                selectorName = this.readName();
                this.read(",");
            } else {
                selectorName = this.getOnlySelectorName();
            }
            c = this.factory.spellcheck(selectorName, this.parseStaticOperand());
        } else if ("SUGGEST".equalsIgnoreCase(functionName)) {
            String selectorName;
            if (this.currentTokenType == 2) {
                selectorName = this.readName();
                this.read(",");
            } else {
                selectorName = this.getOnlySelectorName();
            }
            c = this.factory.suggest(selectorName, this.parseStaticOperand());
        } else {
            return null;
        }
        this.read(")");
        return c;
    }

    private String readAbsolutePath() throws ParseException {
        String path = this.readPath();
        if (!PathUtils.isAbsolute((String)path)) {
            throw this.getSyntaxError("absolute path");
        }
        return path;
    }

    private String readPath() throws ParseException {
        return this.readName();
    }

    private DynamicOperandImpl parseDynamicOperand() throws ParseException {
        boolean identifier = this.currentTokenType == 2;
        String name = this.readName();
        if (identifier && this.readIf("(")) {
            return this.parseExpressionFunction(name);
        }
        return this.parsePropertyValue(name);
    }

    private DynamicOperandImpl parseExpressionFunction(String functionName) throws ParseException {
        DynamicOperandImpl op;
        if ("LENGTH".equalsIgnoreCase(functionName)) {
            op = this.factory.length(this.parseDynamicOperand());
        } else if ("NAME".equalsIgnoreCase(functionName)) {
            op = this.isToken(")") ? this.factory.nodeName(this.getOnlySelectorName()) : this.factory.nodeName(this.readName());
        } else if ("LOCALNAME".equalsIgnoreCase(functionName)) {
            op = this.isToken(")") ? this.factory.nodeLocalName(this.getOnlySelectorName()) : this.factory.nodeLocalName(this.readName());
        } else if ("PATH".equalsIgnoreCase(functionName)) {
            op = this.isToken(")") ? this.factory.path(this.getOnlySelectorName()) : this.factory.path(this.readName());
        } else if ("SCORE".equalsIgnoreCase(functionName)) {
            op = this.isToken(")") ? this.factory.fullTextSearchScore(this.getOnlySelectorName()) : this.factory.fullTextSearchScore(this.readName());
        } else if ("COALESCE".equalsIgnoreCase(functionName)) {
            DynamicOperandImpl op1 = this.parseDynamicOperand();
            this.read(",");
            DynamicOperandImpl op2 = this.parseDynamicOperand();
            op = this.factory.coalesce(op1, op2);
        } else if ("FIRST".equalsIgnoreCase(functionName)) {
            op = this.factory.first(this.parseDynamicOperand());
        } else if ("LOWER".equalsIgnoreCase(functionName)) {
            op = this.factory.lowerCase(this.parseDynamicOperand());
        } else if ("UPPER".equalsIgnoreCase(functionName)) {
            op = this.factory.upperCase(this.parseDynamicOperand());
        } else if ("PROPERTY".equalsIgnoreCase(functionName)) {
            PropertyValueImpl pv = this.parsePropertyValue(this.readName());
            this.read(",");
            op = this.factory.propertyValue(pv.getSelectorName(), pv.getPropertyName(), (String)this.readString().getValue(Type.STRING));
        } else {
            throw this.getSyntaxError("LENGTH, FIRST, NAME, LOCALNAME, PATH, SCORE, COALESCE, LOWER, UPPER, or PROPERTY");
        }
        this.read(")");
        return op;
    }

    private PropertyValueImpl parsePropertyValue(String name) throws ParseException {
        if (this.readIf(".")) {
            return this.factory.propertyValue(name, this.readName());
        }
        return this.factory.propertyValue(this.getOnlySelectorName(), name);
    }

    private StaticOperandImpl parseStaticOperand() throws ParseException {
        int valueType;
        if (this.currentTokenType == 13) {
            this.read();
            if (this.currentTokenType != 5) {
                throw this.getSyntaxError("number");
            }
            valueType = this.currentValue.getType().tag();
            switch (valueType) {
                case 3: {
                    this.currentValue = PropertyValues.newLong((Long)((Long)this.currentValue.getValue(Type.LONG)));
                    break;
                }
                case 4: {
                    this.currentValue = PropertyValues.newDouble((Double)((Double)this.currentValue.getValue(Type.DOUBLE)));
                    break;
                }
                case 12: {
                    this.currentValue = PropertyValues.newDecimal((BigDecimal)((BigDecimal)this.currentValue.getValue(Type.DECIMAL)).negate());
                    break;
                }
                default: {
                    throw this.getSyntaxError("Illegal operation: + " + this.currentValue);
                }
            }
        } else if (this.currentTokenType == 12) {
            this.read();
            if (this.currentTokenType != 5) {
                throw this.getSyntaxError("number");
            }
            valueType = this.currentValue.getType().tag();
            switch (valueType) {
                case 3: {
                    this.currentValue = PropertyValues.newLong((Long)(-((Long)this.currentValue.getValue(Type.LONG)).longValue()));
                    break;
                }
                case 4: {
                    this.currentValue = PropertyValues.newDouble((Double)(-((Double)this.currentValue.getValue(Type.DOUBLE)).doubleValue()));
                    break;
                }
                case 6: {
                    this.currentValue = PropertyValues.newBoolean(((Boolean)this.currentValue.getValue(Type.BOOLEAN) == false ? 1 : 0) != 0);
                    break;
                }
                case 12: {
                    this.currentValue = PropertyValues.newDecimal((BigDecimal)((BigDecimal)this.currentValue.getValue(Type.DECIMAL)).negate());
                    break;
                }
                default: {
                    throw this.getSyntaxError("Illegal operation: -" + this.currentValue);
                }
            }
        }
        if (this.currentTokenType == 5) {
            LiteralImpl literal = this.getUncastLiteral(this.currentValue);
            this.read();
            return literal;
        }
        if (this.currentTokenType == 3) {
            BindVariableValueImpl var;
            this.read();
            Object name = this.readName();
            if (this.readIf(":")) {
                name = (String)name + ":" + this.readName();
            }
            if ((var = this.bindVariables.get(name)) == null) {
                var = this.factory.bindVariable((String)name);
                this.bindVariables.put((String)name, var);
            }
            return var;
        }
        if (this.readIf("TRUE")) {
            LiteralImpl literal = this.getUncastLiteral(PropertyValues.newBoolean((boolean)true));
            return literal;
        }
        if (this.readIf("FALSE")) {
            LiteralImpl literal = this.getUncastLiteral(PropertyValues.newBoolean((boolean)false));
            return literal;
        }
        if (this.readIf("CAST")) {
            this.read("(");
            StaticOperandImpl op = this.parseStaticOperand();
            if (!(op instanceof LiteralImpl)) {
                throw this.getSyntaxError("literal");
            }
            LiteralImpl literal = (LiteralImpl)op;
            PropertyValue value = literal.getLiteralValue();
            this.read("AS");
            value = this.parseCastAs(value);
            this.read(")");
            literal = this.factory.literal(value);
            return literal;
        }
        if (this.supportSQL1 && this.readIf("TIMESTAMP")) {
            StaticOperandImpl op = this.parseStaticOperand();
            if (!(op instanceof LiteralImpl)) {
                throw this.getSyntaxError("literal");
            }
            LiteralImpl literal = (LiteralImpl)op;
            PropertyValue value = literal.getLiteralValue();
            value = PropertyValues.newDate((String)((String)value.getValue(Type.DATE)));
            literal = this.factory.literal(value);
            return literal;
        }
        throw this.getSyntaxError("static operand");
    }

    private LiteralImpl getUncastLiteral(PropertyValue value) {
        return this.factory.literal(value);
    }

    private PropertyValue parseCastAs(PropertyValue value) throws ParseException {
        if (this.currentTokenQuoted) {
            throw this.getSyntaxError("data type (STRING|BINARY|...)");
        }
        int propertyType = SQL2Parser.getPropertyTypeFromName(this.currentToken);
        this.read();
        PropertyValue v = ValueConverter.convert(value, propertyType, null);
        if (v == null) {
            throw this.getSyntaxError("data type (STRING|BINARY|...)");
        }
        return v;
    }

    public static int getPropertyTypeFromName(String name) {
        if (SQL2Parser.matchesPropertyType(1, name)) {
            return 1;
        }
        if (SQL2Parser.matchesPropertyType(2, name)) {
            return 2;
        }
        if (SQL2Parser.matchesPropertyType(5, name)) {
            return 5;
        }
        if (SQL2Parser.matchesPropertyType(3, name)) {
            return 3;
        }
        if (SQL2Parser.matchesPropertyType(4, name)) {
            return 4;
        }
        if (SQL2Parser.matchesPropertyType(12, name)) {
            return 12;
        }
        if (SQL2Parser.matchesPropertyType(6, name)) {
            return 6;
        }
        if (SQL2Parser.matchesPropertyType(7, name)) {
            return 7;
        }
        if (SQL2Parser.matchesPropertyType(8, name)) {
            return 8;
        }
        if (SQL2Parser.matchesPropertyType(9, name)) {
            return 9;
        }
        if (SQL2Parser.matchesPropertyType(10, name)) {
            return 10;
        }
        if (SQL2Parser.matchesPropertyType(11, name)) {
            return 11;
        }
        return 0;
    }

    private static boolean matchesPropertyType(int propertyType, String name) {
        String typeName = PropertyType.nameFromValue((int)propertyType);
        return typeName.equalsIgnoreCase(name);
    }

    private OrderingImpl[] parseOrder() throws ParseException {
        ArrayList<OrderingImpl> orderList = new ArrayList<OrderingImpl>();
        do {
            OrderingImpl ordering;
            DynamicOperandImpl op = this.parseDynamicOperand();
            if (this.readIf("DESC")) {
                ordering = this.factory.descending(op);
            } else {
                this.readIf("ASC");
                ordering = this.factory.ascending(op);
            }
            orderList.add(ordering);
        } while (this.readIf(","));
        OrderingImpl[] orderings = new OrderingImpl[orderList.size()];
        orderList.toArray(orderings);
        return orderings;
    }

    private ArrayList<ColumnOrWildcard> parseColumns() throws ParseException {
        ArrayList<ColumnOrWildcard> list = new ArrayList<ColumnOrWildcard>();
        if (this.readIf("*")) {
            list.add(new ColumnOrWildcard());
        } else {
            do {
                ColumnOrWildcard column = new ColumnOrWildcard();
                if (this.readIf("*")) {
                    column.propertyName = null;
                } else if (this.readIf("EXCERPT")) {
                    column.propertyName = "rep:excerpt";
                    this.read("(");
                    if (!this.readIf(")")) {
                        if (!this.readIf(".")) {
                            column.selectorName = this.readName();
                        }
                        this.read(")");
                    }
                    this.readOptionalAlias(column);
                } else {
                    column.propertyName = this.readName();
                    if (column.propertyName.equals("rep:spellcheck")) {
                        if (this.readIf("(")) {
                            this.read(")");
                            column.propertyName = ":spellcheck";
                        }
                        this.readOptionalAlias(column);
                    } else if (this.readIf(".")) {
                        column.selectorName = column.propertyName;
                        if (this.readIf("*")) {
                            column.propertyName = null;
                        } else {
                            column.propertyName = this.readName();
                            if (!this.readOptionalAlias(column)) {
                                column.columnName = column.selectorName + "." + column.propertyName;
                            }
                        }
                    } else {
                        this.readOptionalAlias(column);
                    }
                }
                list.add(column);
            } while (this.readIf(","));
        }
        return list;
    }

    private boolean readOptionalAlias(ColumnOrWildcard column) throws ParseException {
        if (this.readIf("AS")) {
            column.columnName = this.readName();
            return true;
        }
        return false;
    }

    private ColumnImpl[] resolveColumns(ArrayList<ColumnOrWildcard> list) throws ParseException {
        ArrayList<ColumnImpl> columns = new ArrayList<ColumnImpl>();
        for (ColumnOrWildcard c : list) {
            String columnName;
            if (c.propertyName == null) {
                this.addWildcardColumns(columns, c.selectorName);
                continue;
            }
            String selectorName = c.selectorName;
            if (selectorName == null) {
                selectorName = this.getOnlySelectorName();
            }
            if ((columnName = c.columnName) == null) {
                columnName = c.propertyName;
            }
            columns.add(this.factory.column(selectorName, c.propertyName, columnName));
        }
        ColumnImpl[] array = new ColumnImpl[columns.size()];
        columns.toArray(array);
        return array;
    }

    private void addWildcardColumns(Collection<ColumnImpl> columns, String selectorName) throws ParseException {
        if (selectorName == null) {
            for (SelectorImpl selector : this.selectors.values()) {
                this.addWildcardColumns(columns, selector);
            }
        } else {
            SelectorImpl selector = this.selectors.get(selectorName);
            if (selector != null) {
                this.addWildcardColumns(columns, selector);
            } else {
                throw this.getSyntaxError("Unknown selector: " + selectorName);
            }
        }
    }

    private void addWildcardColumns(Collection<ColumnImpl> columns, SelectorImpl selector) {
        String selectorName = selector.getSelectorName();
        for (String propertyName : selector.getWildcardColumns()) {
            if (this.namePathMapper != null) {
                propertyName = this.namePathMapper.getJcrName(propertyName);
            }
            Object columnName = this.includeSelectorNameInWildcardColumns ? selectorName + "." + propertyName : propertyName;
            columns.add(this.factory.column(selectorName, propertyName, (String)columnName));
        }
        if (columns.isEmpty()) {
            columns.add(this.factory.column(selectorName, selectorName, selectorName));
        }
    }

    private boolean readIf(String token) throws ParseException {
        if (this.isToken(token)) {
            this.read();
            return true;
        }
        return false;
    }

    private boolean isToken(String token) {
        boolean result;
        boolean bl = result = token.equalsIgnoreCase(this.currentToken) && !this.currentTokenQuoted;
        if (result) {
            return true;
        }
        this.addExpected(token);
        return false;
    }

    private void read(String expected) throws ParseException {
        if (!expected.equalsIgnoreCase(this.currentToken) || this.currentTokenQuoted) {
            throw this.getSyntaxError(expected);
        }
        this.read();
    }

    private PropertyValue readString() throws ParseException {
        if (this.currentTokenType != 5) {
            throw this.getSyntaxError("string value");
        }
        PropertyValue value = this.currentValue;
        this.read();
        return value;
    }

    private void addExpected(String token) {
        if (this.expected != null) {
            this.expected.add(token);
        }
    }

    private void initialize(String query) throws ParseException {
        if (query == null) {
            query = "";
        }
        this.statement = query;
        int len = query.length() + 1;
        char[] command = new char[len];
        int[] types = new int[len];
        query.getChars(0, --len, command, 0);
        command[len] = 32;
        int startLoop = 0;
        for (int i = 0; i < len; ++i) {
            char c = command[i];
            int type = 0;
            block0 : switch (c) {
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case ';': 
                case '?': 
                case '{': 
                case '}': {
                    type = 5;
                    break;
                }
                case '!': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '|': {
                    type = 6;
                    break;
                }
                case '.': {
                    type = 8;
                    break;
                }
                case '/': {
                    if (command[i + 1] != '*') {
                        type = 5;
                        break;
                    }
                    type = 0;
                    types[i] = 0;
                    startLoop = i;
                    this.checkRunOver(i += 2, len, startLoop);
                    while (command[i] != '*' || command[i + 1] != '/') {
                        this.checkRunOver(++i, len, startLoop);
                    }
                    ++i;
                    break;
                }
                case '[': {
                    type = 9;
                    types[i] = 9;
                    startLoop = i;
                    while (true) {
                        if (command[++i] != ']') {
                            this.checkRunOver(i, len, startLoop);
                            continue;
                        }
                        if (i >= len - 1 || command[i + 1] != ']') break block0;
                        ++i;
                    }
                }
                case '\'': {
                    type = 7;
                    types[i] = 7;
                    startLoop = i;
                    while (command[++i] != '\'') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case '\"': {
                    type = 3;
                    types[i] = 3;
                    startLoop = i;
                    while (command[++i] != '\"') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case '_': {
                    type = 4;
                    break;
                }
                default: {
                    if (c >= 'a' && c <= 'z') {
                        type = 4;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        type = 4;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        type = 2;
                        break;
                    }
                    if (!Character.isJavaIdentifierPart(c)) break;
                    type = 4;
                }
            }
            types[i] = (byte)type;
        }
        this.statementChars = command;
        types[len] = -1;
        this.characterTypes = types;
        this.parseIndex = 0;
    }

    private void checkRunOver(int i, int len, int startLoop) throws ParseException {
        if (i >= len) {
            this.parseIndex = startLoop;
            throw this.getSyntaxError();
        }
    }

    private void read() throws ParseException {
        if (this.parseIndex >= this.characterTypes.length) {
            throw this.getSyntaxError();
        }
        this.currentTokenQuoted = false;
        if (this.expected != null) {
            this.expected.clear();
        }
        int[] types = this.characterTypes;
        int i = this.parseIndex;
        int type = types[i];
        while (type == 0) {
            type = types[++i];
        }
        int start = i;
        char[] chars = this.statementChars;
        char c = chars[i++];
        this.currentToken = "";
        switch (type) {
            case 4: {
                while (true) {
                    if ((type = types[i]) != 4 && type != 2) {
                        c = chars[i];
                        if (!this.supportSQL1 || c != ':') break;
                        ++i;
                        continue;
                    }
                    ++i;
                }
                this.currentToken = this.statement.substring(start, i);
                if (this.currentToken.isEmpty()) {
                    throw this.getSyntaxError();
                }
                this.currentTokenType = 2;
                this.parseIndex = i;
                return;
            }
            case 6: {
                if (types[i] == 6) {
                    ++i;
                }
                this.currentToken = this.statement.substring(start, i);
                this.currentTokenType = 1;
                this.parseIndex = i;
                return;
            }
            case 5: {
                this.currentToken = this.statement.substring(start, i);
                switch (c) {
                    case '$': {
                        this.currentTokenType = 3;
                        break;
                    }
                    case '+': {
                        this.currentTokenType = 13;
                        break;
                    }
                    case '-': {
                        this.currentTokenType = 12;
                        break;
                    }
                    case '(': {
                        this.currentTokenType = 14;
                        break;
                    }
                    case ')': {
                        this.currentTokenType = 15;
                        break;
                    }
                    default: {
                        this.currentTokenType = 1;
                    }
                }
                this.parseIndex = i;
                return;
            }
            case 2: {
                long number = c - 48;
                while (true) {
                    if ((c = chars[i]) < '0' || c > '9') {
                        if (c == '.') {
                            this.readDecimal(start, i);
                            break;
                        }
                        if (c == 'E' || c == 'e') {
                            this.readDecimal(start, i);
                            break;
                        }
                        this.checkLiterals(false);
                        this.currentValue = PropertyValues.newLong((Long)number);
                        this.currentTokenType = 5;
                        this.currentToken = "0";
                        this.parseIndex = i;
                        break;
                    }
                    if ((number = number * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                        this.readDecimal(start, i);
                        break;
                    }
                    ++i;
                }
                return;
            }
            case 8: {
                if (types[i] != 2) {
                    this.currentTokenType = 1;
                    this.currentToken = ".";
                    this.parseIndex = i;
                    return;
                }
                this.readDecimal(i - 1, i);
                return;
            }
            case 9: {
                this.currentTokenQuoted = true;
                this.readString(i, ']');
                this.currentTokenType = 2;
                this.currentToken = (String)this.currentValue.getValue(Type.STRING);
                return;
            }
            case 7: {
                this.currentTokenQuoted = true;
                this.readString(i, '\'');
                return;
            }
            case 3: {
                this.currentTokenQuoted = true;
                this.readString(i, '\"');
                if (this.supportSQL1) {
                    this.currentTokenType = 2;
                    this.currentToken = (String)this.currentValue.getValue(Type.STRING);
                }
                return;
            }
            case -1: {
                this.currentToken = "";
                this.currentTokenType = 4;
                this.parseIndex = i;
                return;
            }
        }
        throw this.getSyntaxError();
    }

    private void readString(int i, char end) throws ParseException {
        char[] chars = this.statementChars;
        Object result = null;
        while (true) {
            int begin = ++i;
            while (true) {
                if (chars[i] == end) {
                    if (result == null) {
                        result = this.statement.substring(begin, i);
                        break;
                    }
                    result = (String)result + this.statement.substring(begin - 1, i);
                    break;
                }
                ++i;
            }
            if (chars[++i] != end) break;
        }
        this.currentToken = "'";
        if (end != ']') {
            this.checkLiterals(false);
        }
        this.currentValue = PropertyValues.newString((String)result);
        this.parseIndex = i;
        this.currentTokenType = 5;
    }

    private void checkLiterals(boolean text) throws ParseException {
        if (LOG.isTraceEnabled() && !this.literalUsageLogged) {
            this.literalUsageLogged = true;
            LOG.trace("Literal used");
        }
        if (text && !this.allowTextLiterals || !text && !this.allowNumberLiterals) {
            throw this.getSyntaxError("bind variable (literals of this type not allowed)");
        }
    }

    private void readDecimal(int start, int i) throws ParseException {
        BigDecimal bd;
        int t;
        char[] chars = this.statementChars;
        int[] types = this.characterTypes;
        while ((t = types[i]) == 8 || t == 2) {
            ++i;
        }
        if (chars[i] == 'E' || chars[i] == 'e') {
            if (chars[++i] == '+' || chars[i] == '-') {
                ++i;
            }
            if (types[i] != 2) {
                throw this.getSyntaxError();
            }
            while (types[++i] == 2) {
            }
        }
        this.parseIndex = i;
        String sub = this.statement.substring(start, i);
        try {
            bd = new BigDecimal(sub);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Data conversion error converting " + sub + " to BigDecimal: " + e, this.parseIndex);
        }
        this.checkLiterals(false);
        this.currentValue = PropertyValues.newDecimal((BigDecimal)bd);
        this.currentTokenType = 5;
    }

    private ParseException getSyntaxError() {
        if (this.expected == null || this.expected.isEmpty()) {
            return this.getSyntaxError(null);
        }
        StringBuilder buff = new StringBuilder();
        for (String exp : this.expected) {
            if (buff.length() > 0) {
                buff.append(", ");
            }
            buff.append(exp);
        }
        return this.getSyntaxError(buff.toString());
    }

    private ParseException getSyntaxError(String expected) {
        int index = Math.max(0, Math.min(this.parseIndex, this.statement.length() - 1));
        String query = this.statement.substring(0, index) + "(*)" + this.statement.substring(index).trim();
        if (expected != null) {
            query = query + "; expected: " + expected;
        }
        return new ParseException("Query: " + query, index);
    }

    private String getOnlySelectorName() throws ParseException {
        if (this.selectors.size() > 1) {
            throw this.getSyntaxError("Need to specify the selector name because the query contains more than one selector.");
        }
        return this.selectors.values().iterator().next().getSelectorName();
    }

    public static String escapeStringLiteral(String value) {
        if (value.indexOf(39) >= 0) {
            value = value.replace("'", "''");
        }
        return "'" + value + "'";
    }

    public void setAllowTextLiterals(boolean allowTextLiterals) {
        this.allowTextLiterals = allowTextLiterals;
    }

    public void setAllowNumberLiterals(boolean allowNumberLiterals) {
        this.allowNumberLiterals = allowNumberLiterals;
    }

    public void setIncludeSelectorNameInWildcardColumns(boolean value) {
        this.includeSelectorNameInWildcardColumns = value;
    }

    public static boolean isInternal(String statement) {
        return statement.indexOf(" /* oak-internal */") >= 0;
    }

    static class ColumnOrWildcard {
        String selectorName;
        String propertyName;
        String columnName;

        ColumnOrWildcard() {
        }
    }
}

