/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.identifier;

import java.text.ParseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.QueryUtils;
import org.apache.jackrabbit.oak.commons.UUIDUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.spi.nodetype.EffectiveNodeTypeProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierManager {
    private static final Logger log = LoggerFactory.getLogger(IdentifierManager.class);
    private final Root root;
    private final EffectiveNodeTypeProvider effectiveNodeTypeProvider;

    public IdentifierManager(Root root) {
        this.root = root;
        this.effectiveNodeTypeProvider = ReadOnlyNodeTypeManager.getInstance(root, NamePathMapper.DEFAULT);
    }

    @NotNull
    public static String generateUUID() {
        return UUIDUtils.generateUUID();
    }

    @NotNull
    public static String generateUUID(String hint) {
        return UUIDUtils.generateUUID((String)hint);
    }

    public static boolean isValidUUID(String uuid) {
        return UUIDUtils.isValidUUID((String)uuid);
    }

    @NotNull
    public static String getIdentifier(Tree tree) {
        PropertyState property = tree.getProperty("jcr:uuid");
        if (property != null) {
            return (String)property.getValue(Type.STRING);
        }
        if (tree.isRoot()) {
            return "/";
        }
        String parentId = IdentifierManager.getIdentifier(tree.getParent());
        return PathUtils.concat((String)parentId, (String)tree.getName());
    }

    @Nullable
    public Tree getTree(String identifier) {
        if (identifier.startsWith("/")) {
            return this.root.getTree(identifier);
        }
        int k = identifier.indexOf(47);
        String uuid = k == -1 ? identifier : identifier.substring(0, k);
        Validate.checkArgument((boolean)UUIDUtils.isValidUUID((String)uuid), (String)("Not a valid identifier '" + identifier + "'"));
        Tree tree = this.resolveUUIDToTree(IdentifierManager.createPropertyValue(uuid));
        if (tree == null) {
            return null;
        }
        if (k == -1) {
            return tree;
        }
        Iterable subpath = PathUtils.elements((String)identifier.substring(k + 1));
        for (String element : subpath) {
            tree = tree.getChild(element);
        }
        return tree;
    }

    @Nullable
    public Tree getTree(@NotNull PropertyValue referenceValue) {
        IdentifierManager.checkType(referenceValue.getType());
        return this.resolveUUIDToTree(referenceValue);
    }

    @Nullable
    public String getPath(String identifier) {
        Tree tree = this.getTree(identifier);
        return tree != null && tree.exists() ? tree.getPath() : null;
    }

    @Nullable
    public String getPath(PropertyState referenceValue) {
        IdentifierManager.checkType(referenceValue.getType());
        return this.resolveUUID(PropertyValues.create((PropertyState)referenceValue));
    }

    @Nullable
    public String getPath(PropertyValue referenceValue) {
        IdentifierManager.checkType(referenceValue.getType());
        return this.resolveUUID(referenceValue);
    }

    @NotNull
    public Iterable<String> getReferences(boolean weak, @NotNull Tree tree, @Nullable String propertyName) {
        if (!this.effectiveNodeTypeProvider.isNodeType(tree, "mix:referenceable")) {
            return Collections.emptySet();
        }
        String uuid = IdentifierManager.getIdentifier(tree);
        String reference = weak ? "WeakReference" : "Reference";
        String pName = propertyName == null ? "*" : QueryUtils.escapeForQuery((String)propertyName);
        Map<String, PropertyValue> bindings = Collections.singletonMap("uuid", PropertyValues.newString((String)uuid));
        try {
            Result result = this.root.getQueryEngine().executeQuery("SELECT * FROM [nt:base] WHERE PROPERTY([" + pName + "], '" + reference + "') = $uuid /* oak-internal */", "JCR-SQL2", bindings, QueryEngine.NO_MAPPINGS);
            return this.findPaths(result, uuid, propertyName, weak);
        }
        catch (ParseException e) {
            log.error("query failed", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @NotNull
    private Iterable<String> findPaths(final @NotNull Result result, final @NotNull String uuid, final @Nullable String propertyName, final boolean weak) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return IteratorUtils.chainedIterator((Iterator)IteratorUtils.transform(result.getRows().iterator(), new RowToPaths()::apply));
            }

            class RowToPaths
            implements Function<ResultRow, Iterator<String>> {
                RowToPaths() {
                }

                @Override
                public Iterator<String> apply(ResultRow row) {
                    final String rowPath = row.getPath();
                    if (!rowPath.startsWith("/jcr:system/jcr:versionStorage")) {
                        if (propertyName == null) {
                            class PropertyToPath
                            implements Function<PropertyState, String> {
                                PropertyToPath() {
                                }

                                @Override
                                public String apply(PropertyState pState) {
                                    if (pState.isArray()) {
                                        Type types;
                                        Type type = types = weak ? Type.WEAKREFERENCES : Type.REFERENCES;
                                        if (pState.getType() == types) {
                                            for (String value : (Iterable)pState.getValue(Type.STRINGS)) {
                                                if (!uuid.equals(value)) continue;
                                                return PathUtils.concat((String)rowPath, (String)pState.getName());
                                            }
                                        }
                                    } else {
                                        Type type;
                                        Type type2 = type = weak ? Type.WEAKREFERENCE : Type.REFERENCE;
                                        if (pState.getType() == type && uuid.equals(pState.getValue(Type.STRING))) {
                                            return PathUtils.concat((String)rowPath, (String)pState.getName());
                                        }
                                    }
                                    return null;
                                }
                            }
                            return IteratorUtils.filter((Iterator)IteratorUtils.transform(IdentifierManager.this.root.getTree(rowPath).getProperties().iterator(), new PropertyToPath()::apply), x -> x != null);
                        }
                        return Collections.singleton(PathUtils.concat((String)rowPath, (String)propertyName)).iterator();
                    }
                    return Collections.emptyIterator();
                }
            }
        };
    }

    @NotNull
    public Iterable<Tree> getReferences(@NotNull Tree tree, @NotNull String propertyName, @NotNull String ntName, boolean weak) {
        if (!this.effectiveNodeTypeProvider.isNodeType(tree, "mix:referenceable")) {
            return Collections.emptySet();
        }
        String uuid = IdentifierManager.getIdentifier(tree);
        String reference = weak ? "WeakReference" : "Reference";
        Map<String, PropertyValue> bindings = Collections.singletonMap("uuid", PropertyValues.newString((String)uuid));
        try {
            String escapedPropName = QueryUtils.escapeForQuery((String)propertyName);
            Result result = this.root.getQueryEngine().executeQuery("SELECT * FROM [" + ntName + "] WHERE PROPERTY([" + escapedPropName + "], '" + reference + "') = $uuid /* oak-internal */", "JCR-SQL2", bindings, QueryEngine.NO_MAPPINGS);
            Iterable resultTrees = IterableUtils.transform((Iterable)result.getRows(), row -> row.getTree(null));
            return IterableUtils.filter((Iterable)resultTrees, tree1 -> !tree1.getPath().startsWith("/jcr:system/jcr:versionStorage"));
        }
        catch (ParseException e) {
            log.error("query failed", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Nullable
    public String resolveUUID(String uuid) {
        return this.resolveUUID(IdentifierManager.createPropertyValue(uuid));
    }

    @Nullable
    private String resolveUUID(@NotNull PropertyValue uuid) {
        Tree tree = this.resolveUUIDToTree(uuid);
        return tree == null ? null : tree.getPath();
    }

    @Nullable
    private Tree resolveUUIDToTree(@NotNull PropertyValue uuid) {
        try {
            Map<String, PropertyValue> bindings = Collections.singletonMap("id", uuid);
            Result result = this.root.getQueryEngine().executeQuery("SELECT * FROM [nt:base] WHERE [jcr:uuid] = $id OPTION(INDEX NAME [uuid], INDEX TAG [uuid]) /* oak-internal */", "JCR-SQL2", bindings, QueryEngine.NO_MAPPINGS);
            Tree tree = null;
            for (ResultRow rr : result.getRows()) {
                if (tree != null) {
                    log.error("multiple results for identifier lookup: " + tree.getPath() + " vs. " + rr.getPath());
                    return null;
                }
                tree = rr.getTree(null);
            }
            return tree;
        }
        catch (ParseException ex) {
            log.error("query failed", (Throwable)ex);
            return null;
        }
    }

    @NotNull
    private static PropertyValue createPropertyValue(@NotNull String uuid) {
        return PropertyValues.create((PropertyState)StringPropertyState.stringProperty((String)"", (String)uuid));
    }

    private static void checkType(@NotNull Type propertyType) {
        int type = propertyType.tag();
        if (type != 9 && type != 10) {
            throw new IllegalArgumentException("Invalid value type");
        }
    }
}

