/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contact.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contact.info.InfoDAO;
import org.silverpeas.core.contact.model.CompleteContact;
import org.silverpeas.core.contact.model.Contact;
import org.silverpeas.core.contact.model.ContactDetail;
import org.silverpeas.core.contact.model.ContactFatherDetail;
import org.silverpeas.core.contact.model.ContactPK;
import org.silverpeas.core.contact.model.ContactRuntimeException;
import org.silverpeas.core.contact.service.ContactDAO;
import org.silverpeas.core.contact.service.ContactService;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultContactService
implements ContactService,
ComponentInstanceDeletion {
    @Inject
    private InfoDAO infoDAO;
    @Inject
    private ContactDAO contactDAO;

    @Override
    public ContactDetail getDetail(ContactPK contactPK) {
        Connection con = this.getConnection();
        try {
            ContactPK primary = this.contactDAO.selectByPrimaryKey(con, contactPK);
            if (primary != null) {
                ContactDetail contactDetail = primary.getContactDetail();
                return contactDetail;
            }
            try {
                throw new ContactRuntimeException("Contact not found with id = " + contactPK.getId());
            }
            catch (SQLException | ParseException re) {
                throw new ContactRuntimeException(re);
            }
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public ContactPK createContact(Contact contact) {
        Connection con = this.getConnection();
        try {
            CompleteContact fullContact;
            int id = DBUtil.getNextId((String)contact.getPK().getTableName(), (String)"contactId");
            contact.getPK().setId(String.valueOf(id));
            this.contactDAO.insertRow(con, contact);
            if (contact instanceof CompleteContact && (fullContact = (CompleteContact)contact).isFormDefined()) {
                fullContact.saveForm();
                this.createInfoModel(contact.getPK(), fullContact.getModelId());
            }
            this.createIndex(contact);
            ContactPK contactPK = contact.getPK();
            return contactPK;
        }
        catch (Exception e) {
            throw new ContactRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeContact(ContactPK contactPK) {
        Connection con = this.getConnection();
        try {
            List<String> modelIds = this.infoDAO.getInfo(con, contactPK);
            for (String modelId : modelIds) {
                CompleteContact completeContact = this.getCompleteContact(contactPK, modelId);
                completeContact.removeForm();
            }
            this.infoDAO.deleteInfoDetailByContactPK(con, contactPK);
            this.contactDAO.deleteContact(con, contactPK);
            this.deleteIndex(contactPK);
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void setDetail(Contact contact) {
        Connection con = this.getConnection();
        try {
            this.contactDAO.storeRow(con, contact);
            if (contact instanceof CompleteContact) {
                CompleteContact fullContact = (CompleteContact)contact;
                fullContact.saveForm();
            }
            this.createIndex(contact);
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void addFather(ContactPK contactPK, NodePK fatherPK) {
        Connection con = this.getConnection();
        try {
            this.contactDAO.addFather(con, contactPK, fatherPK);
        }
        catch (SQLException re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeFather(ContactPK contactPK, NodePK fatherPK) {
        Connection con = this.getConnection();
        try {
            this.contactDAO.removeFather(con, contactPK, fatherPK);
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeAllFather(ContactPK contactPK) {
        Connection con = this.getConnection();
        try {
            this.contactDAO.removeAllFather(con, contactPK);
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeAllIssue(NodePK originPK, ContactPK contactPK) {
        Connection con = this.getConnection();
        try {
            this.contactDAO.removeAllIssue(con, originPK, contactPK);
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ContactDetail> getOrphanContacts(ContactPK contactPK) {
        Connection con = this.getConnection();
        try {
            Collection<ContactDetail> collection = this.contactDAO.getOrphanContacts(con, contactPK);
            return collection;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteOrphanContactsByCreatorId(ContactPK contactPK, String creatorId) {
        Connection con = this.getConnection();
        try {
            this.contactDAO.deleteOrphanContactsByCreatorId(con, contactPK, creatorId);
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ContactDetail> getUnavailableContactsByPublisherId(ContactPK contactPK, String publisherId, String nodeId) {
        Connection con = this.getConnection();
        try {
            Collection<ContactDetail> collection = this.contactDAO.getUnavailableContactsByPublisherId(con, contactPK, publisherId, nodeId);
            return collection;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<NodePK> getAllFatherPK(ContactPK contactPK) {
        Connection con = this.getConnection();
        try {
            Collection<NodePK> collection = this.contactDAO.getAllFatherPK(con, contactPK);
            return collection;
        }
        catch (SQLException re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ContactDetail> getDetailsByFatherPK(NodePK fatherPK) {
        Connection con = this.getConnection();
        try {
            Collection<ContactDetail> collection = this.contactDAO.selectByFatherPK(con, fatherPK);
            return collection;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ContactDetail> getDetailsByLastName(ContactPK pk, String query) {
        Connection con = this.getConnection();
        try {
            Collection<ContactDetail> collection = this.contactDAO.selectByLastName(con, pk, query);
            return collection;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ContactDetail> getDetailsByLastNameOrFirstName(ContactPK pk, String query) {
        Connection con = this.getConnection();
        try {
            Collection<ContactDetail> collection = this.contactDAO.selectByLastNameOrFirstName(con, pk, query);
            return collection;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ContactDetail> getDetailsByLastNameAndFirstName(ContactPK pk, String lastName, String firstName) {
        Connection con = this.getConnection();
        try {
            Collection<ContactDetail> collection = this.contactDAO.selectByLastNameAndFirstName(con, pk, lastName, firstName);
            return collection;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void createInfoModel(ContactPK contactPK, String modelId) {
        Connection con = this.getConnection();
        try {
            this.infoDAO.createInfo(con, modelId, contactPK);
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public CompleteContact getCompleteContact(ContactPK contactPK, String modelId) {
        try {
            ContactDetail contact = this.getDetail(contactPK);
            return new CompleteContact(contact, modelId);
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
    }

    @Override
    public CompleteContact getCompleteContact(ContactPK contactPK) {
        Connection con = this.getConnection();
        try {
            ContactDetail contact = this.getDetail(contactPK);
            List<String> modelIds = this.infoDAO.getInfo(con, contactPK);
            String modelId = null;
            if (modelIds != null && !modelIds.isEmpty()) {
                modelId = modelIds.get(0);
            }
            CompleteContact completeContact = new CompleteContact(contact, modelId);
            return completeContact;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ContactDetail> getContacts(Collection<ContactPK> contactPKs) {
        Connection con = this.getConnection();
        try {
            Collection<ContactDetail> collection = this.contactDAO.selectByContactPKs(con, contactPKs);
            return collection;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public int getNbPubInFatherPKs(Collection<NodePK> fatherPKs) {
        Connection con = this.getConnection();
        try {
            int n = this.contactDAO.getNbPubInFatherPKs(con, fatherPKs);
            return n;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ContactFatherDetail> getDetailsByFatherPKs(Collection<NodePK> fatherPKs, ContactPK contactPK, NodePK nodePK) {
        Connection con = this.getConnection();
        try {
            Collection<ContactFatherDetail> collection = this.contactDAO.selectByFatherPKs(con, fatherPKs, contactPK, nodePK);
            return collection;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public int getNbPubByFatherPath(NodePK fatherPK, String fatherPath) {
        Connection con = this.getConnection();
        try {
            int n = this.contactDAO.getNbPubByFatherPath(con, fatherPK, fatherPath);
            return n;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<CompleteContact> getVisibleContacts(String instanceId) {
        Connection con = this.getConnection();
        try {
            List<CompleteContact> list = this.contactDAO.getVisibleContacts(con, instanceId);
            return list;
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (SQLException re) {
            throw new ContactRuntimeException(re);
        }
    }

    @Override
    public void index(ContactPK contactPK) {
        CompleteContact contact = this.getCompleteContact(contactPK);
        this.createIndex(contact);
    }

    private void createIndex(Contact contact) {
        try {
            if (contact != null) {
                FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(contact.getPK().getComponentName(), "Contact", contact.getPK().getId()));
                String fullName = contact.getFirstName() + " " + contact.getLastName();
                indexEntry.setTitle(fullName);
                indexEntry.setLang(I18NHelper.DEFAULT_LANGUAGE);
                indexEntry.setCreationDate(contact.getCreationDate());
                indexEntry.setCreationUser(contact.getCreatorId());
                indexEntry.addTextContent(contact.getPhone());
                indexEntry.addTextContent(contact.getEmail());
                indexEntry.addTextContent(StringUtil.normalizeByRemovingAccent((String)fullName));
                if (contact instanceof CompleteContact) {
                    CompleteContact completeContact = (CompleteContact)contact;
                    completeContact.indexForm(indexEntry);
                }
                IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
            }
        }
        catch (Exception re) {
            throw new ContactRuntimeException(re);
        }
    }

    @Override
    public void deleteIndex(ContactPK contactPK) {
        IndexEntryKey indexEntry = new IndexEntryKey(contactPK.getComponentName(), "Contact", contactPK.getId());
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
    }

    @Transactional
    public void delete(String componentInstanceId) {
        try (Connection connection = DBUtil.openConnection();){
            this.contactDAO.deleteAllContacts(connection, componentInstanceId);
            this.infoDAO.deleteAllInfoByInstanceId(connection, componentInstanceId);
        }
        catch (SQLException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

