/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jackrabbit.oak.commons.LongUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RDBJSONSupport {
    private final boolean useRevisionMaps;

    public RDBJSONSupport(boolean useRevisionMaps) {
        this.useRevisionMaps = useRevisionMaps;
    }

    @Nullable
    public Object parse(@NotNull String json) {
        return this.parse(new JsopTokenizer(json));
    }

    @Nullable
    public Object parse(@NotNull JsopTokenizer json) {
        switch (json.read()) {
            case 5: {
                return null;
            }
            case 3: {
                return Boolean.TRUE;
            }
            case 4: {
                return Boolean.FALSE;
            }
            case 2: {
                String t = json.getToken();
                Long parsed = LongUtils.tryParse((String)t);
                if (parsed != null) {
                    return parsed;
                }
                return Double.parseDouble(t);
            }
            case 1: {
                return json.getToken();
            }
            case 123: {
                if (this.useRevisionMaps) {
                    TreeMap<Revision, Object> map = new TreeMap<Revision, Object>(StableRevisionComparator.REVERSE);
                    while (!json.matches(125)) {
                        String k = json.readString();
                        if (k == null) {
                            throw new IllegalArgumentException("unexpected null revision");
                        }
                        json.read(58);
                        map.put(Revision.fromString(k), this.parse(json));
                        json.matches(44);
                    }
                    return map;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                while (!json.matches(125)) {
                    String k = json.readString();
                    if (k == null) {
                        throw new IllegalArgumentException("unexpected null key");
                    }
                    json.read(58);
                    map.put(k, this.parse(json));
                    json.matches(44);
                }
                return map;
            }
            case 91: {
                ArrayList<Object> list = new ArrayList<Object>();
                while (!json.matches(93)) {
                    list.add(this.parse(json));
                    json.matches(44);
                }
                return list;
            }
        }
        throw new IllegalArgumentException(json.readRawValue());
    }

    public static void appendJsonMember(StringBuilder sb, String key, Object value) {
        RDBJSONSupport.appendJsonString(sb, key);
        sb.append(":");
        RDBJSONSupport.appendJsonValue(sb, value);
    }

    public static void appendJsonString(StringBuilder sb, String s) {
        sb.append('\"');
        JsopBuilder.escape((String)s, (StringBuilder)sb);
        sb.append('\"');
    }

    public static void appendJsonMap(StringBuilder sb, Map<Object, Object> map) {
        sb.append("{");
        boolean needComma = false;
        for (Map.Entry<Object, Object> e : map.entrySet()) {
            if (needComma) {
                sb.append(",");
            }
            RDBJSONSupport.appendJsonMember(sb, e.getKey().toString(), e.getValue());
            needComma = true;
        }
        sb.append("}");
    }

    public static void appendJsonValue(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof Number) {
            sb.append(value.toString());
        } else if (value instanceof Boolean) {
            sb.append(value.toString());
        } else if (value instanceof String) {
            RDBJSONSupport.appendJsonString(sb, (String)value);
        } else if (value instanceof Map) {
            RDBJSONSupport.appendJsonMap(sb, (Map)value);
        } else {
            throw new IllegalArgumentException("unexpected type: " + value.getClass());
        }
    }
}

