/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.List;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.ThrottlingStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.util.CreateMetricUpdater;
import org.apache.jackrabbit.oak.plugins.document.util.ModifyMetricUpdater;
import org.apache.jackrabbit.oak.plugins.document.util.RemoveMetricUpdater;
import org.apache.jackrabbit.oak.plugins.document.util.StatsCollectorUtil;
import org.apache.jackrabbit.oak.plugins.document.util.UpsertMetricUpdater;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlingStatsCollectorImpl
implements ThrottlingStatsCollector {
    private final Logger perfLog = LoggerFactory.getLogger((String)(ThrottlingStatsCollectorImpl.class.getName() + ".perf"));
    public static final int PERF_LOG_THRESHOLD = 1;
    static final String NODES_CREATE_SPLIT_THROTTLING = "DOCUMENT_NODES_CREATE_SPLIT_THROTTLING";
    static final String NODES_UPDATE_FAILURE_THROTTLING = "DOCUMENT_NODES_UPDATE_FAILURE_THROTTLING";
    static final String NODES_UPDATE_RETRY_COUNT_THROTTLING = "DOCUMENT_NODES_UPDATE_RETRY_THROTTLING";
    static final String NODES_CREATE_UPSERT_THROTTLING = "DOCUMENT_NODES_CREATE_UPSERT_THROTTLING";
    static final String NODES_CREATE_UPSERT_THROTTLING_TIMER = "DOCUMENT_NODES_CREATE_UPSERT_THROTTLING_TIMER";
    static final String NODES_CREATE_THROTTLING = "DOCUMENT_NODES_CREATE_THROTTLING";
    static final String NODES_CREATE_THROTTLING_TIMER = "DOCUMENT_NODES_CREATE_THROTTLING_TIMER";
    static final String NODES_UPDATE_THROTTLING = "DOCUMENT_NODES_UPDATE_THROTTLING";
    static final String NODES_UPDATE_THROTTLING_TIMER = "DOCUMENT_NODES_UPDATE_THROTTLING_TIMER";
    static final String NODES_REMOVE_THROTTLING = "DOCUMENT_NODES_REMOVE_THROTTLING";
    static final String NODES_REMOVE_THROTTLING_TIMER = "DOCUMENT_NODES_REMOVE_THROTTLING_TIMER";
    static final String JOURNAL_CREATE_THROTTLING = "DOCUMENT_JOURNAL_CREATE_THROTTLING";
    static final String JOURNAL_CREATE_THROTTLING_TIMER = "DOCUMENT_JOURNAL_CREATE_THROTTLING_TIMER";
    private final RemoveMetricUpdater removeMetricUpdater;
    private final CreateMetricUpdater createMetricUpdater;
    private final UpsertMetricUpdater upsertMetricUpdater;
    private final ModifyMetricUpdater modifyMetricUpdater;

    public ThrottlingStatsCollectorImpl(StatisticsProvider provider) {
        MeterStats createSplitNodeThrottlingMeter = provider.getMeter(NODES_CREATE_SPLIT_THROTTLING, StatsOptions.DEFAULT);
        MeterStats updateNodeFailureThrottlingMeter = provider.getMeter(NODES_UPDATE_FAILURE_THROTTLING, StatsOptions.DEFAULT);
        MeterStats updateNodeRetryCountThrottlingMeter = provider.getMeter(NODES_UPDATE_RETRY_COUNT_THROTTLING, StatsOptions.DEFAULT);
        MeterStats createNodeThrottlingMeter = provider.getMeter(NODES_CREATE_THROTTLING, StatsOptions.DEFAULT);
        TimerStats createNodeThrottlingTimer = provider.getTimer(NODES_CREATE_THROTTLING_TIMER, StatsOptions.METRICS_ONLY);
        MeterStats createNodeUpsertThrottlingMeter = provider.getMeter(NODES_CREATE_UPSERT_THROTTLING, StatsOptions.DEFAULT);
        TimerStats createNodeUpsertThrottlingTimer = provider.getTimer(NODES_CREATE_UPSERT_THROTTLING_TIMER, StatsOptions.METRICS_ONLY);
        MeterStats updateNodeThrottlingMeter = provider.getMeter(NODES_UPDATE_THROTTLING, StatsOptions.DEFAULT);
        TimerStats updateNodeThrottlingTimer = provider.getTimer(NODES_UPDATE_THROTTLING_TIMER, StatsOptions.METRICS_ONLY);
        MeterStats createJournalThrottling = provider.getMeter(JOURNAL_CREATE_THROTTLING, StatsOptions.DEFAULT);
        TimerStats createJournalThrottlingTimer = provider.getTimer(JOURNAL_CREATE_THROTTLING_TIMER, StatsOptions.METRICS_ONLY);
        MeterStats removeNodesThrottling = provider.getMeter(NODES_REMOVE_THROTTLING, StatsOptions.DEFAULT);
        TimerStats removeNodesThrottlingTimer = provider.getTimer(NODES_REMOVE_THROTTLING_TIMER, StatsOptions.METRICS_ONLY);
        this.removeMetricUpdater = new RemoveMetricUpdater(removeNodesThrottling, removeNodesThrottlingTimer);
        this.createMetricUpdater = new CreateMetricUpdater(createNodeThrottlingMeter, createSplitNodeThrottlingMeter, createNodeThrottlingTimer, createJournalThrottling, createJournalThrottlingTimer);
        this.upsertMetricUpdater = new UpsertMetricUpdater(createNodeUpsertThrottlingMeter, createSplitNodeThrottlingMeter, createNodeUpsertThrottlingTimer);
        this.modifyMetricUpdater = new ModifyMetricUpdater(createNodeUpsertThrottlingMeter, createNodeUpsertThrottlingTimer, updateNodeThrottlingMeter, updateNodeThrottlingTimer, updateNodeRetryCountThrottlingMeter, updateNodeFailureThrottlingMeter);
    }

    @Override
    public void doneCreate(long throttlingTimeNanos, Collection<? extends Document> collection, List<String> ids, boolean insertSuccess) {
        this.createMetricUpdater.update(collection, throttlingTimeNanos, ids, insertSuccess, StatsCollectorUtil.isNodesCollectionUpdated(), StatsCollectorUtil.getCreateStatsConsumer(), c -> c == Collection.JOURNAL, StatsCollectorUtil.getJournalStatsConsumer());
        StatsCollectorUtil.perfLog(this.perfLog, 1, throttlingTimeNanos, "create", new Object[0]);
    }

    @Override
    public void doneCreateOrUpdate(long throttlingTimeNanos, Collection<? extends Document> collection, List<String> ids) {
        this.upsertMetricUpdater.update(collection, throttlingTimeNanos, ids, StatsCollectorUtil.isNodesCollectionUpdated(), StatsCollectorUtil.getCreateStatsConsumer());
        StatsCollectorUtil.perfLog(this.perfLog, 1, throttlingTimeNanos, "createOrUpdate {}", ids);
    }

    @Override
    public void doneFindAndModify(long throttlingTimeNanos, Collection<? extends Document> collection, String key, boolean newEntry, boolean success, int retryCount) {
        this.modifyMetricUpdater.update(collection, retryCount, throttlingTimeNanos, success, newEntry, List.of(key), StatsCollectorUtil.isNodesCollectionUpdated(), StatsCollectorUtil.getStatsConsumer(), StatsCollectorUtil.getStatsConsumer(), MeterStats::mark, MeterStats::mark);
        StatsCollectorUtil.perfLog(this.perfLog, 1, throttlingTimeNanos, "findAndModify [{}]", key);
    }

    @Override
    public void doneFindAndModify(long throttlingTimeNanos, Collection<? extends Document> collection, List<String> ids, boolean success, int retryCount) {
        this.modifyMetricUpdater.update(collection, retryCount, throttlingTimeNanos, success, false, ids, StatsCollectorUtil.isNodesCollectionUpdated(), StatsCollectorUtil.getStatsConsumer(), StatsCollectorUtil.getStatsConsumer(), MeterStats::mark, MeterStats::mark);
        StatsCollectorUtil.perfLog(this.perfLog, 1, throttlingTimeNanos, "findAndModify {}", ids);
    }

    @Override
    public void doneRemove(long throttlingTimeNanos, Collection<? extends Document> collection) {
        this.removeMetricUpdater.update(collection, 1, throttlingTimeNanos, StatsCollectorUtil.isNodesCollectionUpdated(), StatsCollectorUtil.getStatsConsumer());
        StatsCollectorUtil.perfLog(this.perfLog, 1, throttlingTimeNanos, "remove [{}]", 1);
    }
}

