/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.BlobCollector;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class BlobReferenceIterator
extends AbstractIterator<ReferencedBlob>
implements Closeable {
    private final DocumentStore documentStore;
    private final BlobCollector blobCollector;
    private final Queue<ReferencedBlob> blobs = new ArrayDeque<ReferencedBlob>();
    private Iterator<NodeDocument> iterator;

    public BlobReferenceIterator(DocumentNodeStore nodeStore) {
        this.documentStore = nodeStore.getDocumentStore();
        this.blobCollector = new BlobCollector(nodeStore);
    }

    protected ReferencedBlob computeNext() {
        if (this.blobs.isEmpty()) {
            this.loadBatch();
        }
        if (!this.blobs.isEmpty()) {
            return this.blobs.remove();
        }
        return (ReferencedBlob)this.endOfData();
    }

    private void loadBatch() {
        if (this.iterator == null) {
            this.iterator = this.getIteratorOverDocsWithBinaries();
        }
        while (this.iterator.hasNext() && this.blobs.isEmpty()) {
            this.collectBinaries(this.iterator.next());
        }
    }

    private void collectBinaries(NodeDocument nodeDocument) {
        this.blobCollector.collect(nodeDocument, this.blobs);
    }

    public Iterator<NodeDocument> getIteratorOverDocsWithBinaries() {
        int batchSize = 1000;
        return Utils.getSelectedDocuments(this.documentStore, "_bin", 1L, batchSize).iterator();
    }

    @Override
    public void close() {
        Utils.closeIfCloseable(this.iterator);
    }
}

