/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply.service.notification;

import org.owasp.encoder.Encode;
import org.silverpeas.components.questionreply.model.Question;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;

abstract class AbstractNotifier
extends AbstractTemplateUserNotificationBuilder<Question> {
    private final User sender;

    AbstractNotifier(Question question, User sender) {
        super((Object)question);
        this.sender = sender;
    }

    protected void performTemplateData(String language, Question question, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getTitle(language), "");
        template.setAttribute("UserDetail", (Object)this.sender);
        template.setAttribute("userName", (Object)this.sender.getDisplayedName());
        template.setAttribute("QuestionDetail", (Object)question);
        template.setAttribute("questionTitle", (Object)Encode.forHtml((String)question.getTitle()));
        template.setAttribute("questionContent", (Object)Encode.forHtml((String)question.getContent()));
        template.setAttribute("silverpeasURL", (Object)this.getResourceURL(question));
    }

    protected String getResourceURL(Question question) {
        return question.getPermalink();
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.questionReply.multilang.questionReplyBundle";
    }

    protected String getBundleSubjectKey() {
        return "questionReply.notification";
    }

    protected String getTitle(String language) {
        return (super.getTitle(language) + " " + this.getComponentInstanceTitle(language)).trim();
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "questionReply.notifLinkLabel";
    }

    protected String getTemplatePath() {
        return "question-reply";
    }

    protected NotifAction getAction() {
        return NotifAction.REPORT;
    }

    protected String getSender() {
        return this.sender.getId();
    }

    protected boolean isSendImmediately() {
        return true;
    }

    protected String getComponentInstanceId() {
        return ((Question)((Object)this.getResource())).getInstanceId();
    }

    private String getComponentInstanceTitle(String language) {
        return SilverpeasComponentInstance.getById((String)this.getComponentInstanceId()).map(i -> i.getLabel(language)).orElse("");
    }

    protected void performNotificationResource(String language, Question resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getTitle());
    }
}

