/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.blob.AbstractSharedCachingDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.AbstractDataStoreService;
import org.apache.jackrabbit.oak.plugins.blob.datastore.CachingFileDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.OakFileDataStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, name="org.apache.jackrabbit.oak.plugins.blob.datastore.FileDataStore")
public class FileDataStoreService
extends AbstractDataStoreService {
    public static final String NAME = "org.apache.jackrabbit.oak.plugins.blob.datastore.FileDataStore";
    private static final String DESCRIPTION = "oak.datastore.description";
    public static final String CACHE_PATH = "cachePath";
    public static final String CACHE_SIZE = "cacheSize";
    public static final String FS_BACKEND_PATH = "fsBackendPath";
    public static final String PATH = "path";
    private ServiceRegistration delegateReg;
    @Reference
    private StatisticsProvider statisticsProvider;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected DataStore createDataStore(ComponentContext context, Map<String, Object> config) {
        long cacheSize = PropertiesUtil.toLong((Object)config.get(CACHE_SIZE), (long)0L);
        if (cacheSize > 0L) {
            String fsBackendPath = PropertiesUtil.toString((Object)config.get(PATH), null);
            Objects.requireNonNull(fsBackendPath, "Cannot create FileDataStoreService with caching. [{path}] property not configured.");
            config.remove(PATH);
            config.remove(CACHE_SIZE);
            config.put(FS_BACKEND_PATH, fsBackendPath);
            config.put(CACHE_SIZE, cacheSize);
            String cachePath = PropertiesUtil.toString((Object)config.get(CACHE_PATH), null);
            if (cachePath != null) {
                config.remove(CACHE_PATH);
                config.put(PATH, cachePath);
            }
            Properties properties = new Properties();
            properties.putAll(config);
            this.log.info("Initializing with properties " + properties);
            return this.getCachingDataStore(properties, context);
        }
        this.log.info("OakFileDataStore initialized");
        return new OakFileDataStore();
    }

    private DataStore getCachingDataStore(Properties props, ComponentContext context) {
        CachingFileDataStore dataStore = new CachingFileDataStore();
        dataStore.setStagingSplitPercentage(PropertiesUtil.toInteger((Object)props.get("stagingSplitPercentage"), (int)0));
        dataStore.setProperties(props);
        Hashtable<String, Object> config = new Hashtable<String, Object>();
        ((Dictionary)config).put("service.pid", dataStore.getClass().getName());
        ((Dictionary)config).put(DESCRIPTION, this.getDescription());
        this.delegateReg = context.getBundleContext().registerService(new String[]{AbstractSharedCachingDataStore.class.getName(), AbstractSharedCachingDataStore.class.getName()}, (Object)dataStore, config);
        return dataStore;
    }

    @Override
    protected StatisticsProvider getStatisticsProvider() {
        return this.statisticsProvider;
    }

    @Override
    protected void setStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    @Override
    protected String[] getDescription() {
        return new String[]{"type=filesystem"};
    }
}

