/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.control;

import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class ImportSettings
implements Cloneable {
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.importExport.settings.importSettings");
    public static final int FROM_XML = 0;
    public static final int FROM_DRAGNDROP = 1;
    public static final int FROM_MANUAL = 2;
    private String pathToImport;
    private final UserDetail user;
    private final String componentId;
    private String folderId;
    private final boolean draftUsed;
    private final boolean poiUsed;
    private boolean versioningUsed;
    private int versionType;
    private String versionComment;
    private int method;
    private String contentLanguage;
    private String targetValidatorIds;
    private final PublicationDetail publicationForAllFiles = PublicationDetail.builder().build();
    private String singleFileTitle;
    private String singleFileDescription;
    private final boolean useFileMetadata = AttachmentSettings.isUseFileMetadataForAttachmentDataEnabled();
    private boolean fromDocumentTemplate;

    public ImportSettings(String pathToImport, UserDetail user, String componentId, String folderId, boolean draftUsed, boolean poiUsed, int method) {
        this.pathToImport = pathToImport;
        this.user = user;
        this.componentId = componentId;
        this.folderId = folderId;
        this.draftUsed = draftUsed;
        this.poiUsed = poiUsed;
        this.method = method;
    }

    public String getPathToImport() {
        return this.pathToImport;
    }

    public void setPathToImport(String path) {
        this.pathToImport = path;
    }

    public UserDetail getUser() {
        return this.user;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public boolean isDraftUsed() {
        return this.draftUsed;
    }

    public boolean isPoiUsed() {
        if (this.isFromDocumentTemplate()) {
            return false;
        }
        if (this.getMethod() == 0) {
            return this.poiUsed;
        }
        if (this.getMethod() == 1) {
            return settings.getBoolean("dnd.publication.usePOI", true);
        }
        return settings.getBoolean("manual.publication.usePOI", true);
    }

    public void setVersioningUsed(boolean versioningUsed) {
        this.versioningUsed = versioningUsed;
    }

    public boolean isVersioningUsed() {
        return this.versioningUsed;
    }

    public void setFrom(int from) {
        this.method = from;
    }

    public int getMethod() {
        return this.method;
    }

    public boolean isPublicationMergeEnabled() {
        if (this.isFromDocumentTemplate()) {
            return false;
        }
        if (this.getMethod() == 0) {
            return settings.getBoolean("xml.publication.merge", true);
        }
        if (this.getMethod() == 1) {
            return settings.getBoolean("dnd.publication.merge", false);
        }
        return settings.getBoolean("manual.publication.merge", false);
    }

    public boolean mustCreateOnePublicationForAllFiles() {
        return StringUtil.isDefined((String)this.publicationForAllFiles.getName());
    }

    public PublicationDetail getPublicationForAllFiles() {
        return this.publicationForAllFiles;
    }

    public String getPublicationName(String filename) {
        if (settings.getBoolean("publication.name.with.extension", false)) {
            return filename;
        }
        return FilenameUtils.getBaseName((String)filename);
    }

    public void setVersionType(int versionType) {
        this.versionType = versionType;
    }

    public void setVersionAndComment(int versionType, String comment) {
        this.versionType = versionType;
        this.versionComment = comment;
    }

    public int getVersionType() {
        return this.versionType;
    }

    public String getVersionComment() {
        return this.versionComment;
    }

    public String getSingleFileTitle() {
        return this.singleFileTitle;
    }

    public void setSingleFileTitle(String singleFileTitle) {
        this.singleFileTitle = singleFileTitle;
    }

    public String getSingleFileDescription() {
        return this.singleFileDescription;
    }

    public void setSingleFileDescription(String singleFileDescription) {
        this.singleFileDescription = singleFileDescription;
    }

    public boolean isUseFileMetadata() {
        return !this.isFromDocumentTemplate() && this.useFileMetadata;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public void setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
    }

    public String getTargetValidatorIds() {
        return this.targetValidatorIds;
    }

    public void setTargetValidatorIds(String targetValidatorIds) {
        this.targetValidatorIds = targetValidatorIds;
    }

    public boolean isFromDocumentTemplate() {
        return this.fromDocumentTemplate;
    }

    public void setFromDocumentTemplate(boolean fromDocumentTemplate) {
        this.fromDocumentTemplate = fromDocumentTemplate;
    }

    public boolean useFileDates() {
        if (this.isFromDocumentTemplate()) {
            return false;
        }
        if (this.getMethod() == 0) {
            return settings.getBoolean("xml.publication.useFileDates", false);
        }
        if (this.getMethod() == 1) {
            return settings.getBoolean("dnd.publication.useFileDates", false);
        }
        return settings.getBoolean("manual.publication.useFileDates", false);
    }

    public ImportSettings clone() {
        try {
            return (ImportSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }
}

