/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.GenericTypeResolver;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactoryRegistry
implements ConnectionFactoryLocator {
    private final Map<String, ConnectionFactory<?>> connectionFactories = new HashMap();
    private final Map<Class<?>, String> apiTypeIndex = new HashMap();

    public void addConnectionFactory(ConnectionFactory<?> connectionFactory) {
        if (this.connectionFactories.containsKey(connectionFactory.getProviderId())) {
            throw new IllegalArgumentException("A ConnectionFactory for provider '" + connectionFactory.getProviderId() + "' has already been registered");
        }
        Class apiType = GenericTypeResolver.resolveTypeArgument(connectionFactory.getClass(), ConnectionFactory.class);
        if (this.apiTypeIndex.containsKey(apiType)) {
            throw new IllegalArgumentException("A ConnectionFactory for API [" + apiType.getName() + "] has already been registered");
        }
        this.connectionFactories.put(connectionFactory.getProviderId(), connectionFactory);
        this.apiTypeIndex.put(apiType, connectionFactory.getProviderId());
    }

    public void setConnectionFactories(List<ConnectionFactory<?>> connectionFactories) {
        for (ConnectionFactory<?> connectionFactory : connectionFactories) {
            this.addConnectionFactory(connectionFactory);
        }
    }

    @Override
    public ConnectionFactory<?> getConnectionFactory(String providerId) {
        ConnectionFactory<?> connectionFactory = this.connectionFactories.get(providerId);
        if (connectionFactory == null) {
            throw new IllegalArgumentException("No connection factory for service provider '" + providerId + "' is registered");
        }
        return connectionFactory;
    }

    @Override
    public <A> ConnectionFactory<A> getConnectionFactory(Class<A> apiType) {
        String providerId = this.apiTypeIndex.get(apiType);
        if (providerId == null) {
            throw new IllegalArgumentException("No connection factory for API [" + apiType.getName() + "] is registered");
        }
        return this.getConnectionFactory(providerId);
    }

    @Override
    public Set<String> registeredProviderIds() {
        return this.connectionFactories.keySet();
    }
}

