/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.score.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.questioncontainer.score.model.ScoreDetail;
import org.silverpeas.core.questioncontainer.score.model.ScorePK;

public class ScoreDAO {
    public static final String SCORECOLUMNNAMES = "scoreId, qcId, userId, scoreParticipationId, scoreScore, scoreElapsedTime,scoreParticipationDate,scoreSuggestion";
    private static final String DELETE_SCORE_FOR_QUESTION = "DELETE FROM sb_question_score WHERE qcid = ? ";
    private static final String AVERAGE_SCORE_FOR_QUESTION = "SELECT SUM(scoreScore) FROM sb_question_score WHERE qcId = ? ";
    private static final String ADD_SCORE_FOR_QUESTION = "INSERT INTO sb_question_score values(?, ?, ?, ?, ?, ?, ?, ?) ";
    private static final String SELECT_SCORE_BY_FATHER_ID = "SELECT scoreId, qcId, userId, scoreParticipationId, scoreScore, scoreElapsedTime,scoreParticipationDate,scoreSuggestion FROM SB_Question_Score WHERE qcId = ? ORDER BY scoreScore DESC";
    private static final String DELETE_SCORES_FOR_ALL_QUESTIONS = "DELETE FROM SB_Question_Score WHERE qcId in (SELECT QC.qcId FROM SB_Question_Question Q, SB_QuestionContainer_QC QC WHERE QC.qcId = Q.qcId AND Q.instanceId = ?)";
    private static final String SELECT = "select ";
    private static final String FROM = " from ";

    private ScoreDAO() {
    }

    private static ScoreDetail getScoreFromResultSet(ResultSet rs, ScorePK scorePK) throws SQLException {
        String id = Integer.toString(rs.getInt(1));
        String fatherId = Integer.toString(rs.getInt(2));
        String userId = rs.getString(3);
        int participationId = rs.getInt(4);
        int score = rs.getInt(5);
        int elapsedTime = rs.getInt(6);
        String participationDate = rs.getString(7);
        String suggestion = rs.getString(8);
        return new ScoreDetail(new ScorePK(id, scorePK), fatherId, userId, participationId, participationDate, score, elapsedTime, suggestion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addScore(Connection con, ScoreDetail scoreDetail) throws SQLException {
        int newId = DBUtil.getNextId((String)scoreDetail.getScorePK().getTableName(), (String)"scoreId");
        ScorePK scorePK = scoreDetail.getScorePK();
        scorePK.setId(Integer.toString(newId));
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(ADD_SCORE_FOR_QUESTION);
            prepStmt.setInt(1, newId);
            prepStmt.setInt(2, Integer.parseInt(scoreDetail.getFatherId()));
            prepStmt.setString(3, scoreDetail.getUserId());
            prepStmt.setInt(4, scoreDetail.getParticipationId());
            prepStmt.setInt(5, scoreDetail.getScore());
            prepStmt.setInt(6, scoreDetail.getElapsedTime());
            prepStmt.setString(7, scoreDetail.getParticipationDate());
            prepStmt.setString(8, scoreDetail.getSuggestion());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateScore(Connection con, ScoreDetail scoreDetail) throws SQLException {
        String insertStatement = "update " + scoreDetail.getScorePK().getTableName() + " set scoreSuggestion = ? where scoreId = ?";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertStatement);
            prepStmt.setString(1, scoreDetail.getSuggestion());
            prepStmt.setInt(2, Integer.parseInt(scoreDetail.getScorePK().getId()));
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteScore(Connection con, ScorePK scorePK) throws SQLException {
        String deleteStatement = "delete from " + scorePK.getTableName() + " where scoreId = ? ";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(deleteStatement);
            prepStmt.setInt(1, Integer.parseInt(scorePK.getId()));
            prepStmt.executeUpdate();
            prepStmt.close();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void deleteScoreByFatherPK(Connection con, String fatherId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(DELETE_SCORE_FOR_QUESTION);
            prepStmt.setInt(1, Integer.parseInt(fatherId));
            prepStmt.executeUpdate();
            prepStmt.close();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void deleteAllScoresByInstanceId(Connection con, String instanceId) throws SQLException {
        try (PreparedStatement deletion = con.prepareStatement(DELETE_SCORES_FOR_ALL_QUESTIONS);){
            deletion.setString(1, instanceId);
            deletion.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ScoreDetail> getAllScores(Connection con, ScorePK scorePK) throws SQLException {
        ArrayList<ScoreDetail> arrayList;
        ResultSet rs = null;
        String selectStatement = "select scoreId, qcId, userId, scoreParticipationId, scoreScore, scoreElapsedTime,scoreParticipationDate,scoreSuggestion from " + scorePK.getTableName() + " order by scoreParticipationDate desc";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            rs = prepStmt.executeQuery();
            ArrayList<ScoreDetail> result = new ArrayList<ScoreDetail>();
            while (rs.next()) {
                ScoreDetail scoreDetail = ScoreDAO.getScoreFromResultSet(rs, scorePK);
                result.add(scoreDetail);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ScoreDetail> getUserScores(Connection con, ScorePK scorePK, String userId) throws SQLException {
        ArrayList<ScoreDetail> arrayList;
        ResultSet rs = null;
        String selectStatement = "select scoreId, qcId, userId, scoreParticipationId, scoreScore, scoreElapsedTime,scoreParticipationDate,scoreSuggestion from " + scorePK.getTableName() + " where userId = ? order by scoreParticipationDate desc";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setInt(1, Integer.parseInt(userId));
            rs = prepStmt.executeQuery();
            ArrayList<ScoreDetail> result = new ArrayList<ScoreDetail>();
            while (rs.next()) {
                ScoreDetail scoreDetail = ScoreDAO.getScoreFromResultSet(rs, scorePK);
                result.add(scoreDetail);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ScoreDetail> getUserScoresByFatherId(Connection con, ScorePK scorePK, String fatherId, String userId) throws SQLException {
        ArrayList<ScoreDetail> arrayList;
        ResultSet rs = null;
        String selectStatement = "select scoreId, qcId, userId, scoreParticipationId, scoreScore, scoreElapsedTime,scoreParticipationDate,scoreSuggestion from " + scorePK.getTableName() + " where qcId = ? and userId=? order by scoreParticipationDate desc";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setInt(1, Integer.parseInt(fatherId));
            prepStmt.setString(2, userId);
            rs = prepStmt.executeQuery();
            ArrayList<ScoreDetail> result = new ArrayList<ScoreDetail>();
            while (rs.next()) {
                ScoreDetail scoreDetail = ScoreDAO.getScoreFromResultSet(rs, scorePK);
                result.add(scoreDetail);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ScoreDetail> getScoresByFatherId(Connection con, ScorePK scorePK, String fatherId) throws SQLException {
        ArrayList<ScoreDetail> arrayList;
        ResultSet rs = null;
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(SELECT_SCORE_BY_FATHER_ID);
            prepStmt.setInt(1, Integer.parseInt(fatherId));
            rs = prepStmt.executeQuery();
            ArrayList<ScoreDetail> result = new ArrayList<ScoreDetail>();
            while (rs.next()) {
                ScoreDetail scoreDetail = ScoreDAO.getScoreFromResultSet(rs, scorePK);
                result.add(scoreDetail);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ScoreDetail> getBestScoresByFatherId(Connection con, ScorePK scorePK, int nbBestScores, String fatherId) throws SQLException {
        ArrayList<ScoreDetail> arrayList;
        ResultSet rs = null;
        String selectStatement = "select scoreId, qcId, userId, scoreParticipationId, scoreScore, scoreElapsedTime,scoreParticipationDate,scoreSuggestion from " + scorePK.getTableName() + " where qcId = ? order by scoreScore desc";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setInt(1, Integer.parseInt(fatherId));
            rs = prepStmt.executeQuery();
            ArrayList<ScoreDetail> result = new ArrayList<ScoreDetail>();
            for (int nbRecord = 0; rs.next() && nbRecord < nbBestScores; ++nbRecord) {
                ScoreDetail scoreDetail = ScoreDAO.getScoreFromResultSet(rs, scorePK);
                result.add(scoreDetail);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ScoreDetail> getWorstScoresByFatherId(Connection con, ScorePK scorePK, int nbWorstScores, String fatherId) throws SQLException {
        ArrayList<ScoreDetail> arrayList;
        ResultSet rs = null;
        String selectStatement = "select scoreId, qcId, userId, scoreParticipationId, scoreScore, scoreElapsedTime,scoreParticipationDate,scoreSuggestion from " + scorePK.getTableName() + " where qcId = ? order by scoreScore";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setInt(1, Integer.parseInt(fatherId));
            rs = prepStmt.executeQuery();
            ArrayList<ScoreDetail> result = new ArrayList<ScoreDetail>();
            for (int nbRecord = 0; rs.next() && nbRecord < nbWorstScores; ++nbRecord) {
                ScoreDetail scoreDetail = ScoreDAO.getScoreFromResultSet(rs, scorePK);
                result.add(scoreDetail);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNbVotersByFatherId(Connection con, ScorePK scorePK, String fatherId) throws SQLException {
        PreparedStatement prepStmt;
        ResultSet rs;
        block2: {
            int n;
            rs = null;
            String selectStatement = "select count(*) from " + scorePK.getTableName() + " where qcId = ?";
            prepStmt = null;
            try {
                prepStmt = con.prepareStatement(selectStatement);
                prepStmt.setInt(1, Integer.parseInt(fatherId));
                rs = prepStmt.executeQuery();
                if (!rs.next()) break block2;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, (Statement)prepStmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)rs, (Statement)prepStmt);
            return n;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getAverageScoreByFatherId(Connection con, ScorePK scorePK, String fatherId) throws SQLException {
        int nbVoters = ScoreDAO.getNbVotersByFatherId(con, scorePK, fatherId);
        float average = 0.0f;
        if (nbVoters > 0) {
            PreparedStatement prepStmt;
            ResultSet rs;
            block3: {
                rs = null;
                prepStmt = null;
                try {
                    prepStmt = con.prepareStatement(AVERAGE_SCORE_FOR_QUESTION);
                    prepStmt.setInt(1, Integer.parseInt(fatherId));
                    rs = prepStmt.executeQuery();
                    if (!rs.next()) break block3;
                    int sumPoints = rs.getInt(1);
                    average = (float)Math.round((float)sumPoints / (float)nbVoters * 10.0f) / 10.0f;
                }
                catch (Throwable throwable) {
                    DBUtil.close(rs, (Statement)prepStmt);
                    throw throwable;
                }
            }
            DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        }
        return average;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScoreDetail getUserScoreByFatherIdAndParticipationId(Connection con, ScorePK scorePK, String fatherId, String userId, int participationId) throws SQLException {
        PreparedStatement prepStmt;
        ResultSet rs;
        block2: {
            ScoreDetail scoreDetail;
            rs = null;
            String selectStatement = "select scoreId, qcId, userId, scoreParticipationId, scoreScore, scoreElapsedTime,scoreParticipationDate,scoreSuggestion from " + scorePK.getTableName() + " where qcId = ? and userId = ? and scoreParticipationId= ?";
            prepStmt = null;
            try {
                prepStmt = con.prepareStatement(selectStatement);
                prepStmt.setInt(1, Integer.parseInt(fatherId));
                prepStmt.setString(2, userId);
                prepStmt.setInt(3, participationId);
                rs = prepStmt.executeQuery();
                if (!rs.next()) break block2;
                scoreDetail = ScoreDAO.getScoreFromResultSet(rs, scorePK);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, (Statement)prepStmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)rs, (Statement)prepStmt);
            return scoreDetail;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUserNbParticipationsByFatherId(Connection con, ScorePK scorePK, String fatherId, String userId) throws SQLException {
        PreparedStatement prepStmt;
        ResultSet rs;
        block2: {
            int n;
            rs = null;
            String selectStatement = "select count(*) from " + scorePK.getTableName() + " where qcId = ? and userId = ?";
            prepStmt = null;
            try {
                prepStmt = con.prepareStatement(selectStatement);
                prepStmt.setInt(1, Integer.parseInt(fatherId));
                prepStmt.setString(2, userId);
                rs = prepStmt.executeQuery();
                if (!rs.next()) break block2;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, (Statement)prepStmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)rs, (Statement)prepStmt);
            return n;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return 0;
    }

    public static int getUserPositionByFatherIdAndParticipationId(Connection con, ScorePK scorePK, String fatherId, String userId, int participationId) throws SQLException {
        Collection<ScoreDetail> scoreDetails = ScoreDAO.getScoresByFatherId(con, scorePK, fatherId);
        int position = 0;
        int nbPosition = 0;
        String previousScore = null;
        for (ScoreDetail scoreDetail : scoreDetails) {
            if (previousScore != null && scoreDetail.getScore() == Integer.parseInt(previousScore)) {
                ++nbPosition;
            } else {
                position += nbPosition + 1;
                nbPosition = 0;
            }
            if (scoreDetail.getUserId().equals(userId) && scoreDetail.getParticipationId() == participationId) {
                return position;
            }
            previousScore = Integer.toString(scoreDetail.getScore());
        }
        return 0;
    }
}

