/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;

@Technical
@Service
@Singleton
public class ResourcesCloser {
    private final Deque<Closeable> stack = new ArrayDeque<Closeable>(4);

    public static ResourcesCloser get() {
        return (ResourcesCloser)ServiceProvider.getService(ResourcesCloser.class, (Annotation[])new Annotation[0]);
    }

    public void register(@Nullable Closeable closeable) {
        if (closeable != null) {
            this.stack.addFirst(closeable);
        }
    }

    @PreDestroy
    private void closeAllResources() {
        while (!this.stack.isEmpty()) {
            Closeable closeable = this.stack.removeFirst();
            try {
                closeable.close();
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }
}

