/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cluster;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceStatus;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.LocalOnlyCacheLoader;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.util.logging.Log;

@ConfiguredBy(value=ClusterLoaderConfiguration.class)
@Deprecated
public class ClusterLoader
implements CacheLoader,
LocalOnlyCacheLoader,
PersistenceManager.StoreChangeListener {
    private RpcManager rpcManager;
    private AdvancedCache<?, ?> cache;
    private CommandsFactory commandsFactory;
    private KeyPartitioner keyPartitioner;
    private PersistenceManager persistenceManager;
    private volatile boolean needsSegments;
    private InitializationContext ctx;

    @Override
    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.cache = ctx.getCache().getAdvancedCache();
        this.commandsFactory = this.cache.getComponentRegistry().getCommandsFactory();
        this.rpcManager = this.cache.getRpcManager();
        this.keyPartitioner = this.cache.getComponentRegistry().getComponent(KeyPartitioner.class);
        this.persistenceManager = this.cache.getComponentRegistry().getComponent(PersistenceManager.class);
        this.needsSegments = Configurations.needSegments(this.cache.getCacheConfiguration());
    }

    public MarshallableEntry loadEntry(Object key) throws PersistenceException {
        Response response;
        Collection<Response> responses;
        if (!this.isCacheReady()) {
            return null;
        }
        ClusteredGetCommand clusteredGetCommand = this.commandsFactory.buildClusteredGetCommand(key, this.needsSegments ? Integer.valueOf(this.keyPartitioner.getSegment(key)) : null, EnumUtil.bitSetOf((Enum)Flag.SKIP_OWNERSHIP_CHECK));
        try {
            clusteredGetCommand.setTopologyId(this.rpcManager.getTopologyId());
            CompletionStage<Map<Address, Response>> getAll = this.rpcManager.invokeCommandOnAll(clusteredGetCommand, MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
            responses = this.rpcManager.blocking(getAll).values();
        }
        catch (Exception e) {
            Log.PERSISTENCE.errorDoingRemoteCall(e);
            throw new PersistenceException(e);
        }
        if (responses.isEmpty()) {
            return null;
        }
        if (responses.size() > 1) {
            HashSet<Response> setResponses = new HashSet<Response>(responses);
            if (setResponses.size() > 1) {
                throw new PersistenceException(String.format("Responses contains more than 1 element and these elements are not equal, so can't decide which one to use: %s", setResponses));
            }
            response = (Response)setResponses.iterator().next();
        } else {
            response = responses.iterator().next();
        }
        if (response.isSuccessful() && response instanceof SuccessfulResponse) {
            InternalCacheValue value = (InternalCacheValue)((SuccessfulResponse)response).getResponseValue();
            return value == null ? null : this.ctx.getMarshallableEntryFactory().create(key, value.getValue());
        }
        Log.PERSISTENCE.unknownResponsesFromRemoteCache(responses);
        throw new PersistenceException("Unknown responses");
    }

    @Override
    public boolean contains(Object key) {
        return this.loadEntry(key) != null;
    }

    public void start() {
        this.persistenceManager.addStoreListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeChanged(PersistenceStatus status) {
        ClusterLoader clusterLoader = this;
        synchronized (clusterLoader) {
            this.needsSegments = this.needsSegments || status.usingSegmentedStore();
        }
    }

    public void stop() {
        this.persistenceManager.removeStoreListener(this);
    }

    protected boolean isCacheReady() {
        return this.cache.getStatus() == ComponentStatus.RUNNING;
    }
}

