/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.security.doseta.Verifications;
import org.jboss.resteasy.annotations.security.doseta.Verify;
import org.jboss.resteasy.security.doseta.AbstractDigitalVerificationHeaderDecorator;
import org.jboss.resteasy.security.doseta.Verifier;

@Provider
@ConstrainedTo(value=RuntimeType.CLIENT)
public class ClientDigitalVerificationHeaderDecoratorFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext configurable) {
        Verify verify = resourceInfo.getResourceMethod().getAnnotation(Verify.class);
        Verifications verifications = resourceInfo.getResourceClass().getAnnotation(Verifications.class);
        if (verify != null || verifications != null) {
            configurable.register((Object)new DigitalVerificationHeaderDecorator(verify, verifications));
        }
    }

    @Priority(value=3000)
    public static class DigitalVerificationHeaderDecorator
    extends AbstractDigitalVerificationHeaderDecorator
    implements ClientResponseFilter {
        public DigitalVerificationHeaderDecorator(Verify verify, Verifications verifications) {
            this.verify = verify;
            this.verifications = verifications;
        }

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
            requestContext.setProperty(Verifier.class.getName(), (Object)this.create());
        }
    }
}

