/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.link;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.ObjectWriter;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.server.ServerWriter;
import io.smallrye.openapi.runtime.util.StringUtil;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.links.Link;

public class LinkWriter {
    private LinkWriter() {
    }

    public static void writeLinks(ObjectNode parent, Map<String, Link> links) {
        if (links == null) {
            return;
        }
        ObjectNode linksNode = parent.putObject("links");
        for (Map.Entry<String, Link> entry : links.entrySet()) {
            LinkWriter.writeLink(linksNode, entry.getValue(), entry.getKey());
        }
    }

    private static void writeLink(ObjectNode parent, Link model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        if (StringUtil.isNotEmpty(model.getRef())) {
            JsonUtil.stringProperty(node, "$ref", model.getRef());
        } else {
            JsonUtil.stringProperty(node, "operationRef", model.getOperationRef());
            JsonUtil.stringProperty(node, "operationId", model.getOperationId());
            LinkWriter.writeLinkParameters(node, model.getParameters());
            ObjectWriter.writeObject(node, "requestBody", model.getRequestBody());
            JsonUtil.stringProperty(node, "description", model.getDescription());
            ServerWriter.writeServer(node, model.getServer());
            ExtensionWriter.writeExtensions(node, model);
        }
    }

    private static void writeLinkParameters(ObjectNode parent, Map<String, Object> parameters) {
        if (parameters == null) {
            return;
        }
        ObjectNode node = parent.putObject("parameters");
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            ObjectWriter.writeObject(node, entry.getKey(), entry.getValue());
        }
    }
}

