/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.dsl.RangeTerminationExcludable;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.Helper;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.RangeQueryContext;

public class ConnectedMultiFieldsRangeQueryBuilder
implements RangeTerminationExcludable {
    private final RangeQueryContext rangeContext;
    private final QueryCustomizer queryCustomizer;
    private final List<FieldContext> fieldContexts;
    private final QueryBuildingContext queryContext;

    public ConnectedMultiFieldsRangeQueryBuilder(RangeQueryContext rangeContext, QueryCustomizer queryCustomizer, List<FieldContext> fieldContexts, QueryBuildingContext queryContext) {
        this.rangeContext = rangeContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldContexts = fieldContexts;
        this.queryContext = queryContext;
    }

    @Override
    public RangeTerminationExcludable excludeLimit() {
        if (this.rangeContext.getFrom() != null && this.rangeContext.getTo() != null) {
            this.rangeContext.setExcludeTo(true);
        } else if (this.rangeContext.getFrom() != null) {
            this.rangeContext.setExcludeFrom(true);
        } else if (this.rangeContext.getTo() != null) {
            this.rangeContext.setExcludeTo(true);
        } else {
            throw new AssertionFailure("Both from and to clause of a range query are null");
        }
        return this;
    }

    @Override
    public Query createQuery() {
        int size = this.fieldContexts.size();
        ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
        if (size == 1) {
            return this.queryCustomizer.setWrappedQuery(this.createQuery(this.fieldContexts.get(0), conversionContext)).createQuery();
        }
        BooleanQuery.Builder aggregatedFieldsQueryBuilder = new BooleanQuery.Builder();
        for (FieldContext fieldContext : this.fieldContexts) {
            aggregatedFieldsQueryBuilder.add(this.createQuery(fieldContext, conversionContext), BooleanClause.Occur.SHOULD);
        }
        return this.queryCustomizer.setWrappedQuery((Query)aggregatedFieldsQueryBuilder.build()).createQuery();
    }

    private Query createQuery(FieldContext fieldContext, ConversionContext conversionContext) {
        String fieldName = fieldContext.getField();
        DocumentBuilderIndexedEntity documentBuilder = this.queryContext.getDocumentBuilder();
        Query perFieldQuery = Helper.requiresNumericQuery(documentBuilder, fieldContext, this.rangeContext.getFrom(), this.rangeContext.getTo()) ? ConnectedMultiFieldsRangeQueryBuilder.createNumericRangeQuery(fieldName, this.rangeContext) : ConnectedMultiFieldsRangeQueryBuilder.createKeywordRangeQuery(fieldName, this.rangeContext, this.queryContext, conversionContext, fieldContext);
        return fieldContext.getFieldCustomizer().setWrappedQuery(perFieldQuery).createQuery();
    }

    private static Query createKeywordRangeQuery(String fieldName, RangeQueryContext rangeContext, QueryBuildingContext queryContext, ConversionContext conversionContext, FieldContext fieldContext) {
        String upperTerm;
        String lowerTerm;
        String toString;
        ScopedAnalyzerReference analyzerReference = queryContext.getQueryAnalyzerReference();
        DocumentBuilderIndexedEntity documentBuilder = queryContext.getDocumentBuilder();
        String fromString = rangeContext.hasFrom() ? fieldContext.objectToString(documentBuilder, rangeContext.getFrom(), conversionContext) : null;
        String string = toString = rangeContext.hasTo() ? fieldContext.objectToString(documentBuilder, rangeContext.getTo(), conversionContext) : null;
        if (analyzerReference.is(LuceneAnalyzerReference.class)) {
            Analyzer queryAnalyzer = analyzerReference.unwrap(LuceneAnalyzerReference.class).getAnalyzer();
            lowerTerm = fromString == null ? null : Helper.getAnalyzedTerm(fieldName, fromString, "from", queryAnalyzer, fieldContext);
            upperTerm = toString == null ? null : Helper.getAnalyzedTerm(fieldName, toString, "to", queryAnalyzer, fieldContext);
        } else {
            lowerTerm = fromString == null ? null : fromString;
            upperTerm = toString == null ? null : toString;
        }
        return TermRangeQuery.newStringRange((String)fieldName, (String)lowerTerm, (String)upperTerm, (!rangeContext.isExcludeFrom() ? 1 : 0) != 0, (!rangeContext.isExcludeTo() ? 1 : 0) != 0);
    }

    private static Query createNumericRangeQuery(String fieldName, RangeQueryContext rangeContext) {
        return NumericFieldUtils.createNumericRangeQuery(fieldName, rangeContext.getFrom(), rangeContext.getTo(), !rangeContext.isExcludeFrom(), !rangeContext.isExcludeTo());
    }
}

