/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.OptionalInt;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;

public class BitSetExternalizer
implements Externalizer<BitSet> {
    public void writeObject(ObjectOutput output, BitSet set) throws IOException {
        byte[] bytes = set.toByteArray();
        IndexSerializer.VARIABLE.writeInt(output, bytes.length);
        output.write(bytes);
    }

    public BitSet readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        byte[] bytes = new byte[IndexSerializer.VARIABLE.readInt(input)];
        input.readFully(bytes);
        return BitSet.valueOf(bytes);
    }

    public OptionalInt size(BitSet set) {
        int size = set.size();
        int bytes = size / 8;
        if (size % 8 > 0) {
            ++bytes;
        }
        return OptionalInt.of(IndexSerializer.VARIABLE.size(bytes) + bytes);
    }

    public Class<BitSet> getTargetClass() {
        return BitSet.class;
    }
}

