/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.server.ApplicationServerService;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.server.jmx.RunningStateJmx;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.OperationListener;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.jboss.threads.JBossExecutors;
import org.wildfly.security.manager.WildFlySecurityManager;

final class BootstrapImpl
implements Bootstrap {
    private static final String SIGTERM_SUSPEND_TIMEOUT_PROP = "org.wildfly.sigterm.suspend.timeout";
    private static final int MAX_THREADS = ServerEnvironment.getBootstrapMaxThreads();
    private final ShutdownHook shutdownHook = new ShutdownHook();
    private final ServiceContainer container = ShutdownHook.access$100(this.shutdownHook);

    @Override
    public AsyncFuture<ServiceContainer> bootstrap(Bootstrap.Configuration configuration, List<ServiceActivator> extraServices) {
        assert (!this.shutdownHook.down);
        try {
            return this.internalBootstrap(configuration, extraServices);
        }
        catch (Error | RuntimeException e) {
            this.shutdownHook.shutdown(true);
            throw e;
        }
    }

    private AsyncFuture<ServiceContainer> internalBootstrap(Bootstrap.Configuration configuration, List<ServiceActivator> extraServices) {
        try {
            Object value = ManagementFactory.getPlatformMBeanServer().getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "MaxFileDescriptorCount");
            long fdCount = Long.parseLong(value.toString());
            if (fdCount < 4096L) {
                ServerLogger.FD_LIMIT_LOGGER.fdTooLow(fdCount);
            }
        }
        catch (Throwable value) {
            // empty catch block
        }
        assert (configuration != null) : "configuration is null";
        String resolverWarning = WildFlySecurityManager.getPropertyPrivileged((String)"org.jboss.resolver.warning", null);
        if (resolverWarning == null) {
            WildFlySecurityManager.setPropertyPrivileged((String)"org.jboss.resolver.warning", (String)"true");
        }
        ModuleLoader moduleLoader = configuration.getModuleLoader();
        Bootstrap.ConfigurationPersisterFactory configurationPersisterFactory = configuration.getConfigurationPersisterFactory();
        assert (configurationPersisterFactory != null) : "configurationPersisterFactory is null";
        try {
            Module.registerURLStreamHandlerFactoryModule((Module)moduleLoader.loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
        }
        catch (ModuleLoadException e) {
            throw ServerLogger.ROOT_LOGGER.vfsNotAvailable();
        }
        final FutureServiceContainer future = new FutureServiceContainer(this.container);
        ServiceTarget tracker = this.container.subTarget();
        ControlledProcessState processState = new ControlledProcessState(true);
        this.shutdownHook.setControlledProcessState(processState);
        ProcessStateNotifier processStateNotifier = (ProcessStateNotifier)ControlledProcessStateService.addService((ServiceTarget)tracker, (ControlledProcessState)processState).getValue();
        SuspendController suspendController = new SuspendController();
        RunningStateJmx.registerMBean(processStateNotifier, suspendController, configuration.getRunningModeControl(), configuration.getServerEnvironment().getLaunchType() != ServerEnvironment.LaunchType.APPCLIENT);
        ApplicationServerService applicationServerService = new ApplicationServerService(extraServices, configuration, processState, suspendController);
        tracker.addService(Services.JBOSS_AS, (Service)applicationServerService).install();
        ServiceController rootService = this.container.getRequiredService(Services.JBOSS_AS);
        rootService.addListener(new LifecycleListener(){

            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                switch (event) {
                    case UP: {
                        controller.removeListener((LifecycleListener)this);
                        ServiceController controllerServiceController = controller.getServiceContainer().getRequiredService(Services.JBOSS_SERVER_CONTROLLER);
                        controllerServiceController.addListener(new LifecycleListener(){

                            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                                switch (event) {
                                    case UP: {
                                        future.done();
                                        controller.removeListener((LifecycleListener)this);
                                        break;
                                    }
                                    case FAILED: {
                                        future.failed((Throwable)controller.getStartException());
                                        controller.removeListener((LifecycleListener)this);
                                        break;
                                    }
                                    case REMOVED: {
                                        future.failed((Throwable)ServerLogger.ROOT_LOGGER.serverControllerServiceRemoved());
                                        controller.removeListener((LifecycleListener)this);
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case FAILED: {
                        controller.removeListener((LifecycleListener)this);
                        future.failed((Throwable)controller.getStartException());
                        break;
                    }
                    case REMOVED: {
                        controller.removeListener((LifecycleListener)this);
                        future.failed(ServerLogger.ROOT_LOGGER.rootServiceRemoved());
                    }
                }
            }
        });
        return future;
    }

    @Override
    public AsyncFuture<ServiceContainer> startup(Bootstrap.Configuration configuration, List<ServiceActivator> extraServices) {
        try {
            ServiceContainer container = (ServiceContainer)this.bootstrap(configuration, extraServices).get();
            ServiceController controller = container.getRequiredService(Services.JBOSS_AS);
            return (AsyncFuture)controller.getValue();
        }
        catch (Exception ex) {
            this.shutdownHook.shutdown(true);
            throw ServerLogger.ROOT_LOGGER.cannotStartServer(ex);
        }
    }

    @Override
    public void failed() {
        this.shutdownHook.shutdown(true);
    }

    private static class ShutdownHook
    extends Thread {
        private boolean down;
        private ControlledProcessState processState;
        private ServiceContainer container;

        private ShutdownHook() {
        }

        private ServiceContainer register() {
            Runtime.getRuntime().addShutdownHook(this);
            ShutdownHook shutdownHook = this;
            synchronized (shutdownHook) {
                if (!this.down) {
                    this.container = ServiceContainer.Factory.create((String)"jboss-as", (int)MAX_THREADS, (long)30L, (TimeUnit)TimeUnit.SECONDS, (boolean)false);
                    return this.container;
                }
                throw new IllegalStateException();
            }
        }

        private synchronized void setControlledProcessState(ControlledProcessState ps) {
            this.processState = ps;
        }

        @Override
        public void run() {
            this.shutdown(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown(boolean failed) {
            ServiceContainer sc;
            block16: {
                ControlledProcessState ps;
                ShutdownHook shutdownHook = this;
                synchronized (shutdownHook) {
                    this.down = true;
                    sc = this.container;
                    ps = this.processState;
                }
                try {
                    if (ps == null) break block16;
                    if (!failed && ps.getState() == ControlledProcessState.State.RUNNING) {
                        ShutdownHook.suspend(sc);
                    }
                    ps.setStopping();
                }
                catch (Throwable throwable) {
                    if (sc != null && !sc.isShutdownComplete()) {
                        if (!failed) {
                            SystemExiter.logBeforeExit(ServerLogger.ROOT_LOGGER::shutdownHookInvoked);
                        }
                        CountDownLatch terminateLatch = new CountDownLatch(1);
                        sc.addTerminateListener(new ServiceContainer.TerminateListener(this, terminateLatch){
                            final /* synthetic */ CountDownLatch val$terminateLatch;
                            final /* synthetic */ ShutdownHook this$0;
                            {
                                this.this$0 = this$0;
                                this.val$terminateLatch = countDownLatch;
                            }

                            public void handleTermination(ServiceContainer.TerminateListener.Info info) {
                                this.val$terminateLatch.countDown();
                            }
                        });
                        sc.shutdown();
                        while (true) {
                            try {
                                terminateLatch.await();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    throw throwable;
                }
            }
            if (sc != null && !sc.isShutdownComplete()) {
                if (!failed) {
                    SystemExiter.logBeforeExit(ServerLogger.ROOT_LOGGER::shutdownHookInvoked);
                }
                CountDownLatch terminateLatch = new CountDownLatch(1);
                sc.addTerminateListener(new /* invalid duplicate definition of identical inner class */);
                sc.shutdown();
                while (true) {
                    try {
                        terminateLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }

        private static void suspend(ServiceContainer sc) {
            try {
                final SuspendController suspendController = ShutdownHook.getSuspendController(sc);
                if (suspendController != null) {
                    long timeout = ShutdownHook.getSuspendTimeout();
                    final CountDownLatch suspendLatch = new CountDownLatch(1);
                    OperationListener listener = new OperationListener(){

                        @Override
                        public void suspendStarted() {
                        }

                        @Override
                        public void complete() {
                            suspendController.removeListener(this);
                            suspendLatch.countDown();
                        }

                        @Override
                        public void cancelled() {
                            suspendController.removeListener(this);
                            suspendLatch.countDown();
                        }

                        @Override
                        public void timeout() {
                            suspendController.removeListener(this);
                            suspendLatch.countDown();
                        }
                    };
                    suspendController.addListener(listener);
                    suspendController.suspend(timeout);
                    if (timeout > 0L) {
                        suspendLatch.await(timeout + 500L, TimeUnit.MILLISECONDS);
                    } else if (timeout < 0L) {
                        suspendLatch.await();
                    }
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private static SuspendController getSuspendController(ServiceContainer sc) {
            ServiceController serviceController;
            SuspendController result = null;
            if (sc != null && !sc.isShutdownComplete() && (serviceController = sc.getService(Services.JBOSS_SUSPEND_CONTROLLER)) != null && serviceController.getState() == ServiceController.State.UP) {
                result = (SuspendController)serviceController.getValue();
            }
            return result;
        }

        private static long getSuspendTimeout() {
            long result = 0L;
            String timeoutString = System.getProperty(BootstrapImpl.SIGTERM_SUSPEND_TIMEOUT_PROP);
            if (timeoutString != null && timeoutString.length() > 0) {
                try {
                    int max = Integer.decode(timeoutString);
                    result = max > 0 ? (long)(max * 1000) : (long)max;
                }
                catch (NumberFormatException ex) {
                    try {
                        ServerLogger.ROOT_LOGGER.failedToParseCommandLineInteger(BootstrapImpl.SIGTERM_SUSPEND_TIMEOUT_PROP, timeoutString);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return result;
        }

        static /* synthetic */ ServiceContainer access$100(ShutdownHook x0) {
            return x0.register();
        }
    }

    static class FutureServiceContainer
    extends AsyncFutureTask<ServiceContainer> {
        private final ServiceContainer container;

        FutureServiceContainer(ServiceContainer container) {
            super((Executor)JBossExecutors.directExecutor());
            this.container = container;
        }

        public void asyncCancel(boolean interruptionDesired) {
            this.container.shutdown();
            this.container.addTerminateListener(new ServiceContainer.TerminateListener(){

                public void handleTermination(ServiceContainer.TerminateListener.Info info) {
                    this.setCancelled();
                }
            });
        }

        void done() {
            this.setResult(this.container);
        }

        void failed(Throwable t) {
            this.setFailed(t);
        }
    }
}

