/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing;

import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.server.OperationNameProvider;
import io.opentracing.contrib.jaxrs2.server.ServerTracingDynamicFeature;
import io.smallrye.opentracing.SmallRyeLogging;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@Provider
public class SmallRyeTracingDynamicFeature
implements DynamicFeature {
    private final ServerTracingDynamicFeature delegate;

    public SmallRyeTracingDynamicFeature() {
        Instance tracerInstance = CDI.current().select(Tracer.class, new Annotation[0]);
        Config config = ConfigProvider.getConfig();
        Optional skipPattern = config.getOptionalValue("mp.opentracing.server.skip-pattern", String.class);
        Optional operationNameProvider = config.getOptionalValue("mp.opentracing.server.operation-name-provider", String.class);
        ServerTracingDynamicFeature.Builder builder = new ServerTracingDynamicFeature.Builder((Tracer)tracerInstance.get()).withOperationNameProvider((OperationNameProvider.Builder)OperationNameProvider.ClassNameOperationName.newBuilder()).withTraceSerialization(false);
        if (skipPattern.isPresent()) {
            builder.withSkipPattern((String)skipPattern.get());
        }
        if (operationNameProvider.isPresent()) {
            if ("http-path".equalsIgnoreCase((String)operationNameProvider.get())) {
                builder.withOperationNameProvider((OperationNameProvider.Builder)OperationNameProvider.WildcardOperationName.newBuilder());
            } else if (!"class-method".equalsIgnoreCase((String)operationNameProvider.get())) {
                SmallRyeLogging.log.operationNameNotMatch();
            }
        }
        this.delegate = builder.build();
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        this.delegate.configure(resourceInfo, context);
    }
}

