/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.interfaces.AnyInterfaceCriteria;
import org.jboss.as.controller.interfaces.CriteriaValidator;
import org.jboss.as.controller.interfaces.InetAddressMatchInterfaceCriteria;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.as.controller.interfaces.LinkLocalInterfaceCriteria;
import org.jboss.as.controller.interfaces.LoopbackAddressInterfaceCriteria;
import org.jboss.as.controller.interfaces.LoopbackInterfaceCriteria;
import org.jboss.as.controller.interfaces.NicInterfaceCriteria;
import org.jboss.as.controller.interfaces.NicMatchInterfaceCriteria;
import org.jboss.as.controller.interfaces.NotInterfaceCriteria;
import org.jboss.as.controller.interfaces.PointToPointInterfaceCriteria;
import org.jboss.as.controller.interfaces.PublicAddressInterfaceCriteria;
import org.jboss.as.controller.interfaces.SiteLocalInterfaceCriteria;
import org.jboss.as.controller.interfaces.SubnetMatchInterfaceCriteria;
import org.jboss.as.controller.interfaces.SupportsMulticastInterfaceCriteria;
import org.jboss.as.controller.interfaces.UpInterfaceCriteria;
import org.jboss.as.controller.interfaces.VirtualInterfaceCriteria;
import org.jboss.as.controller.interfaces.WildcardInetAddressInterfaceCriteria;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public final class ParsedInterfaceCriteria {
    private static final ParsedInterfaceCriteria ANY = new ParsedInterfaceCriteria(true);
    private final String failureMessage;
    private final boolean anyLocal;
    private final Set<InterfaceCriteria> criteria = new LinkedHashSet<InterfaceCriteria>();

    private ParsedInterfaceCriteria(String failureMessage) {
        this.failureMessage = failureMessage;
        this.anyLocal = false;
    }

    private ParsedInterfaceCriteria(boolean anyLocal) {
        this.failureMessage = null;
        this.anyLocal = anyLocal;
    }

    private ParsedInterfaceCriteria(Set<InterfaceCriteria> criteria) {
        this.failureMessage = null;
        this.anyLocal = false;
        this.criteria.addAll(criteria);
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public boolean isAnyLocal() {
        return this.anyLocal;
    }

    public Set<InterfaceCriteria> getCriteria() {
        return this.criteria;
    }

    public static ParsedInterfaceCriteria parse(ModelNode model, boolean specified, ExpressionResolver expressionResolver) {
        ParsedInterfaceCriteria parsed;
        if (model.getType() != ModelType.OBJECT) {
            return new ParsedInterfaceCriteria(ControllerLogger.ROOT_LOGGER.illegalInterfaceCriteria(model.getType(), ModelType.OBJECT));
        }
        ModelNode subModel = model.clone();
        subModel.remove("operation");
        subModel.remove("address");
        subModel.remove("operation-headers");
        if (subModel.hasDefined("any-address") && subModel.get("any-address").asBoolean(false)) {
            parsed = ANY;
        } else {
            try {
                List nodes = subModel.asPropertyList();
                LinkedHashSet<InterfaceCriteria> criteriaSet = new LinkedHashSet<InterfaceCriteria>();
                for (Property property : nodes) {
                    InterfaceCriteria criterion = ParsedInterfaceCriteria.parseCriteria(property, false, expressionResolver);
                    if (criterion instanceof WildcardInetAddressInterfaceCriteria) {
                        if (nodes.size() > 1) {
                            ControllerLogger.MGMT_OP_LOGGER.wildcardAddressDetected();
                        }
                        return ANY;
                    }
                    if (criterion == null) continue;
                    criteriaSet.add(criterion);
                }
                String validation = new CriteriaValidator(criteriaSet).validate();
                parsed = validation == null ? new ParsedInterfaceCriteria(criteriaSet) : new ParsedInterfaceCriteria(validation);
            }
            catch (ParsingException p) {
                return new ParsedInterfaceCriteria(p.msg);
            }
            catch (OperationFailedException e) {
                return new ParsedInterfaceCriteria(e.getMessage());
            }
        }
        if (specified && parsed.getFailureMessage() == null && !parsed.isAnyLocal() && parsed.getCriteria().isEmpty()) {
            return new ParsedInterfaceCriteria(ControllerLogger.ROOT_LOGGER.noInterfaceCriteria());
        }
        return parsed;
    }

    private static InterfaceCriteria parseCriteria(Property property, boolean nested, ExpressionResolver expressionResolver) throws OperationFailedException {
        Element element = Element.forName(property.getName());
        switch (element) {
            case LINK_LOCAL_ADDRESS: {
                return LinkLocalInterfaceCriteria.INSTANCE;
            }
            case LOOPBACK: {
                return LoopbackInterfaceCriteria.INSTANCE;
            }
            case MULTICAST: {
                return SupportsMulticastInterfaceCriteria.INSTANCE;
            }
            case POINT_TO_POINT: {
                return PointToPointInterfaceCriteria.INSTANCE;
            }
            case PUBLIC_ADDRESS: {
                return PublicAddressInterfaceCriteria.INSTANCE;
            }
            case SITE_LOCAL_ADDRESS: {
                return SiteLocalInterfaceCriteria.INSTANCE;
            }
            case UP: {
                return UpInterfaceCriteria.INSTANCE;
            }
            case VIRTUAL: {
                return VirtualInterfaceCriteria.INSTANCE;
            }
            case INET_ADDRESS: {
                ModelNode value = ParsedInterfaceCriteria.parsePossibleExpression(property.getValue());
                ParsedInterfaceCriteria.checkStringType(value, element.getLocalName(), true);
                return ParsedInterfaceCriteria.createInetAddressCriteria(value, expressionResolver);
            }
            case LOOPBACK_ADDRESS: {
                ModelNode value = ParsedInterfaceCriteria.parsePossibleExpression(property.getValue());
                ParsedInterfaceCriteria.checkStringType(value, element.getLocalName(), true);
                return new LoopbackAddressInterfaceCriteria(ParsedInterfaceCriteria.parseInetAddress(value, expressionResolver));
            }
            case NIC: {
                ModelNode value = ParsedInterfaceCriteria.parsePossibleExpression(property.getValue());
                ParsedInterfaceCriteria.checkStringType(property.getValue(), element.getLocalName());
                return new NicInterfaceCriteria(expressionResolver.resolveExpressions(value).asString());
            }
            case NIC_MATCH: {
                ModelNode value = ParsedInterfaceCriteria.parsePossibleExpression(property.getValue());
                ParsedInterfaceCriteria.checkStringType(property.getValue(), element.getLocalName());
                return ParsedInterfaceCriteria.createNicMatchCriteria(expressionResolver.resolveExpressions(value));
            }
            case SUBNET_MATCH: {
                ModelNode value = ParsedInterfaceCriteria.parsePossibleExpression(property.getValue());
                return ParsedInterfaceCriteria.createSubnetMatchCriteria(expressionResolver.resolveExpressions(value));
            }
            case ANY: 
            case NOT: {
                if (nested) {
                    throw new ParsingException(ControllerLogger.ROOT_LOGGER.nestedElementNotAllowed(element));
                }
                return ParsedInterfaceCriteria.parseNested(property.getValue(), element == Element.ANY, expressionResolver);
            }
        }
        throw new ParsingException(ControllerLogger.ROOT_LOGGER.unknownCriteriaInterfaceType(property.getName()));
    }

    private static InterfaceCriteria parseNested(ModelNode subModel, boolean any, ExpressionResolver expressionResolver) throws OperationFailedException {
        if (!subModel.isDefined() || subModel.asInt() == 0) {
            return null;
        }
        LinkedHashSet<InterfaceCriteria> criteriaSet = new LinkedHashSet<InterfaceCriteria>();
        block3: for (Property nestedProperty : subModel.asPropertyList()) {
            Element element = Element.forName(nestedProperty.getName());
            switch (element) {
                case INET_ADDRESS: 
                case NIC: 
                case NIC_MATCH: 
                case SUBNET_MATCH: {
                    if (nestedProperty.getValue().getType() == ModelType.LIST) {
                        for (ModelNode item : nestedProperty.getValue().asList()) {
                            Property prop = new Property(nestedProperty.getName(), item);
                            InterfaceCriteria itemCriteria = ParsedInterfaceCriteria.parseCriteria(prop, true, expressionResolver);
                            if (itemCriteria == null) continue;
                            criteriaSet.add(itemCriteria);
                        }
                        continue block3;
                    }
                }
                default: {
                    InterfaceCriteria criteria = ParsedInterfaceCriteria.parseCriteria(nestedProperty, true, expressionResolver);
                    if (criteria == null) continue block3;
                    criteriaSet.add(criteria);
                }
            }
        }
        if (criteriaSet.isEmpty()) {
            return null;
        }
        return any ? new AnyInterfaceCriteria(criteriaSet) : new NotInterfaceCriteria(criteriaSet);
    }

    private static InterfaceCriteria createInetAddressCriteria(ModelNode model, ExpressionResolver expressionResolver) throws ParsingException, OperationFailedException {
        InetAddress address = ParsedInterfaceCriteria.parseInetAddress(model, expressionResolver);
        if (address.isAnyLocalAddress()) {
            return new WildcardInetAddressInterfaceCriteria(address);
        }
        if (address.isLoopbackAddress()) {
            return new LoopbackAddressInterfaceCriteria(address);
        }
        return new InetAddressMatchInterfaceCriteria(address);
    }

    private static InterfaceCriteria createNicMatchCriteria(ModelNode model) throws ParsingException {
        try {
            Pattern pattern = Pattern.compile(model.asString());
            return new NicMatchInterfaceCriteria(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ParsingException(ControllerLogger.ROOT_LOGGER.invalidInterfaceCriteriaPattern(model.asString(), Element.NIC_MATCH.getLocalName()));
        }
    }

    private static InterfaceCriteria createSubnetMatchCriteria(ModelNode model) throws ParsingException {
        String[] split = null;
        try {
            String value = model.asString();
            split = value.split("/");
            if (split.length != 2) {
                throw new ParsingException(ControllerLogger.ROOT_LOGGER.invalidAddressMaskValue(value));
            }
            InetAddress addr = InetAddress.getByName(split[0]);
            byte[] net = addr.getAddress();
            int mask = Integer.parseInt(split[1]);
            return new SubnetMatchInterfaceCriteria(net, mask);
        }
        catch (NumberFormatException e) {
            throw new ParsingException(ControllerLogger.ROOT_LOGGER.invalidAddressMask(split[1], e.getLocalizedMessage()));
        }
        catch (UnknownHostException e) {
            throw new ParsingException(ControllerLogger.ROOT_LOGGER.invalidAddressValue(split[0], e.getLocalizedMessage()));
        }
    }

    private static InetAddress parseInetAddress(ModelNode model, ExpressionResolver expressionResolver) throws OperationFailedException {
        String rawAddress = expressionResolver.resolveExpressions(model).asString();
        try {
            return InetAddress.getByName(rawAddress);
        }
        catch (UnknownHostException e) {
            throw new ParsingException(ControllerLogger.ROOT_LOGGER.invalidAddress(model.asString(), e.getLocalizedMessage()));
        }
    }

    private static void checkStringType(ModelNode node, String id) {
        ParsedInterfaceCriteria.checkStringType(node, id, false);
    }

    private static void checkStringType(ModelNode node, String id, boolean allowExpressions) {
        if (!(node.getType() == ModelType.STRING || allowExpressions && node.getType() == ModelType.EXPRESSION)) {
            throw new ParsingException(ControllerLogger.ROOT_LOGGER.illegalValueForInterfaceCriteria(node.getType(), id, ModelType.STRING));
        }
    }

    private static ModelNode parsePossibleExpression(ModelNode node) {
        return node.getType() == ModelType.STRING ? ParseUtils.parsePossibleExpression(node.asString()) : node;
    }

    private static class ParsingException
    extends RuntimeException {
        private static final long serialVersionUID = -5627251228393035383L;
        private final String msg;

        private ParsingException(String msg) {
            this.msg = msg;
        }
    }
}

