/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduitFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class AsyncHttpTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator {
    public static final List<String> DEFAULT_NAMESPACES = Collections.unmodifiableList(Arrays.asList("http://cxf.apache.org/transports/http/http-client"));
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    private AsyncHTTPConduitFactory factory = new AsyncHTTPConduitFactory();

    public AsyncHttpTransportFactory() {
        super(DEFAULT_NAMESPACES);
    }

    public void setAsyncHTTPConduitFactory(AsyncHTTPConduitFactory f) {
        this.factory = f;
    }

    public void setActivationNamespaces(Collection<String> ans) {
        this.setTransportIds(new ArrayList<String>(ans));
    }

    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    protected void configure(Bus b, Object bean) {
        this.configure(b, bean, null, null);
    }

    protected void configure(Bus bus, Object bean, String name, String extraName) {
        Configurer configurer = (Configurer)bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(name, bean);
            if (extraName != null) {
                configurer.configureBean(extraName, bean);
            }
        }
    }

    protected String getAddress(EndpointInfo endpointInfo) {
        String address = endpointInfo.getAddress();
        if (address.startsWith("hc://")) {
            address = address.substring(5);
        }
        return address;
    }

    public Conduit getConduit(EndpointInfo endpointInfo, Bus bus) throws IOException {
        return this.getConduit(endpointInfo, endpointInfo.getTarget(), bus);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target, Bus bus) throws IOException {
        HTTPConduitConfigurer c1;
        String address;
        HTTPConduit conduit = null;
        endpointInfo.setAddress(this.getAddress(endpointInfo));
        AsyncHTTPConduitFactory fact = (AsyncHTTPConduitFactory)bus.getExtension(AsyncHTTPConduitFactory.class);
        if (fact == null) {
            fact = this.factory;
        }
        if ((address = (conduit = fact.createConduit(bus, endpointInfo, target)).getAddress()) != null && address.indexOf(63) != -1) {
            address = address.substring(0, address.indexOf(63));
        }
        if ((c1 = (HTTPConduitConfigurer)bus.getExtension(HTTPConduitConfigurer.class)) != null) {
            c1.configure(conduit.getBeanName(), address, conduit);
        }
        this.configure(bus, conduit, conduit.getBeanName(), address);
        conduit.finalizeConfig();
        return conduit;
    }

    static {
        URI_PREFIXES.add("hc://");
    }
}

