/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.api.core.SimpleString;

public class DestinationUtil {
    public static final String QUEUE_QUALIFIED_PREFIX = "queue://";
    public static final String TOPIC_QUALIFIED_PREFIX = "topic://";
    public static final String TEMP_QUEUE_QUALIFED_PREFIX = "temp-queue://";
    public static final String TEMP_TOPIC_QUALIFED_PREFIX = "temp-topic://";
    public static final char SEPARATOR = '.';

    private static String escape(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace(".", "\\.");
    }

    public static String createQueueNameForSharedSubscription(boolean isDurable, String clientID, String subscriptionName) {
        if (clientID != null) {
            return (isDurable ? "Durable" : "nonDurable") + '.' + DestinationUtil.escape(clientID) + '.' + DestinationUtil.escape(subscriptionName);
        }
        return (isDurable ? "Durable" : "nonDurable") + '.' + DestinationUtil.escape(subscriptionName);
    }

    public static SimpleString createQueueNameForSubscription(boolean isDurable, String clientID, String subscriptionName) {
        String queueName = clientID != null ? (isDurable ? DestinationUtil.escape(clientID) + '.' + DestinationUtil.escape(subscriptionName) : "nonDurable." + DestinationUtil.escape(clientID) + '.' + DestinationUtil.escape(subscriptionName)) : (isDurable ? DestinationUtil.escape(subscriptionName) : "nonDurable." + DestinationUtil.escape(subscriptionName));
        return SimpleString.toSimpleString(queueName);
    }
}

