/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.Marshaller;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.protocols.FD_ALL;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.MERGE3;
import org.jgroups.protocols.MFC;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TCPPING;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UFC;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.VERIFY_SUSPECT;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.NonReflectiveProbeHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Bits;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class ProgrammaticUPerf2
extends ReceiverAdapter {
    private static final String groupname = "uperf";
    private static final JChannel channel;
    private static final RpcDispatcher disp;
    private static final String BIND_ADDR = "site_local";
    private static final String MCAST_ADDR = "232.5.5.5";
    private static Address local_addr;
    protected static final List<Address> members;
    protected static volatile View view;
    protected static NonReflectiveProbeHandler h;
    protected volatile boolean looping = true;
    protected Thread event_loop_thread;
    protected final LongAdder num_reads = new LongAdder();
    protected final LongAdder num_writes = new LongAdder();
    @Property
    protected static boolean sync;
    @Property
    protected static boolean oob;
    @Property
    protected static int num_threads;
    @Property
    protected static int time;
    @Property
    protected static int msg_size;
    @Property
    protected static int anycast_count;
    @Property
    protected static double read_percentage;
    @Property
    protected static boolean allow_local_gets;
    @Property
    protected static boolean print_invokers;
    @Property
    protected static boolean print_details;
    private static final short START = 0;
    private static final short GET = 1;
    private static final short PUT = 2;
    private static final short GET_CONFIG = 3;
    private static final short SET_SYNC = 4;
    private static final short SET_OOB = 5;
    private static final short SET_NUM_THREADS = 6;
    private static final short SET_TIME = 7;
    private static final short SET_MSG_SIZE = 8;
    private static final short SET_ANYCAST_COUNT = 9;
    private static final short SET_READ_PERCENTAGE = 10;
    private static final short ALLOW_LOCAL_GETS = 11;
    private static final short PRINT_INVOKERS = 12;
    private static final short PRINT_DETAILS = 13;
    private static final short QUIT_ALL = 14;
    private final AtomicInteger COUNTER = new AtomicInteger(1);
    private byte[] BUFFER = new byte[msg_size];
    protected static final String format = "[1] Start test [2] View [4] Threads (%d) [6] Time (%,ds) [7] Msg size (%s)\n[s] Sync (%b) [o] OOB (%b)\n[a] Anycast count (%d) [r] Read percentage (%.2f) \n[l] local gets (%b) [d] print details (%b)  [i] print invokers (%b)\n[v] Version [x] Exit [X] Exit all\n";

    public static boolean getSync() {
        return sync;
    }

    public static void setSync(boolean s) {
        sync = s;
    }

    public static boolean getOOB() {
        return oob;
    }

    public static void setOOB(boolean o) {
        oob = o;
    }

    public static int getNumThreads() {
        return num_threads;
    }

    public static void setNumThreads(int t) {
        num_threads = t;
    }

    public static int getTime() {
        return time;
    }

    public static void setTime(int t) {
        time = t;
    }

    public static int getMsgSize() {
        return msg_size;
    }

    public static void setMsgSize(int t) {
        msg_size = t;
    }

    public static int getAnycastCount() {
        return anycast_count;
    }

    public static void setAnycastCount(int t) {
        anycast_count = t;
    }

    public static double getReadPercentage() {
        return read_percentage;
    }

    public static void setReadPercentage(double r) {
        read_percentage = r;
    }

    public static boolean allowLocalGets() {
        return allow_local_gets;
    }

    public static void allowLocalGets(boolean a) {
        allow_local_gets = a;
    }

    public static boolean printInvokers() {
        return print_invokers;
    }

    public static void printInvokers(boolean p) {
        print_invokers = p;
    }

    public static boolean printDetails() {
        return print_details;
    }

    public static void printDetails(boolean p) {
        print_details = p;
    }

    public void init(String name, String bind_addr, int bind_port) throws Exception {
        TP transport = channel.getProtocolStack().getTransport();
        disp.setServerObject(this);
        channel.setName(name);
        if (bind_port > 0) {
            transport.setBindPort(bind_port);
        }
        if (bind_addr != null) {
            transport.setBindAddress(InetAddress.getByName(bind_addr));
        }
        channel.connect(groupname);
        DiagnosticsHandler diag_handler = transport.getDiagnosticsHandler();
        if (diag_handler != null) {
            Set<DiagnosticsHandler.ProbeHandler> probe_handlers = diag_handler.getProbeHandlers();
            probe_handlers.removeIf(probe_handler -> {
                String[] keys = probe_handler.supportedKeys();
                return keys != null && Stream.of(keys).anyMatch(s -> s.startsWith("jmx"));
            });
        }
        transport.registerProbeHandler(h);
        local_addr = channel.getAddress();
        if (members.size() < 2) {
            return;
        }
        Address coord = members.get(0);
        Config config = (Config)disp.callRemoteMethod(coord, new MethodCall(3, new Object[0]), new RequestOptions(ResponseMode.GET_ALL, 5000L));
        if (config != null) {
            ProgrammaticUPerf2.applyConfig(config);
            System.out.println("Fetched config from " + coord + ": " + config + "\n");
        } else {
            System.err.println("failed to fetch config from " + coord);
        }
    }

    static void stop() {
        Util.close(disp, channel);
    }

    protected void startEventThread() {
        this.event_loop_thread = new Thread(this::eventLoop, "EventLoop");
        this.event_loop_thread.setDaemon(true);
        this.event_loop_thread.start();
    }

    protected void stopEventThread() {
        Thread tmp = this.event_loop_thread;
        this.looping = false;
        if (tmp != null) {
            tmp.interrupt();
        }
        Util.close((Closeable)channel);
    }

    @Override
    public void viewAccepted(View v) {
        view = v;
        System.out.println("** view: " + v);
        members.clear();
        members.addAll(v.getMembers());
    }

    public static Object invoke(Object target, short method_id, Object[] args) throws Exception {
        ProgrammaticUPerf2 uperf = (ProgrammaticUPerf2)target;
        switch (method_id) {
            case 0: {
                return uperf.startTest();
            }
            case 1: {
                Integer key = (Integer)args[0];
                return uperf.get(key);
            }
            case 2: {
                Integer key = (Integer)args[0];
                byte[] val = (byte[])args[1];
                uperf.put(key, val);
                return null;
            }
            case 3: {
                return ProgrammaticUPerf2.getConfig();
            }
            case 4: {
                ProgrammaticUPerf2.setSync((Boolean)args[0]);
                return null;
            }
            case 5: {
                Boolean bool_val = (Boolean)args[0];
                ProgrammaticUPerf2.setOOB(bool_val);
                return null;
            }
            case 6: {
                ProgrammaticUPerf2.setNumThreads((Integer)args[0]);
                return null;
            }
            case 7: {
                ProgrammaticUPerf2.setTime((Integer)args[0]);
                return null;
            }
            case 8: {
                ProgrammaticUPerf2.setMsgSize((Integer)args[0]);
                return null;
            }
            case 9: {
                ProgrammaticUPerf2.setAnycastCount((Integer)args[0]);
                return null;
            }
            case 10: {
                ProgrammaticUPerf2.setReadPercentage((Double)args[0]);
                return null;
            }
            case 11: {
                ProgrammaticUPerf2.allowLocalGets((Boolean)args[0]);
                return null;
            }
            case 12: {
                ProgrammaticUPerf2.printInvokers((Boolean)args[0]);
                return null;
            }
            case 13: {
                ProgrammaticUPerf2.printDetails((Boolean)args[0]);
                return null;
            }
            case 14: {
                uperf.quitAll();
                return null;
            }
        }
        throw new IllegalArgumentException("method with id=" + method_id + " not found");
    }

    public Results startTest() throws Exception {
        this.BUFFER = new byte[msg_size];
        System.out.printf("running for %d seconds\n", time);
        CountDownLatch latch = new CountDownLatch(1);
        this.num_reads.reset();
        this.num_writes.reset();
        Invoker[] invokers = new Invoker[num_threads];
        for (int i = 0; i < invokers.length; ++i) {
            invokers[i] = new Invoker(members, latch);
            invokers[i].start();
        }
        long start = System.currentTimeMillis();
        latch.countDown();
        long interval = (long)((double)time * 1000.0 / 10.0);
        for (int i = 1; i <= 10; ++i) {
            Util.sleep(interval);
            System.out.printf("%d: %s\n", i, this.printAverage(start));
        }
        for (Invoker invoker : invokers) {
            invoker.cancel();
        }
        for (Invoker invoker : invokers) {
            invoker.join();
        }
        long total_time = System.currentTimeMillis() - start;
        System.out.println();
        AverageMinMax avg_gets = null;
        AverageMinMax avg_puts = null;
        for (Invoker invoker : invokers) {
            if (print_invokers) {
                System.out.printf("invoker %s: gets %s puts %s\n", invoker.getId(), ProgrammaticUPerf2.print(invoker.avgGets(), print_details), ProgrammaticUPerf2.print(invoker.avgPuts(), print_details));
            }
            if (avg_gets == null) {
                avg_gets = invoker.avgGets();
            } else {
                avg_gets.merge(invoker.avgGets());
            }
            if (avg_puts == null) {
                avg_puts = invoker.avgPuts();
                continue;
            }
            avg_puts.merge(invoker.avgPuts());
        }
        if (print_invokers) {
            System.out.printf("\navg over all invokers: gets %s puts %s\n", ProgrammaticUPerf2.print(avg_gets, print_details), ProgrammaticUPerf2.print(avg_puts, print_details));
        }
        System.out.printf("\ndone (in %s ms)\n", total_time);
        return new Results((int)this.num_reads.sum(), (int)this.num_writes.sum(), total_time, avg_gets, avg_puts);
    }

    public void quitAll() {
        System.out.println("-- received quitAll(): shutting down");
        this.stopEventThread();
    }

    protected String printAverage(long start_time) {
        long tmp_time = System.currentTimeMillis() - start_time;
        long reads = this.num_reads.sum();
        long writes = this.num_writes.sum();
        double reqs_sec = (double)(reads + writes) / ((double)tmp_time / 1000.0);
        return String.format("%,.0f reqs/sec (%,d reads %,d writes)", reqs_sec, reads, writes);
    }

    public byte[] get(int key) {
        return this.BUFFER;
    }

    public void put(int key, byte[] val) {
    }

    public static Config getConfig() {
        Config c = new Config();
        c.add("sync", sync).add("oob", oob).add("num_threads", num_threads).add("time", time).add("msg_size", msg_size).add("anycast_count", anycast_count).add("read_percentage", read_percentage).add("allow_local_gets", allow_local_gets).add("print_invokers", print_invokers).add("print_details", print_details);
        return c;
    }

    protected static void applyConfig(Config config) {
        block24: for (Map.Entry<String, Object> e : config.values.entrySet()) {
            String name = e.getKey();
            Object value = e.getValue();
            switch (name) {
                case "sync": {
                    ProgrammaticUPerf2.setSync((Boolean)value);
                    continue block24;
                }
                case "oob": {
                    ProgrammaticUPerf2.setOOB((Boolean)value);
                    continue block24;
                }
                case "num_threads": {
                    ProgrammaticUPerf2.setNumThreads((Integer)value);
                    continue block24;
                }
                case "time": {
                    ProgrammaticUPerf2.setTime((Integer)value);
                    continue block24;
                }
                case "msg_size": {
                    ProgrammaticUPerf2.setMsgSize((Integer)value);
                    continue block24;
                }
                case "anycast_count": {
                    ProgrammaticUPerf2.setAnycastCount((Integer)value);
                    continue block24;
                }
                case "read_percentage": {
                    ProgrammaticUPerf2.setReadPercentage((Double)value);
                    continue block24;
                }
                case "allow_local_gets": {
                    ProgrammaticUPerf2.allowLocalGets((Boolean)value);
                    continue block24;
                }
                case "print_invokers": {
                    ProgrammaticUPerf2.printInvokers((Boolean)value);
                    continue block24;
                }
                case "print_details": {
                    ProgrammaticUPerf2.printDetails((Boolean)value);
                    continue block24;
                }
            }
            throw new IllegalArgumentException("field with name " + name + " not known");
        }
    }

    public void eventLoop() {
        while (this.looping) {
            try {
                int c = Util.keyPress(String.format(format, num_threads, time, Util.printBytes(msg_size), sync, oob, anycast_count, read_percentage, allow_local_gets, print_details, print_invokers));
                switch (c) {
                    case 49: {
                        this.startBenchmark();
                        break;
                    }
                    case 50: {
                        ProgrammaticUPerf2.printView();
                        break;
                    }
                    case 52: {
                        ProgrammaticUPerf2.invoke((short)6, Util.readIntFromStdin("Number of sender threads: "));
                        break;
                    }
                    case 54: {
                        ProgrammaticUPerf2.invoke((short)7, Util.readIntFromStdin("Time (secs): "));
                        break;
                    }
                    case 55: {
                        ProgrammaticUPerf2.invoke((short)8, Util.readIntFromStdin("Message size: "));
                        break;
                    }
                    case 97: {
                        int tmp = ProgrammaticUPerf2.parseAnycastCount();
                        if (tmp < 0) break;
                        ProgrammaticUPerf2.invoke((short)9, tmp);
                        break;
                    }
                    case 111: {
                        ProgrammaticUPerf2.invoke((short)5, !oob);
                        break;
                    }
                    case 115: {
                        ProgrammaticUPerf2.invoke((short)4, !sync);
                        break;
                    }
                    case 114: {
                        double percentage = ProgrammaticUPerf2.parseReadPercentage();
                        if (!(percentage >= 0.0)) break;
                        ProgrammaticUPerf2.invoke((short)10, percentage);
                        break;
                    }
                    case 100: {
                        ProgrammaticUPerf2.invoke((short)13, !print_details);
                        break;
                    }
                    case 105: {
                        ProgrammaticUPerf2.invoke((short)12, !print_invokers);
                        break;
                    }
                    case 108: {
                        ProgrammaticUPerf2.invoke((short)11, !allow_local_gets);
                        break;
                    }
                    case 118: {
                        System.out.printf("Version: %s\n", Version.printVersion());
                        break;
                    }
                    case -1: 
                    case 120: {
                        this.looping = false;
                        break;
                    }
                    case 88: {
                        try {
                            RequestOptions options = new RequestOptions(ResponseMode.GET_NONE, 0L).flags(Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC);
                            disp.callRemoteMethods(null, new MethodCall(14, new Object[0]), options);
                        }
                        catch (Throwable t) {
                            System.err.println("Calling quitAll() failed: " + t);
                        }
                        break;
                    }
                    case 10: 
                    case 13: {
                        break;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        ProgrammaticUPerf2.stop();
    }

    protected static void invoke(short method_id, Object ... args) throws Exception {
        MethodCall call = new MethodCall(method_id, args);
        disp.callRemoteMethods(null, call, RequestOptions.SYNC());
    }

    protected void startBenchmark() {
        RspList responses = null;
        try {
            RequestOptions options = new RequestOptions(ResponseMode.GET_ALL, 0L);
            options.flags(Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC);
            responses = disp.callRemoteMethods(null, new MethodCall(0, new Object[0]), options);
        }
        catch (Throwable t) {
            System.err.println("starting the benchmark failed: " + t);
            return;
        }
        long total_reqs = 0L;
        long total_time = 0L;
        AverageMinMax avg_gets = null;
        AverageMinMax avg_puts = null;
        System.out.println("\n======================= Results: ===========================");
        for (Map.Entry entry : responses.entrySet()) {
            Address mbr = (Address)entry.getKey();
            Rsp rsp = (Rsp)entry.getValue();
            Results result = (Results)rsp.getValue();
            if (result != null) {
                total_reqs += result.num_gets + result.num_puts;
                total_time += result.total_time;
                if (avg_gets == null) {
                    avg_gets = result.avg_gets;
                } else {
                    avg_gets.merge(result.avg_gets);
                }
                if (avg_puts == null) {
                    avg_puts = result.avg_puts;
                } else {
                    avg_puts.merge(result.avg_puts);
                }
            }
            System.out.println(mbr + ": " + result);
        }
        double total_reqs_sec = (double)total_reqs / ((double)total_time / 1000.0);
        double throughput = total_reqs_sec * (double)this.BUFFER.length;
        System.out.println("\n");
        System.out.println(Util.bold(String.format("Throughput: %,.2f reqs/sec/node (%s/sec)\nRoundtrip:  gets %s, puts %s\n", total_reqs_sec, Util.printBytes(throughput), ProgrammaticUPerf2.print(avg_gets, print_details), ProgrammaticUPerf2.print(avg_puts, print_details))));
        System.out.println("\n\n");
    }

    static double parseReadPercentage() throws Exception {
        double tmp = Util.readDoubleFromStdin("Read percentage: ");
        if (tmp < 0.0 || tmp > 1.0) {
            System.err.println("read percentage must be >= 0 or <= 1.0");
            return -1.0;
        }
        return tmp;
    }

    protected static int parseAnycastCount() throws Exception {
        View tmp_view;
        int tmp = Util.readIntFromStdin("Anycast count: ");
        if (tmp > (tmp_view = channel.getView()).size()) {
            System.err.println("anycast count must be smaller or equal to the view size (" + tmp_view + ")\n");
            return -1;
        }
        return tmp;
    }

    protected static void printView() {
        System.out.printf("\n-- local: %s, view: %s\n", local_addr, view);
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static String print(AverageMinMax avg, boolean details) {
        return details ? String.format("min/avg/max = %,.2f/%,.2f/%,.2f us", (double)avg.min() / 1000.0, avg.average() / 1000.0, (double)avg.max() / 1000.0) : String.format("avg = %,.2f us", avg.average() / 1000.0);
    }

    public static void main(String[] args) {
        block8: {
            String name = null;
            String bind_addr = null;
            boolean run_event_loop = true;
            int port = 0;
            for (int i = 0; i < args.length; ++i) {
                if ("-name".equals(args[i])) {
                    name = args[++i];
                    continue;
                }
                if ("-nohup".equals(args[i])) {
                    run_event_loop = false;
                    continue;
                }
                if ("-port".equals(args[i])) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-bind_addr".equals(args[i])) {
                    bind_addr = args[++i];
                    continue;
                }
                ProgrammaticUPerf2.help();
                return;
            }
            ProgrammaticUPerf2 test = null;
            try {
                test = new ProgrammaticUPerf2();
                test.init(name, bind_addr, port);
                if (run_event_loop) {
                    test.startEventThread();
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (test == null) break block8;
                ProgrammaticUPerf2.stop();
            }
        }
    }

    static void help() {
        System.out.printf("%s [-name name] [-nohup] [-port <bind port>] [-bind_addr bind-address]\n", ProgrammaticUPerf2.class.getSimpleName());
    }

    static {
        local_addr = null;
        members = new ArrayList<Address>();
        view = null;
        sync = true;
        oob = true;
        num_threads = 100;
        time = 60;
        msg_size = 1000;
        anycast_count = 2;
        read_percentage = 0.8;
        allow_local_gets = true;
        print_invokers = false;
        print_details = false;
        try {
            MembershipListener ml = new MembershipListener(){

                @Override
                public void viewAccepted(View new_view) {
                    view = new_view;
                    System.out.println("** view: " + new_view);
                    members.clear();
                    members.addAll(new_view.getMembers());
                }
            };
            InetAddress bind_address = Util.getAddress(BIND_ADDR, Util.getIpStackType());
            InetAddress mcast_addr = Util.getAddress(MCAST_ADDR, Util.getIpStackType());
            Protocol[] prot_stack = new Protocol[]{((TP)((TP)((TP)((TP)new TCP().setBindAddress(bind_address)).setBindPort(7800)).setDiagnosticsEnabled(true)).diagEnableUdp(false)).diagEnableTcp(true), new TCPPING().initialHosts(Collections.singletonList(new InetSocketAddress(bind_address, 7800))), new MERGE3(), new FD_SOCK(), new FD_ALL(), new VERIFY_SUSPECT(), new NAKACK2(), new UNICAST3().setXmitTableNumRows(10).setXmitTableMsgsPerRow(50000).setAckThreshold(1000), new STABLE(), new GMS().setJoinTimeout(1000L), new UFC(), new MFC(), new FRAG2()};
            channel = new JChannel(prot_stack);
            disp = new RpcDispatcher(channel, (Object)null).setMembershipListener(ml).setMethodInvoker(ProgrammaticUPerf2::invoke).setMarshaller(new UPerfMarshaller());
            h = new NonReflectiveProbeHandler(channel).initialize(channel.getProtocolStack().getProtocols());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class Config
    implements Streamable {
        protected Map<String, Object> values = new HashMap<String, Object>();

        public Config add(String key, Object value) {
            this.values.put(key, value);
            return this;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeInt(this.values.size());
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                Bits.writeString(entry.getKey(), out);
                Util.objectToStream(entry.getValue(), out);
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = Bits.readString(in);
                Object value = Util.objectFromStream(in);
                if (key == null) continue;
                this.values.put(key, value);
            }
        }

        public String toString() {
            return this.values.toString();
        }
    }

    public static class Results
    implements Streamable {
        protected long num_gets;
        protected long num_puts;
        protected long total_time;
        protected AverageMinMax avg_gets;
        protected AverageMinMax avg_puts;

        public Results() {
        }

        public Results(int num_gets, int num_puts, long total_time, AverageMinMax avg_gets, AverageMinMax avg_puts) {
            this.num_gets = num_gets;
            this.num_puts = num_puts;
            this.total_time = total_time;
            this.avg_gets = avg_gets;
            this.avg_puts = avg_puts;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Bits.writeLong(this.num_gets, out);
            Bits.writeLong(this.num_puts, out);
            Bits.writeLong(this.total_time, out);
            Util.writeStreamable(this.avg_gets, out);
            Util.writeStreamable(this.avg_puts, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.num_gets = Bits.readLong(in);
            this.num_puts = Bits.readLong(in);
            this.total_time = Bits.readLong(in);
            this.avg_gets = Util.readStreamable(AverageMinMax::new, in);
            this.avg_puts = Util.readStreamable(AverageMinMax::new, in);
        }

        public String toString() {
            long total_reqs = this.num_gets + this.num_puts;
            double total_reqs_per_sec = (double)total_reqs / ((double)this.total_time / 1000.0);
            return String.format("%,.2f reqs/sec (%,d gets, %,d puts, get RTT %,.2f us, put RTT %,.2f us)", total_reqs_per_sec, this.num_gets, this.num_puts, this.avg_gets.average() / 1000.0, this.avg_puts.getAverage() / 1000.0);
        }
    }

    private class Invoker
    extends Thread {
        private final List<Address> dests = new ArrayList<Address>();
        private final CountDownLatch latch;
        private final AverageMinMax avg_gets = new AverageMinMax();
        private final AverageMinMax avg_puts = new AverageMinMax();
        private final List<Address> targets = new ArrayList<Address>(anycast_count);
        private volatile boolean running = true;

        public Invoker(Collection<Address> dests, CountDownLatch latch) {
            this.latch = latch;
            this.dests.addAll(dests);
            this.setName("Invoker-" + ProgrammaticUPerf2.this.COUNTER.getAndIncrement());
        }

        public AverageMinMax avgGets() {
            return this.avg_gets;
        }

        public AverageMinMax avgPuts() {
            return this.avg_puts;
        }

        public void cancel() {
            this.running = false;
        }

        @Override
        public void run() {
            Object[] put_args = new Object[]{0, ProgrammaticUPerf2.this.BUFFER};
            Object[] get_args = new Object[]{0};
            MethodCall get_call = new MethodCall(1, get_args);
            MethodCall put_call = new MethodCall(2, put_args);
            RequestOptions get_options = new RequestOptions(ResponseMode.GET_ALL, 40000L, false, null);
            RequestOptions put_options = new RequestOptions(sync ? ResponseMode.GET_ALL : ResponseMode.GET_NONE, 40000L, true, null);
            if (oob) {
                get_options.flags(Message.Flag.OOB);
                put_options.flags(Message.Flag.OOB);
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (this.running) {
                boolean get = Util.tossWeightedCoin(read_percentage);
                try {
                    if (get) {
                        Address target = this.pickTarget();
                        long start = System.nanoTime();
                        if (allow_local_gets && Objects.equals(target, local_addr)) {
                            ProgrammaticUPerf2.this.get(1);
                        } else {
                            disp.callRemoteMethod(target, get_call, get_options);
                        }
                        long get_time = System.nanoTime() - start;
                        this.avg_gets.add(get_time);
                        ProgrammaticUPerf2.this.num_reads.increment();
                        continue;
                    }
                    this.pickAnycastTargets(this.targets);
                    long start = System.nanoTime();
                    disp.callRemoteMethods(this.targets, put_call, put_options);
                    long put_time = System.nanoTime() - start;
                    this.avg_puts.add(put_time);
                    ProgrammaticUPerf2.this.num_writes.increment();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        private Address pickTarget() {
            return Util.pickRandomElement(this.dests);
        }

        private void pickAnycastTargets(List<Address> anycast_targets) {
            int index = this.dests.indexOf(local_addr);
            for (int i = index + 1; i < index + 1 + anycast_count; ++i) {
                int new_index = i % this.dests.size();
                Address tmp = this.dests.get(new_index);
                if (anycast_targets.contains(tmp)) continue;
                anycast_targets.add(tmp);
            }
        }
    }

    protected static class UPerfMarshaller
    implements Marshaller {
        protected static final byte NORMAL = 0;
        protected static final byte EXCEPTION = 1;
        protected static final byte CONFIG = 2;
        protected static final byte RESULTS = 3;

        protected UPerfMarshaller() {
        }

        @Override
        public int estimatedSize(Object arg) {
            if (arg == null) {
                return 2;
            }
            if (arg instanceof byte[]) {
                return msg_size + 24;
            }
            if (arg instanceof Long) {
                return 10;
            }
            return 50;
        }

        @Override
        public void objectToStream(Object obj, DataOutput out) throws IOException {
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                out.writeByte(1);
                out.writeUTF(t.getMessage());
                return;
            }
            if (obj instanceof Config) {
                out.writeByte(2);
                ((Config)obj).writeTo(out);
                return;
            }
            if (obj instanceof Results) {
                out.writeByte(3);
                ((Results)obj).writeTo(out);
                return;
            }
            out.writeByte(0);
            Util.objectToStream(obj, out);
        }

        @Override
        public Object objectFromStream(DataInput in) throws IOException, ClassNotFoundException {
            byte type = in.readByte();
            switch (type) {
                case 0: {
                    return Util.objectFromStream(in);
                }
                case 1: {
                    String message = in.readUTF();
                    return new RuntimeException(message);
                }
                case 2: {
                    Config cfg = new Config();
                    cfg.readFrom(in);
                    return cfg;
                }
                case 3: {
                    Results res = new Results();
                    res.readFrom(in);
                    return res;
                }
            }
            throw new IllegalArgumentException("type " + type + " not known");
        }
    }
}

