/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.ElytronMessages2;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.MaskedPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.MaskedPasswordSpec;

@Deprecated
public class OAuth2CredentialSource
implements CredentialSource {
    private final URL tokenEndpointUri;
    private final Consumer<Map<String, String>> authenticationHandler;
    private String scopes;
    private final Supplier<SSLContext> sslContextSupplier;
    private final Supplier<HostnameVerifier> hostnameVerifierSupplier;
    private static final char[] defaultKeyMaterial = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();

    public static Builder builder(URL tokenEndpointUrl) {
        return new Builder(tokenEndpointUrl);
    }

    private OAuth2CredentialSource(URL tokenEndpointUrl, Consumer<Map<String, String>> authenticationHandler, String scopes, Supplier<SSLContext> sslContextSupplier, Supplier<HostnameVerifier> hostnameVerifierSupplier) {
        this.tokenEndpointUri = Assert.checkNotNullParam("tokenEndpointUri", tokenEndpointUrl);
        if (this.isHttps(tokenEndpointUrl)) {
            Assert.checkNotNullParam("sslContextSupplier", sslContextSupplier);
        }
        this.authenticationHandler = Assert.checkNotNullParam("authenticationHandler", authenticationHandler);
        this.scopes = scopes;
        this.sslContextSupplier = sslContextSupplier;
        this.hostnameVerifierSupplier = hostnameVerifierSupplier;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        return BearerTokenCredential.class.isAssignableFrom(credentialType) ? SupportLevel.POSSIBLY_SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        if (BearerTokenCredential.class.isAssignableFrom(credentialType)) {
            try {
                HttpURLConnection connection = null;
                try {
                    connection = this.openConnection();
                    connection.setDoOutput(true);
                    connection.setRequestMethod("POST");
                    connection.setInstanceFollowRedirects(false);
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    this.authenticationHandler.accept(parameters);
                    if (this.scopes != null) {
                        parameters.put("scope", this.scopes);
                    }
                    byte[] paramBytes = this.buildParameters(parameters);
                    try (OutputStream outputStream = connection.getOutputStream();){
                        outputStream.write(paramBytes);
                    }
                    try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());){
                        Credential credential;
                        block32: {
                            JsonReader jsonReader = Json.createReader(inputStream);
                            try {
                                JsonObject jsonObject = jsonReader.readObject();
                                String accessToken = jsonObject.getString("access_token");
                                credential = (Credential)credentialType.cast(new BearerTokenCredential(accessToken));
                                if (jsonReader == null) break block32;
                                jsonReader.close();
                            }
                            catch (Throwable throwable) {
                                if (jsonReader != null) {
                                    try {
                                        jsonReader.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        return (C)credential;
                    }
                }
                catch (IOException ioe) {
                    InputStream errorStream = null;
                    if (connection != null && connection.getErrorStream() != null) {
                        errorStream = connection.getErrorStream();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8));){
                            StringBuffer response = reader.lines().reduce(new StringBuffer(), StringBuffer::append, (buffer1, buffer2) -> buffer1);
                            ElytronMessages2.saslOAuth2.errorf((Throwable)ioe, "Unexpected response from server [%s]. Response: [%s]", (Object)this.tokenEndpointUri, (Object)response);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw ElytronMessages2.saslOAuth2.mechUnableToHandleResponseFromServer(ioe);
                }
            }
            catch (Exception cause) {
                throw ElytronMessages2.saslOAuth2.mechCallbackHandlerFailedForUnknownReason(cause);
            }
        }
        return null;
    }

    private SSLContext resolveSSLContext() {
        if (!this.isHttps(this.tokenEndpointUri)) {
            return null;
        }
        return this.sslContextSupplier == null ? null : this.sslContextSupplier.get();
    }

    private HttpURLConnection openConnection() throws IOException {
        ElytronMessages2.saslOAuth2.debugf("Opening connection to [%s]", (Object)this.tokenEndpointUri);
        HttpURLConnection connection = (HttpURLConnection)this.tokenEndpointUri.openConnection();
        SSLContext sslContext = this.resolveSSLContext();
        if (sslContext != null) {
            HttpsURLConnection https = (HttpsURLConnection)connection;
            https.setSSLSocketFactory(sslContext.getSocketFactory());
            if (this.hostnameVerifierSupplier != null) {
                https.setHostnameVerifier(Assert.checkNotNullParam("hostnameVerifier", this.hostnameVerifierSupplier.get()));
            }
        }
        return connection;
    }

    private byte[] buildParameters(Map<String, String> parameters) {
        ByteStringBuilder params = new ByteStringBuilder();
        parameters.entrySet().stream().forEach(entry -> {
            if (params.length() > 0) {
                params.append('&');
            }
            params.append((String)entry.getKey()).append('=').append((String)entry.getValue());
        });
        return params.toArray();
    }

    private boolean isHttps(URL tokenEndpointUrl) {
        return "https".equals(tokenEndpointUrl.getProtocol());
    }

    public static class Builder {
        private final URL tokenEndpointUrl;
        private String scopes;
        private Supplier<SSLContext> sslContextSupplier = new Supplier<SSLContext>(){

            @Override
            public SSLContext get() {
                AuthenticationContextConfigurationClient contextConfigurationClient = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
                try {
                    return contextConfigurationClient.getSSLContext(tokenEndpointUrl.toURI(), AuthenticationContext.captureCurrent());
                }
                catch (Exception cause) {
                    throw ElytronMessages2.saslOAuth2.failedToObtainSSLContext(cause);
                }
            }
        };
        private Supplier<HostnameVerifier> hostnameVerifierSupplier;
        private Consumer<Map<String, String>> authenticationHandler;

        private Builder(URL tokenEndpointUrl) {
            this.tokenEndpointUrl = Assert.checkNotNullParam("tokenEndpointUrl", tokenEndpointUrl);
        }

        public Builder grantScopes(String scopes) {
            this.scopes = Assert.checkNotNullParam("scopes", scopes);
            return this;
        }

        public Builder useResourceOwnerPassword(String userName, String password) {
            this.configureAuthenticationHandler(parameters -> this.configureResourceOwnerCredentialsParameters((Map<String, String>)parameters, userName, password));
            return this;
        }

        public Builder clientCredentials(String id, String secret) {
            Assert.checkNotNullParam("id", id);
            Assert.checkNotNullParam("secret", secret);
            this.configureAuthenticationHandler(parameters -> {
                AuthenticationConfiguration configuration;
                AuthenticationContext context = AuthenticationContext.captureCurrent();
                AuthenticationContextConfigurationClient client = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
                CallbackHandler handler = client.getCallbackHandler(configuration = client.getAuthenticationConfiguration(URI.create(this.tokenEndpointUrl.toString()), context));
                if (handler != null) {
                    NameCallback nameCallback = new NameCallback("Username");
                    PasswordCallback passwordCallback = new PasswordCallback("Password", false);
                    try {
                        handler.handle(new Callback[]{nameCallback, passwordCallback});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String userName = nameCallback.getName();
                    char[] password = passwordCallback.getPassword();
                    if (userName != null && password != null) {
                        this.configureResourceOwnerCredentialsParameters((Map<String, String>)parameters, userName, String.valueOf(password));
                    }
                }
                this.configureClientCredentialsParameters((Map<String, String>)parameters, id, secret.toCharArray());
            });
            return this;
        }

        public Builder useResourceOwnerMaskedPassword(String userName, String maskedPassword, String algorithm, String initialKeyMaterial, int iterationCount, String salt, String initializationVector) throws NoSuchAlgorithmException, InvalidKeySpecException {
            String password = this.convertMaskedPasswordToClearText(maskedPassword, algorithm, initialKeyMaterial, iterationCount, salt, initializationVector);
            this.configureAuthenticationHandler(parameters -> this.configureResourceOwnerCredentialsParameters((Map<String, String>)parameters, userName, password));
            return this;
        }

        public Builder maskedClientCredentials(String id, String maskedSecret, String algorithm, String initialKeyMaterial, int iterationCount, String salt, String initializationVector) throws NoSuchAlgorithmException, InvalidKeySpecException {
            String secret = this.convertMaskedPasswordToClearText(maskedSecret, algorithm, initialKeyMaterial, iterationCount, salt, initializationVector);
            Assert.checkNotNullParam("id", id);
            Assert.checkNotNullParam("secret", secret);
            this.configureAuthenticationHandler(parameters -> {
                AuthenticationConfiguration configuration;
                AuthenticationContext context = AuthenticationContext.captureCurrent();
                AuthenticationContextConfigurationClient client = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
                CallbackHandler handler = client.getCallbackHandler(configuration = client.getAuthenticationConfiguration(URI.create(this.tokenEndpointUrl.toString()), context));
                if (handler != null) {
                    NameCallback nameCallback = new NameCallback("Username");
                    PasswordCallback passwordCallback = new PasswordCallback("Password", false);
                    try {
                        handler.handle(new Callback[]{nameCallback, passwordCallback});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String userName = nameCallback.getName();
                    char[] password = passwordCallback.getPassword();
                    if (userName != null && password != null) {
                        this.configureResourceOwnerCredentialsParameters((Map<String, String>)parameters, userName, String.valueOf(password));
                    }
                }
                this.configureClientCredentialsParameters((Map<String, String>)parameters, id, secret.toCharArray());
            });
            return this;
        }

        public Builder useSslContext(SSLContext sslContext) {
            Assert.checkNotNullParam("sslContext", sslContext);
            this.sslContextSupplier = () -> sslContext;
            return this;
        }

        public Builder useSslHostnameVerifier(HostnameVerifier hostnameVerifier) {
            Assert.checkNotNullParam("hostnameVerifier", hostnameVerifier);
            this.hostnameVerifierSupplier = () -> hostnameVerifier;
            return this;
        }

        public OAuth2CredentialSource build() {
            if (this.authenticationHandler == null) {
                this.authenticationHandler = parameters -> {
                    AuthenticationContext context = AuthenticationContext.captureCurrent();
                    AuthenticationContextConfigurationClient client = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
                    AuthenticationConfiguration configuration = client.getAuthenticationConfiguration(URI.create(this.tokenEndpointUrl.toString()), context);
                    CallbackHandler handler = client.getCallbackHandler(configuration);
                    NameCallback nameCallback = new NameCallback("Client ID");
                    PasswordCallback password1 = new PasswordCallback("Client Secret", false);
                    try {
                        handler.handle(new Callback[]{nameCallback, password1});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String userName = nameCallback.getName();
                    char[] password = password1.getPassword();
                    this.configureClientCredentialsParameters((Map<String, String>)parameters, userName, password);
                };
            }
            return new OAuth2CredentialSource(this.tokenEndpointUrl, this.authenticationHandler.andThen(parameters -> {
                if (!parameters.containsKey("client_id") || !parameters.containsKey("client_secret")) {
                    throw ElytronMessages2.saslOAuth2.oauth2ClientCredentialsNotProvided();
                }
            }), this.scopes, this.sslContextSupplier, this.hostnameVerifierSupplier);
        }

        private void configureClientCredentialsParameters(Map<String, String> parameters, String id, char[] secret) {
            parameters.putIfAbsent("grant_type", "client_credentials");
            parameters.put("client_id", Assert.checkNotNullParam("client_id", id));
            parameters.put("client_secret", Assert.checkNotNullParam("client_secret", secret == null ? null : String.valueOf(secret)));
        }

        private void configureResourceOwnerCredentialsParameters(Map<String, String> parameters, String userName, String password) {
            parameters.put("grant_type", "password");
            parameters.put("username", Assert.checkNotNullParam("userName", userName));
            parameters.put("password", Assert.checkNotNullParam("password", password));
        }

        private void configureAuthenticationHandler(Consumer<Map<String, String>> handler) {
            this.authenticationHandler = this.authenticationHandler == null ? handler : this.authenticationHandler.andThen(handler);
        }

        private String convertMaskedPasswordToClearText(String maskedPassword, String algorithm, String initialKeyMaterial, int iterationCount, String salt, String initializationVector) throws NoSuchAlgorithmException, InvalidKeySpecException {
            Assert.assertNotNull(maskedPassword);
            Assert.checkMinimumParameter("iterationCount", 1, iterationCount);
            Assert.assertNotNull(salt);
            byte[] finalMaskedSecretBytes = CodePointIterator.ofString(maskedPassword).base64Decode().drain();
            if (algorithm == null) {
                algorithm = "masked-MD5-DES";
            }
            char[] finalInitialKeyMaterial = initialKeyMaterial == null ? defaultKeyMaterial : initialKeyMaterial.toCharArray();
            byte[] finalSalt = CodePointIterator.ofString(salt).asUtf8().drain();
            byte[] finalInitializationVector = initializationVector == null ? null : CodePointIterator.ofString(initializationVector).base64Decode().drain();
            MaskedPasswordSpec spec = new MaskedPasswordSpec(finalInitialKeyMaterial, iterationCount, finalSalt, finalMaskedSecretBytes, finalInitializationVector);
            PasswordFactory factory = PasswordFactory.getInstance(algorithm);
            MaskedPassword password = factory.generatePassword(spec).castAs(MaskedPassword.class);
            ClearPasswordSpec clearSpec = factory.getKeySpec(password, ClearPasswordSpec.class);
            return String.valueOf(clearSpec.getEncodedPassword());
        }
    }
}

