/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.ServiceRegistrationException;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionServer;
import org.xnio.OptionMap;

public final class RemotingTransactionService {
    private final Endpoint endpoint;
    private final LocalTransactionContext transactionContext;
    private static final Attachments.Key<RemotingTransactionServer> KEY = new Attachments.Key<RemotingTransactionServer>(RemotingTransactionServer.class);

    RemotingTransactionService(Endpoint endpoint, LocalTransactionContext transactionContext) {
        this.endpoint = endpoint;
        this.transactionContext = transactionContext;
    }

    public Registration register() throws ServiceRegistrationException {
        return this.endpoint.registerService("txn", new OpenListener(){

            @Override
            public void channelOpened(Channel channel) {
                RemotingTransactionService.this.getServerForConnection(channel.getConnection()).openChannel(channel);
            }

            @Override
            public void registrationTerminated() {
            }
        }, OptionMap.EMPTY);
    }

    public RemotingTransactionServer getServerForConnection(Connection connection) {
        RemotingTransactionServer appearing;
        if (connection.getEndpoint() != this.endpoint) {
            throw Log.log.invalidConnectionEndpoint();
        }
        Attachments attachments = connection.getAttachments();
        RemotingTransactionServer server = attachments.getAttachment(KEY);
        if (server == null && (appearing = attachments.attachIfAbsent(KEY, server = new RemotingTransactionServer(this, connection))) != null) {
            server = appearing;
        }
        return server;
    }

    public LocalTransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Endpoint endpoint;
        private LocalTransactionContext transactionContext;

        Builder() {
        }

        public Builder setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setTransactionContext(LocalTransactionContext transactionContext) {
            this.transactionContext = transactionContext;
            return this;
        }

        public RemotingTransactionService build() {
            LocalTransactionContext transactionContext;
            Endpoint endpoint = this.endpoint;
            if (endpoint == null) {
                endpoint = Endpoint.getCurrent();
            }
            if ((transactionContext = this.transactionContext) == null) {
                transactionContext = LocalTransactionContext.getCurrent();
            }
            return new RemotingTransactionService(endpoint, transactionContext);
        }
    }
}

