/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.policy;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;

public interface AlterConfigPolicy
extends Configurable,
AutoCloseable {
    public void validate(RequestMetadata var1) throws PolicyViolationException;

    public static class RequestMetadata {
        private final ConfigResource resource;
        private final Map<String, String> configs;

        public RequestMetadata(ConfigResource resource, Map<String, String> configs) {
            this.resource = resource;
            this.configs = configs;
        }

        public Map<String, String> configs() {
            return this.configs;
        }

        public ConfigResource resource() {
            return this.resource;
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.configs);
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != o.getClass()) {
                return false;
            }
            RequestMetadata other = (RequestMetadata)o;
            return this.resource.equals(other.resource) && this.configs.equals(other.configs);
        }

        public String toString() {
            return "AlterConfigPolicy.RequestMetadata(resource=" + this.resource + ", configs=" + this.configs + ")";
        }
    }
}

