/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.calendar.model;

import com.stratelia.webactiv.calendar.model.Schedulable;
import com.stratelia.webactiv.calendar.model.SchedulableList;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class SchedulableGroup
extends SchedulableList {
    private static final SimpleDateFormat completeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");

    public boolean isOver(Schedulable schedule) {
        for (int i = 0; i < this.content.size(); ++i) {
            Schedulable sched = (Schedulable)this.content.elementAt(i);
            if (!sched.isOver(schedule)) continue;
            return true;
        }
        return false;
    }

    public boolean isOver(SchedulableGroup group) {
        for (int i = 0; i < this.content.size(); ++i) {
            Schedulable sched = (Schedulable)this.content.elementAt(i);
            if (!group.isOver(sched)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void add(Schedulable schedule) {
        this.content.add(schedule);
    }

    @Override
    public void add(SchedulableGroup group) {
        Vector toAdd = group.getContent();
        for (int i = 0; i < toAdd.size(); ++i) {
            this.content.add((Schedulable)toAdd.elementAt(i));
        }
    }

    public String getStartHour() {
        String result = null;
        for (int i = 0; i < this.content.size(); ++i) {
            Schedulable schedule = (Schedulable)this.content.elementAt(i);
            if (result == null) {
                result = schedule.getStartHour();
                continue;
            }
            if (schedule.getStartHour() == null || schedule.getStartHour().compareTo(result) >= 0) continue;
            result = schedule.getStartHour();
        }
        return result;
    }

    public String getEndHour() {
        String result = null;
        for (int i = 0; i < this.content.size(); ++i) {
            Schedulable schedule = (Schedulable)this.content.elementAt(i);
            if (result == null) {
                result = schedule.getEndHour();
                continue;
            }
            if (schedule.getEndHour() == null || schedule.getEndHour().compareTo(result) <= 0) continue;
            result = schedule.getEndHour();
        }
        return result;
    }

    @Override
    public Vector getContent() {
        return this.content;
    }

    public Vector getStartingSchedules(String hour) {
        Vector<Schedulable> result = new Vector<Schedulable>();
        for (int i = 0; i < this.content.size(); ++i) {
            Schedulable schedule;
            Object obj = this.content.elementAt(i);
            if (!(obj instanceof Schedulable) || !hour.equals((schedule = (Schedulable)obj).getStartHour())) continue;
            result.add(schedule);
        }
        return result;
    }

    public int getMinuteDuration() {
        try {
            Date startDate = completeFormat.parse("2000/01/01 " + this.getStartHour());
            Date endDate = completeFormat.parse("2000/01/01 " + this.getEndHour());
            long ms = endDate.getTime() - startDate.getTime();
            return (int)(ms / 60000L);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

