/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.task;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.personalorganizer.model.Attendee;
import org.silverpeas.core.personalorganizer.model.TodoDetail;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.Actor;
import org.silverpeas.core.workflow.api.task.Task;
import org.silverpeas.core.workflow.api.user.Replacement;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.notification.UserNotificationBuilder;
import org.silverpeas.core.workflow.engine.task.AbstractTaskManager;
import org.silverpeas.core.workflow.engine.task.TaskImpl;
import org.silverpeas.core.workflow.engine.user.UserImpl;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
public class TaskManagerImpl
extends AbstractTaskManager {
    private static final String MULTILANG_BUNDLE = "org.silverpeas.workflow.multilang.usernotification";
    @Inject
    private SilverpeasCalendar calendar;

    @Override
    public void assignTask(Task task, User delegator) throws WorkflowException {
        ComponentInst compoInst;
        String componentId = task.getProcessInstance().getModelId();
        try {
            compoInst = AdministrationServiceProvider.getAdminService().getComponentInst(componentId);
        }
        catch (AdminException e) {
            throw new WorkflowException("TaskManagerImpl.assignTask", "workflowEngine.EX_GET_COMPONENT_INST", (Exception)((Object)e));
        }
        TodoDetail todo = new TodoDetail();
        todo.setId(task.getProcessInstance().getInstanceId());
        todo.setSpaceId(compoInst.getDomainFatherId());
        todo.setComponentId(componentId);
        todo.setName("activite : " + task.getState().getLabel(task.getUserRoleName(), "fr"));
        if (delegator != null) {
            todo.setDelegatorId(delegator.getUserId());
        } else {
            SilverLogger.getLogger((Object)this).error("Undefined delegator for new task {0}", new Object[]{todo.getName()});
        }
        ArrayList<Attendee> attendees = new ArrayList<Attendee>();
        if (task.getUser() != null) {
            attendees.add(new Attendee(task.getUser().getUserId()));
            todo.setAttendees(attendees);
            todo.setExternalId(this.getExternalId(task));
            this.calendar.addToDo(todo);
        } else {
            List<User> users = StringUtil.isDefined((String)task.getGroupId()) ? task.getProcessInstance().getUsersInGroup(task.getGroupId()) : task.getProcessInstance().getUsersInRole(task.getUserRoleName());
            for (User user : users) {
                attendees.clear();
                attendees.add(new Attendee(user.getUserId()));
                todo.setAttendees(attendees);
                todo.setExternalId(this.getExternalId(task, user.getUserId()));
                this.calendar.addToDo(todo);
            }
        }
    }

    @Override
    public void unAssignTask(Task task) throws WorkflowException {
        String componentId = task.getProcessInstance().getModelId();
        if (task.getUser() != null) {
            this.calendar.removeToDoFromExternal(null, componentId, this.getExternalId(task));
        } else {
            String role = task.getUserRoleName();
            List<User> usersInRole = task.getProcessInstance().getUsersInRole(role);
            for (User userInRole : usersInRole) {
                TaskImpl taskImpl = new TaskImpl(userInRole, role, task.getProcessInstance(), task.getState());
                this.calendar.removeToDoFromExternal(null, componentId, this.getExternalId(taskImpl, userInRole.getUserId()));
            }
        }
    }

    @Override
    public String getProcessInstanceIdFromExternalTodoId(String externalTodoId) throws WorkflowException {
        return this.getProcessId(externalTodoId);
    }

    @Override
    public String getRoleNameFromExternalTodoId(String externalTodoId) throws WorkflowException {
        return this.getRoleName(externalTodoId);
    }

    @Override
    public void notifyActor(Task task, User sender, Actor user, String text, boolean linkDisabled) throws WorkflowException {
        String componentId = task.getProcessInstance().getModelId();
        ArrayList<String> userIds = new ArrayList<String>();
        String role = task.getUserRoleName();
        if (user != null && user.getUser() != null) {
            role = user.getUserRoleName();
            userIds.add(user.getUser().getUserId());
        } else if (StringUtil.isDefined((String)task.getGroupId())) {
            List<User> usersInGroup = task.getProcessInstance().getUsersInGroup(task.getGroupId());
            userIds.addAll(usersInGroup.stream().map(User::getUserId).collect(Collectors.toList()));
        } else {
            List<User> usersInRole = task.getProcessInstance().getUsersInRole(role);
            userIds.addAll(usersInRole.stream().map(User::getUserId).collect(Collectors.toList()));
        }
        this.sendNotification(userIds, task, sender, text, linkDisabled, null);
        for (String userId : userIds) {
            List substitutes = TaskManagerImpl.getSubstitutes(userId, role, componentId).stream().filter(s -> !userIds.contains(s.getUserId())).collect(Collectors.toList());
            for (User substitute : substitutes) {
                this.sendNotificationToSubstitute(substitute.getUserId(), task, sender, text, linkDisabled, userId);
            }
        }
    }

    private void sendNotificationToSubstitute(String userId, Task task, User sender, String text, boolean linkDisabled, String incumbentId) {
        LocalizationBundle bundle = ResourceLocator.getLocalizationBundle((String)MULTILANG_BUNDLE, (String)UserDetail.getById((String)userId).getUserPreferences().getLanguage());
        String incumbent = UserDetail.getById((String)incumbentId).getDisplayedName();
        String substituteMessage = text + "\n\n" + bundle.getStringWithParams("replacement.message.substitute.extra", new Object[]{incumbent});
        this.sendNotification(Collections.singletonList(userId), task, sender, substituteMessage, linkDisabled, incumbentId);
    }

    private void sendNotification(List<String> userIds, Task task, User sender, String text, boolean linkDisabled, String incumbentId) {
        new UserNotificationBuilder(userIds, task, sender, text, linkDisabled, incumbentId).build().send();
    }

    private String getExternalId(Task task) {
        return this.getExternalId(task, task.getUser().getUserId());
    }

    private String getExternalId(Task task, String userId) {
        return task.getProcessInstance().getInstanceId() + "##" + userId + "##" + task.getState().getName() + "##" + task.getUserRoleName();
    }

    private String getProcessId(String externalId) throws WorkflowException {
        return this.getItems(externalId)[0];
    }

    private String getRoleName(String externalId) throws WorkflowException {
        return this.getItems(externalId)[3];
    }

    private String[] getItems(String externalId) throws WorkflowException {
        String[] items = StringUtil.split((String)externalId, (String)"$$");
        if (items.length != 4) {
            throw new WorkflowException("TaskManagerImpl.getItems", "workflowEngine.EX_ERR_ILLEGAL_EXTERNALID", "external Id : " + externalId);
        }
        return items;
    }

    private static List<User> getSubstitutes(String userId, String role, String componentInstanceId) {
        UserImpl user = new UserImpl(UserDetail.getById((String)userId));
        return Replacement.getAllOf(user, componentInstanceId).stream().filterCurrentAt(LocalDate.now()).filterOnAtLeastOneRole(role).map(Replacement::getSubstitute).collect(Collectors.toList());
    }
}

