/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.workflow.api.model.ContextualDesignation;
import org.silverpeas.core.workflow.api.model.ContextualDesignations;
import org.silverpeas.core.workflow.api.model.Item;
import org.silverpeas.core.workflow.api.model.Parameter;
import org.silverpeas.core.workflow.engine.model.ParameterImpl;
import org.silverpeas.core.workflow.engine.model.SpecificLabel;
import org.silverpeas.core.workflow.engine.model.SpecificLabelListHelper;

@XmlRootElement(name="item")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ItemImpl
implements Item,
Serializable {
    @XmlID
    @XmlAttribute
    private String name;
    @XmlAttribute
    private boolean computed = false;
    @XmlElement(name="label", type=SpecificLabel.class)
    private List<ContextualDesignation> labels;
    @XmlElement(name="description", type=SpecificLabel.class)
    private List<ContextualDesignation> descriptions;
    @XmlElement
    private String type;
    @XmlElement
    private boolean readonly;
    @XmlElement
    private String formula;
    @XmlAttribute
    private String mapTo;
    @XmlElement(name="param", type=ParameterImpl.class)
    private List<Parameter> parameters;

    public ItemImpl() {
        this.reset();
    }

    private void reset() {
        this.labels = new ArrayList<ContextualDesignation>();
        this.descriptions = new ArrayList<ContextualDesignation>();
        this.parameters = new ArrayList<Parameter>();
    }

    @Override
    public boolean isComputed() {
        return this.computed;
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    @Override
    public String getMapTo() {
        return this.mapTo;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setComputed(boolean computed) {
        this.computed = computed;
    }

    @Override
    public void setFormula(String formula) {
        this.formula = formula;
    }

    @Override
    public void setMapTo(String mapTo) {
        this.mapTo = mapTo;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getDescription(String role, String language) {
        return this.getDescriptions().getLabel(role, language);
    }

    @Override
    public ContextualDesignations getDescriptions() {
        return new SpecificLabelListHelper(this.descriptions);
    }

    @Override
    public String getLabel(String role, String language) {
        return this.getLabels().getLabel(role, language);
    }

    @Override
    public ContextualDesignations getLabels() {
        return new SpecificLabelListHelper(this.labels);
    }

    @Override
    public Parameter getParameter(String strName) {
        ParameterImpl reference = new ParameterImpl();
        reference.setName(strName);
        int idx = this.parameters.indexOf(reference);
        if (idx >= 0) {
            return this.parameters.get(idx);
        }
        return null;
    }

    @Override
    public Parameter createParameter() {
        return new ParameterImpl();
    }

    @Override
    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public Iterator<Parameter> iterateParameter() {
        return this.parameters.iterator();
    }

    @Override
    public void removeParameter(String strName) {
        if (this.parameters == null) {
            return;
        }
        this.parameters.removeIf(p -> p.getName().equals(strName));
    }

    @Override
    public Map<String, String> getKeyValuePairs() {
        if (this.parameters != null && !this.parameters.isEmpty()) {
            String keys = null;
            String values = null;
            for (Parameter parameter : this.parameters) {
                if (parameter != null && "keys".equals(parameter.getName())) {
                    keys = parameter.getValue();
                }
                if (parameter == null || !"values".equals(parameter.getName())) continue;
                values = parameter.getValue();
            }
            return GenericFieldTemplate.computeKeyValuePairs(keys, values);
        }
        return Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemImpl)) {
            return false;
        }
        ItemImpl item = (ItemImpl)o;
        return this.name.equals(item.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

